/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem.constraint;

import com.graphhopper.jsprit.core.algorithm.state.InternalStates;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.constraint.HardActivityConstraint;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingActivityCosts;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingTransportCosts;
import com.graphhopper.jsprit.core.problem.misc.JobInsertionContext;
import com.graphhopper.jsprit.core.problem.solution.route.activity.End;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.problem.solution.route.state.RouteAndActivityStateGetter;

public class VehicleDependentTimeWindowConstraints
implements HardActivityConstraint {
    private RouteAndActivityStateGetter states;
    private VehicleRoutingTransportCosts routingCosts;
    private VehicleRoutingActivityCosts activityCosts;

    public VehicleDependentTimeWindowConstraints(RouteAndActivityStateGetter states, VehicleRoutingTransportCosts routingCosts, VehicleRoutingActivityCosts activityCosts) {
        this.states = states;
        this.routingCosts = routingCosts;
        this.activityCosts = activityCosts;
    }

    @Override
    public HardActivityConstraint.ConstraintsStatus fulfilled(JobInsertionContext iFacts, TourActivity prevAct, TourActivity newAct, TourActivity nextAct, double prevActDepTime) {
        Location nextActLocation;
        Double latestArrTimeAtNextAct;
        double latestVehicleArrival = iFacts.getNewVehicle().getLatestArrival();
        if (nextAct instanceof End) {
            latestArrTimeAtNextAct = latestVehicleArrival;
            nextActLocation = iFacts.getNewVehicle().getEndLocation();
            if (!iFacts.getNewVehicle().isReturnToDepot()) {
                nextActLocation = newAct.getLocation();
            }
        } else {
            latestArrTimeAtNextAct = this.states.getActivityState(nextAct, iFacts.getNewVehicle(), InternalStates.LATEST_OPERATION_START_TIME, Double.class);
            if (latestArrTimeAtNextAct == null) {
                latestArrTimeAtNextAct = nextAct.getTheoreticalLatestOperationStartTime();
            }
            nextActLocation = nextAct.getLocation();
        }
        double newAct_theoreticalEarliestOperationStartTime = newAct.getTheoreticalEarliestOperationStartTime();
        if (latestVehicleArrival < prevAct.getTheoreticalEarliestOperationStartTime() || latestVehicleArrival < newAct_theoreticalEarliestOperationStartTime || latestVehicleArrival < nextAct.getTheoreticalEarliestOperationStartTime()) {
            return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED_BREAK;
        }
        if (newAct.getTheoreticalLatestOperationStartTime() < prevAct.getTheoreticalEarliestOperationStartTime()) {
            return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED_BREAK;
        }
        double arrTimeAtNextOnDirectRouteWithNewVehicle = prevActDepTime + this.routingCosts.getTransportTime(prevAct.getLocation(), nextActLocation, prevActDepTime, iFacts.getNewDriver(), iFacts.getNewVehicle());
        if (arrTimeAtNextOnDirectRouteWithNewVehicle > latestArrTimeAtNextAct) {
            return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED_BREAK;
        }
        if (newAct.getTheoreticalEarliestOperationStartTime() > nextAct.getTheoreticalLatestOperationStartTime()) {
            return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED;
        }
        double arrTimeAtNewAct = prevActDepTime + this.routingCosts.getTransportTime(prevAct.getLocation(), newAct.getLocation(), prevActDepTime, iFacts.getNewDriver(), iFacts.getNewVehicle());
        double endTimeAtNewAct = Math.max(arrTimeAtNewAct, newAct.getTheoreticalEarliestOperationStartTime()) + this.activityCosts.getActivityDuration(newAct, arrTimeAtNewAct, iFacts.getNewDriver(), iFacts.getNewVehicle());
        double latestArrTimeAtNewAct = Math.min(newAct.getTheoreticalLatestOperationStartTime(), latestArrTimeAtNextAct - this.routingCosts.getBackwardTransportTime(newAct.getLocation(), nextActLocation, latestArrTimeAtNextAct, iFacts.getNewDriver(), iFacts.getNewVehicle()) - this.activityCosts.getActivityDuration(newAct, arrTimeAtNewAct, iFacts.getNewDriver(), iFacts.getNewVehicle()));
        if (arrTimeAtNewAct > latestArrTimeAtNewAct) {
            return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED;
        }
        if (nextAct instanceof End && !iFacts.getNewVehicle().isReturnToDepot()) {
            return HardActivityConstraint.ConstraintsStatus.FULFILLED;
        }
        double arrTimeAtNextAct = endTimeAtNewAct + this.routingCosts.getTransportTime(newAct.getLocation(), nextActLocation, endTimeAtNewAct, iFacts.getNewDriver(), iFacts.getNewVehicle());
        if (arrTimeAtNextAct > latestArrTimeAtNextAct) {
            return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED;
        }
        return HardActivityConstraint.ConstraintsStatus.FULFILLED;
    }
}

