/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem.solution;

import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import java.util.ArrayList;
import java.util.Collection;

public class VehicleRoutingProblemSolution {
    private final Collection<VehicleRoute> routes;
    private Collection<Job> unassignedJobs = new ArrayList<Job>();
    private double cost;

    public static VehicleRoutingProblemSolution copyOf(VehicleRoutingProblemSolution solution2copy) {
        return new VehicleRoutingProblemSolution(solution2copy);
    }

    private VehicleRoutingProblemSolution(VehicleRoutingProblemSolution solution) {
        this.routes = new ArrayList<VehicleRoute>();
        for (VehicleRoute r : solution.getRoutes()) {
            VehicleRoute route = VehicleRoute.copyOf(r);
            this.routes.add(route);
        }
        this.cost = solution.getCost();
        this.unassignedJobs.addAll(solution.getUnassignedJobs());
    }

    public VehicleRoutingProblemSolution(Collection<VehicleRoute> routes, double cost) {
        this.routes = routes;
        this.cost = cost;
    }

    public VehicleRoutingProblemSolution(Collection<VehicleRoute> routes, Collection<Job> unassignedJobs, double cost) {
        this.routes = routes;
        this.unassignedJobs = unassignedJobs;
        this.cost = cost;
    }

    public Collection<VehicleRoute> getRoutes() {
        return this.routes;
    }

    public double getCost() {
        return this.cost;
    }

    public void setCost(double cost) {
        this.cost = cost;
    }

    public Collection<Job> getUnassignedJobs() {
        return this.unassignedJobs;
    }

    public String toString() {
        return "[costs=" + this.cost + "][routes=" + this.routes.size() + "][unassigned=" + this.unassignedJobs.size() + "]";
    }
}

