/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem.solution.route.activity;

import com.graphhopper.jsprit.core.problem.AbstractActivity;
import com.graphhopper.jsprit.core.problem.Capacity;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.job.Delivery;
import com.graphhopper.jsprit.core.problem.solution.route.activity.Activities;
import com.graphhopper.jsprit.core.problem.solution.route.activity.DeliveryActivity;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;

public final class DeliverService
extends AbstractActivity
implements DeliveryActivity {
    private Delivery delivery;
    private Capacity capacity;
    private double arrTime;
    private double endTime;
    private double theoreticalEarliest = 0.0;
    private double theoreticalLatest = Double.MAX_VALUE;

    public DeliverService(Delivery delivery) {
        this.delivery = delivery;
        this.capacity = Capacity.invert(delivery.getSize());
    }

    private DeliverService(DeliverService deliveryActivity) {
        this.delivery = deliveryActivity.getJob();
        this.arrTime = deliveryActivity.getArrTime();
        this.endTime = deliveryActivity.getEndTime();
        this.capacity = deliveryActivity.getSize();
        this.setIndex(deliveryActivity.getIndex());
        this.theoreticalEarliest = deliveryActivity.getTheoreticalEarliestOperationStartTime();
        this.theoreticalLatest = deliveryActivity.getTheoreticalLatestOperationStartTime();
    }

    @Override
    public String getName() {
        return this.delivery.getType();
    }

    @Override
    public Location getLocation() {
        return this.delivery.getLocation();
    }

    @Override
    public void setTheoreticalEarliestOperationStartTime(double earliest) {
        this.theoreticalEarliest = earliest;
    }

    @Override
    public void setTheoreticalLatestOperationStartTime(double latest) {
        this.theoreticalLatest = latest;
    }

    @Override
    public double getTheoreticalEarliestOperationStartTime() {
        return this.theoreticalEarliest;
    }

    @Override
    public double getTheoreticalLatestOperationStartTime() {
        return this.theoreticalLatest;
    }

    @Override
    public double getOperationTime() {
        return this.delivery.getServiceDuration();
    }

    @Override
    public double getArrTime() {
        return this.arrTime;
    }

    @Override
    public double getEndTime() {
        return this.endTime;
    }

    @Override
    public void setArrTime(double arrTime) {
        this.arrTime = arrTime;
    }

    @Override
    public void setEndTime(double endTime) {
        this.endTime = endTime;
    }

    @Override
    public TourActivity duplicate() {
        return new DeliverService(this);
    }

    @Override
    public Delivery getJob() {
        return this.delivery;
    }

    public String toString() {
        return "[type=" + this.getName() + "][locationId=" + this.getLocation().getId() + "][size=" + this.getSize().toString() + "][twStart=" + Activities.round(this.getTheoreticalEarliestOperationStartTime()) + "][twEnd=" + Activities.round(this.getTheoreticalLatestOperationStartTime()) + "]";
    }

    @Override
    public Capacity getSize() {
        return this.capacity;
    }
}

