/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem.vehicle;

import com.graphhopper.jsprit.core.problem.Capacity;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;

public class VehicleTypeImpl
implements VehicleType {
    private final String typeId;
    private final String profile;
    private final VehicleCostParams vehicleCostParams;
    private final Capacity capacityDimensions;
    private final double maxVelocity;
    private Object userData;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VehicleTypeImpl)) {
            return false;
        }
        VehicleTypeImpl that = (VehicleTypeImpl)o;
        if (Double.compare(that.maxVelocity, this.maxVelocity) != 0) {
            return false;
        }
        if (!this.typeId.equals(that.typeId)) {
            return false;
        }
        if (this.profile != null ? !this.profile.equals(that.profile) : that.profile != null) {
            return false;
        }
        if (!this.vehicleCostParams.equals(that.vehicleCostParams)) {
            return false;
        }
        return this.capacityDimensions.equals(that.capacityDimensions);
    }

    public int hashCode() {
        int result = this.typeId.hashCode();
        result = 31 * result + (this.profile != null ? this.profile.hashCode() : 0);
        result = 31 * result + this.vehicleCostParams.hashCode();
        result = 31 * result + this.capacityDimensions.hashCode();
        long temp = Double.doubleToLongBits(this.maxVelocity);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    private VehicleTypeImpl(Builder builder) {
        this.userData = builder.userData;
        this.typeId = builder.id;
        this.maxVelocity = builder.maxVelo;
        this.vehicleCostParams = new VehicleCostParams(builder.fixedCost, builder.perTime, builder.perDistance, builder.perWaitingTime, builder.perServiceTime);
        this.capacityDimensions = builder.capacityDimensions;
        this.profile = builder.profile;
    }

    @Override
    public Object getUserData() {
        return this.userData;
    }

    @Override
    public String getTypeId() {
        return this.typeId;
    }

    @Override
    public VehicleCostParams getVehicleCostParams() {
        return this.vehicleCostParams;
    }

    public String toString() {
        return "[typeId=" + this.typeId + "][capacity=" + this.capacityDimensions + "][costs=" + this.vehicleCostParams + "]";
    }

    @Override
    public double getMaxVelocity() {
        return this.maxVelocity;
    }

    @Override
    public Capacity getCapacityDimensions() {
        return this.capacityDimensions;
    }

    @Override
    public String getProfile() {
        return this.profile;
    }

    public static class Builder {
        private String id;
        private double maxVelo = Double.MAX_VALUE;
        private double fixedCost = 0.0;
        private double perDistance = 1.0;
        private double perTime = 0.0;
        private double perWaitingTime = 0.0;
        private double perServiceTime = 0.0;
        private String profile = "car";
        private Capacity.Builder capacityBuilder = Capacity.Builder.newInstance();
        private Capacity capacityDimensions = null;
        private boolean dimensionAdded = false;
        private Object userData;

        public static Builder newInstance(String id) {
            if (id == null) {
                throw new IllegalArgumentException();
            }
            return new Builder(id);
        }

        private Builder(String id) {
            this.id = id;
        }

        public Builder setUserData(Object userData) {
            this.userData = userData;
            return this;
        }

        public Builder setMaxVelocity(double inMeterPerSeconds) {
            if (inMeterPerSeconds < 0.0) {
                throw new IllegalArgumentException("The velocity of a vehicle (type) cannot be smaller than zero.");
            }
            this.maxVelo = inMeterPerSeconds;
            return this;
        }

        public Builder setFixedCost(double fixedCost) {
            if (fixedCost < 0.0) {
                throw new IllegalArgumentException("Fixed costs must not be smaller than zero.");
            }
            this.fixedCost = fixedCost;
            return this;
        }

        public Builder setCostPerDistance(double perDistance) {
            if (perDistance < 0.0) {
                throw new IllegalArgumentException("Cost per distance must not be smaller than zero.");
            }
            this.perDistance = perDistance;
            return this;
        }

        @Deprecated
        public Builder setCostPerTime(double perTime) {
            if (perTime < 0.0) {
                throw new IllegalArgumentException();
            }
            this.perTime = perTime;
            return this;
        }

        public Builder setCostPerTransportTime(double perTime) {
            if (perTime < 0.0) {
                throw new IllegalArgumentException();
            }
            this.perTime = perTime;
            return this;
        }

        public Builder setCostPerWaitingTime(double perWaitingTime) {
            if (perWaitingTime < 0.0) {
                throw new IllegalArgumentException();
            }
            this.perWaitingTime = perWaitingTime;
            return this;
        }

        public Builder setCostPerServiceTime(double perServiceTime) {
            this.perServiceTime = perServiceTime;
            return this;
        }

        public VehicleTypeImpl build() {
            if (this.capacityDimensions == null) {
                this.capacityDimensions = this.capacityBuilder.build();
            }
            return new VehicleTypeImpl(this);
        }

        public Builder addCapacityDimension(int dimIndex, int dimVal) {
            if (dimVal < 0) {
                throw new IllegalArgumentException("The capacity value must not be negative.");
            }
            if (this.capacityDimensions != null) {
                throw new IllegalArgumentException("Either build your dimension with build your dimensions with addCapacityDimension(int dimIndex, int dimVal) or set the already built dimensions with .setCapacityDimensions(Capacity capacity).You used both methods.");
            }
            this.dimensionAdded = true;
            this.capacityBuilder.addDimension(dimIndex, dimVal);
            return this;
        }

        public Builder setCapacityDimensions(Capacity capacity) {
            if (this.dimensionAdded) {
                throw new IllegalArgumentException("Either build your dimension with build your dimensions with addCapacityDimension(int dimIndex, int dimVal) or set the already built dimensions with .setCapacityDimensions(Capacity capacity).You used both methods.");
            }
            this.capacityDimensions = capacity;
            return this;
        }

        public Builder setProfile(String profile) {
            this.profile = profile;
            return this;
        }
    }

    public static class VehicleCostParams {
        public final double fix;
        public final double perTransportTimeUnit;
        public final double perDistanceUnit;
        public final double perWaitingTimeUnit;
        public final double perServiceTimeUnit;

        public static VehicleCostParams newInstance(double fix, double perTimeUnit, double perDistanceUnit) {
            return new VehicleCostParams(fix, perTimeUnit, perDistanceUnit);
        }

        private VehicleCostParams(double fix, double perTimeUnit, double perDistanceUnit) {
            this.fix = fix;
            this.perTransportTimeUnit = perTimeUnit;
            this.perDistanceUnit = perDistanceUnit;
            this.perWaitingTimeUnit = 0.0;
            this.perServiceTimeUnit = 0.0;
        }

        public VehicleCostParams(double fix, double perTimeUnit, double perDistanceUnit, double perWaitingTimeUnit) {
            this.fix = fix;
            this.perTransportTimeUnit = perTimeUnit;
            this.perDistanceUnit = perDistanceUnit;
            this.perWaitingTimeUnit = perWaitingTimeUnit;
            this.perServiceTimeUnit = 0.0;
        }

        public VehicleCostParams(double fix, double perTimeUnit, double perDistanceUnit, double perWaitingTimeUnit, double perServiceTimeUnit) {
            this.fix = fix;
            this.perTransportTimeUnit = perTimeUnit;
            this.perDistanceUnit = perDistanceUnit;
            this.perWaitingTimeUnit = perWaitingTimeUnit;
            this.perServiceTimeUnit = perServiceTimeUnit;
        }

        public String toString() {
            return "[fixed=" + this.fix + "][perTime=" + this.perTransportTimeUnit + "][perDistance=" + this.perDistanceUnit + "][perWaitingTimeUnit=" + this.perWaitingTimeUnit + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof VehicleCostParams)) {
                return false;
            }
            VehicleCostParams that = (VehicleCostParams)o;
            if (Double.compare(that.fix, this.fix) != 0) {
                return false;
            }
            if (Double.compare(that.perTransportTimeUnit, this.perTransportTimeUnit) != 0) {
                return false;
            }
            if (Double.compare(that.perDistanceUnit, this.perDistanceUnit) != 0) {
                return false;
            }
            if (Double.compare(that.perWaitingTimeUnit, this.perWaitingTimeUnit) != 0) {
                return false;
            }
            return Double.compare(that.perServiceTimeUnit, this.perServiceTimeUnit) == 0;
        }

        public int hashCode() {
            long temp = Double.doubleToLongBits(this.fix);
            int result = (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.perTransportTimeUnit);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.perDistanceUnit);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.perWaitingTimeUnit);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.perServiceTimeUnit);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }
    }
}

