/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.util;

import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.cost.AbstractForwardVehicleRoutingTransportCosts;
import com.graphhopper.jsprit.core.problem.driver.Driver;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import com.graphhopper.jsprit.core.util.Coordinate;
import com.graphhopper.jsprit.core.util.EuclideanDistanceCalculator;

public class EuclideanCosts
extends AbstractForwardVehicleRoutingTransportCosts {
    public int speed = 1;
    public double detourFactor = 1.0;

    public String toString() {
        return "[name=crowFlyCosts]";
    }

    @Override
    public double getTransportCost(Location from, Location to, double time, Driver driver, Vehicle vehicle) {
        double distance = this.calculateDistance(from, to);
        if (vehicle != null && vehicle.getType() != null) {
            return distance * vehicle.getType().getVehicleCostParams().perDistanceUnit;
        }
        return distance;
    }

    double calculateDistance(Location fromLocation, Location toLocation) {
        return this.calculateDistance(fromLocation.getCoordinate(), toLocation.getCoordinate());
    }

    double calculateDistance(Coordinate from, Coordinate to) {
        try {
            return EuclideanDistanceCalculator.calculateDistance(from, to) * this.detourFactor;
        }
        catch (NullPointerException e) {
            throw new NullPointerException("cannot calculate euclidean distance. coordinates are missing. either add coordinates or use another transport-cost-calculator.");
        }
    }

    @Override
    public double getTransportTime(Location from, Location to, double time, Driver driver, Vehicle vehicle) {
        return this.calculateDistance(from, to) / (double)this.speed;
    }

    @Override
    public double getDistance(Location from, Location to, double departureTime, Vehicle vehicle) {
        return this.calculateDistance(from, to);
    }
}

