/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.acceptor;

import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.acceptor.SolutionAcceptor;
import com.graphhopper.jsprit.core.algorithm.listener.AlgorithmStartsListener;
import com.graphhopper.jsprit.core.algorithm.listener.IterationStartsListener;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchrimpfAcceptance
implements SolutionAcceptor,
IterationStartsListener,
AlgorithmStartsListener {
    private static Logger logger = LoggerFactory.getLogger((String)SchrimpfAcceptance.class.getName());
    private final double alpha;
    private int maxIterations = 1000;
    private int currentIteration = 0;
    private double initialThreshold = 0.0;
    private final int solutionMemory;

    public SchrimpfAcceptance(int solutionMemory, double alpha) {
        this.alpha = alpha;
        this.solutionMemory = solutionMemory;
        logger.debug("initialise {}", (Object)this);
    }

    @Override
    public boolean acceptSolution(Collection<VehicleRoutingProblemSolution> solutions, VehicleRoutingProblemSolution newSolution) {
        boolean solutionAccepted = false;
        if (solutions.size() < this.solutionMemory) {
            solutions.add(newSolution);
            solutionAccepted = true;
        } else {
            VehicleRoutingProblemSolution worst = null;
            double threshold = this.getThreshold(this.currentIteration);
            for (VehicleRoutingProblemSolution solutionInMemory : solutions) {
                if (worst == null) {
                    worst = solutionInMemory;
                    continue;
                }
                if (!(solutionInMemory.getCost() > worst.getCost())) continue;
                worst = solutionInMemory;
            }
            if (worst == null) {
                solutions.add(newSolution);
                solutionAccepted = true;
            } else if (newSolution.getCost() < worst.getCost() + threshold) {
                solutions.remove(worst);
                solutions.add(newSolution);
                solutionAccepted = true;
            }
        }
        return solutionAccepted;
    }

    public boolean acceptSolution(VehicleRoutingProblemSolution solution, VehicleRoutingProblemSolution newSolution) {
        ArrayList<VehicleRoutingProblemSolution> solutions = new ArrayList<VehicleRoutingProblemSolution>();
        solutions.add(solution);
        boolean solutionAccepted = false;
        if (solutions.size() < this.solutionMemory) {
            solutions.add(newSolution);
            solutionAccepted = true;
        } else {
            VehicleRoutingProblemSolution worst = null;
            double threshold = this.getThreshold(this.currentIteration);
            for (VehicleRoutingProblemSolution solutionInMemory : solutions) {
                if (worst == null) {
                    worst = solutionInMemory;
                    continue;
                }
                if (!(solutionInMemory.getCost() > worst.getCost())) continue;
                worst = solutionInMemory;
            }
            if (worst == null) {
                solutions.add(newSolution);
                solutionAccepted = true;
            } else if (newSolution.getCost() < worst.getCost() + threshold) {
                solutions.remove(worst);
                solutions.add(newSolution);
                solutionAccepted = true;
            }
        }
        return solutionAccepted;
    }

    public String toString() {
        return "[name=SchrimpfAcceptance][alpha=" + this.alpha + "]";
    }

    private double getThreshold(int iteration) {
        double scheduleVariable = (double)iteration / (double)this.maxIterations;
        return this.initialThreshold * Math.exp(-1.0 * Math.log(2.0) * scheduleVariable / this.alpha);
    }

    public double getInitialThreshold() {
        return this.initialThreshold;
    }

    public void setInitialThreshold(double initialThreshold) {
        this.initialThreshold = initialThreshold;
    }

    public void setMaxIterations(int maxIteration) {
        this.maxIterations = maxIteration;
    }

    public void incIteration() {
        ++this.currentIteration;
    }

    @Override
    public void informAlgorithmStarts(VehicleRoutingProblem problem, VehicleRoutingAlgorithm algorithm, Collection<VehicleRoutingProblemSolution> solutions) {
        this.reset();
        this.maxIterations = algorithm.getMaxIterations();
    }

    private void reset() {
        this.currentIteration = 0;
    }

    @Override
    public void informIterationStarts(int i, VehicleRoutingProblem problem, Collection<VehicleRoutingProblemSolution> solutions) {
        this.currentIteration = i;
    }
}

