/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.algorithm.recreate.InsertionData;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.InsertionStartsListener;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.JobInsertedListener;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import java.util.Collection;

class SolutionCompletenessRatio
implements InsertionStartsListener,
JobInsertedListener {
    protected double solutionCompletenessRatio = 0.5;
    private final int nuOfJobs;
    private int nuOfJobsToRecreate;

    public SolutionCompletenessRatio(int nuOfJobs) {
        this.nuOfJobs = nuOfJobs;
    }

    public void setSolutionCompletenessRatio(double ratio) {
        this.solutionCompletenessRatio = ratio;
    }

    public double getSolutionCompletenessRatio() {
        return this.solutionCompletenessRatio;
    }

    @Override
    public void informInsertionStarts(Collection<VehicleRoute> routes, Collection<Job> unassignedJobs) {
        this.nuOfJobsToRecreate = unassignedJobs.size();
        this.solutionCompletenessRatio = 1.0 - (double)this.nuOfJobsToRecreate / (double)this.nuOfJobs;
    }

    @Override
    public void informJobInserted(Job job2insert, VehicleRoute inRoute, InsertionData insertionData) {
        --this.nuOfJobsToRecreate;
        this.solutionCompletenessRatio = 1.0 - (double)this.nuOfJobsToRecreate / (double)this.nuOfJobs;
    }
}

