/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.ruin;

import com.graphhopper.jsprit.core.algorithm.ruin.AbstractRuinStrategy;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.util.NoiseMaker;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuinTimeRelated
extends AbstractRuinStrategy {
    private static final Logger logger = LoggerFactory.getLogger(RuinTimeRelated.class);
    private final VehicleRoutingProblem vrp;
    private NoiseMaker noiseMaker = () -> 0.0;

    public void setNoiseMaker(NoiseMaker noiseMaker) {
        this.noiseMaker = noiseMaker;
    }

    public RuinTimeRelated(VehicleRoutingProblem vrp) {
        super(vrp);
        this.vrp = vrp;
        this.ruinShareFactory = () -> (int)Math.max(50L, Math.round((double)vrp.getJobs().size() * 0.3));
        logger.debug("initialise {}", (Object)this);
    }

    @Override
    public Collection<Job> ruinRoutes(Collection<VehicleRoute> vehicleRoutes) {
        ArrayList<Job> unassignedJobs = new ArrayList<Job>();
        int totalActivities = 0;
        for (VehicleRoute route : vehicleRoutes) {
            totalActivities += route.getActivities().size();
        }
        if (totalActivities == 0) {
            return unassignedJobs;
        }
        int randomIndex = this.random.nextInt(totalActivities);
        int numActs = 0;
        TourActivity targetActivity = null;
        for (VehicleRoute route : vehicleRoutes) {
            if (numActs + route.getActivities().size() < randomIndex) {
                numActs += route.getActivities().size();
                continue;
            }
            for (TourActivity activity : route.getActivities()) {
                if (numActs == randomIndex) {
                    targetActivity = activity;
                    break;
                }
                ++numActs;
            }
            if (targetActivity == null) continue;
            break;
        }
        if (targetActivity == null) {
            return unassignedJobs;
        }
        ArrayList<RelatednessToTourActivity> neighborActivities = new ArrayList<RelatednessToTourActivity>();
        long maxTime = 0L;
        double maxDistance = 0.0;
        for (VehicleRoute route : vehicleRoutes) {
            for (TourActivity activity : route.getActivities()) {
                if (activity == targetActivity) continue;
                long absTime = Math.abs((long)targetActivity.getArrTime() - (long)activity.getArrTime());
                maxTime = Math.max(maxTime, absTime);
                double distance = Math.abs(this.vrp.getTransportCosts().getDistance(targetActivity.getLocation(), activity.getLocation(), 0.0, route.getVehicle()));
                maxDistance = Math.max(maxDistance, distance);
                neighborActivities.add(new RelatednessToTourActivity(absTime, distance, activity, route));
            }
        }
        double maxT = maxTime;
        double maxD = maxDistance;
        double timeInfluence = 10.0;
        double distanceInfluence = 1.0;
        double distanceI = this.random.nextDouble() < 0.5 ? 0.0 : distanceInfluence;
        neighborActivities.sort((o1, o2) -> {
            double rO1 = this.relatedness((RelatednessToTourActivity)o1, maxD, maxT, 10.0, distanceI);
            double rO2 = this.relatedness((RelatednessToTourActivity)o2, maxD, maxT, 10.0, distanceI);
            return Double.compare(rO1, rO2);
        });
        int toRemove = this.getRuinShareFactory().createNumberToBeRemoved();
        for (RelatednessToTourActivity neighborActivity : neighborActivities) {
            if (toRemove == 0) break;
            Job j = ((TourActivity.JobActivity)neighborActivity.tourActivity).getJob();
            if (!this.removeJob(j, neighborActivity.route)) continue;
            unassignedJobs.add(j);
            --toRemove;
        }
        return unassignedJobs;
    }

    private double relatedness(RelatednessToTourActivity o1, double maxDistance, double maxTime, double timeInfluence, double distanceInfluence) {
        double time = maxTime == 0.0 ? 0.0 : o1.time / maxTime;
        double distance = maxDistance == 0.0 ? 0.0 : o1.distance / maxDistance;
        return timeInfluence * time + distanceInfluence * distance;
    }

    public String toString() {
        return "[name=timeRelatedRuin]";
    }

    static class RelatednessToTourActivity {
        final double time;
        final TourActivity tourActivity;
        final VehicleRoute route;
        final double distance;

        public RelatednessToTourActivity(double relatednessToTarget, double distance, TourActivity tourActivity, VehicleRoute route) {
            this.time = relatednessToTarget;
            this.distance = distance;
            this.tourActivity = tourActivity;
            this.route = route;
        }
    }
}

