/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.ruin.distance;

import com.graphhopper.jsprit.core.algorithm.ruin.distance.JobDistance;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingTransportCosts;
import com.graphhopper.jsprit.core.problem.job.Activity;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.util.EuclideanDistanceCalculator;
import java.util.List;

public class AvgServiceAndShipmentDistance
implements JobDistance {
    private VehicleRoutingTransportCosts costs;

    public AvgServiceAndShipmentDistance(VehicleRoutingTransportCosts costs) {
        this.costs = costs;
    }

    @Override
    public double getDistance(Job i, Job j) {
        if (i.equals(j)) {
            return 0.0;
        }
        return this.calcDist(i.getActivities(), j.getActivities());
    }

    private double calcDist(List<Activity> iActivities, List<Activity> jActivities) {
        double sum = 0.0;
        for (Activity iActivity : iActivities) {
            for (Activity jActivity : jActivities) {
                sum += this.calcDist(iActivity.getLocation(), jActivity.getLocation());
            }
        }
        return sum / (double)(iActivities.size() * jActivities.size());
    }

    private double calcDist(Location location_i, Location location_j) {
        try {
            return this.costs.getTransportCost(location_i, location_j, 0.0, null, null);
        }
        catch (IllegalStateException illegalStateException) {
            return EuclideanDistanceCalculator.calculateDistance(location_i.getCoordinate(), location_j.getCoordinate());
        }
    }
}

