/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.state;

import com.graphhopper.jsprit.core.algorithm.recreate.InsertionData;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.InsertionStartsListener;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.JobInsertedListener;
import com.graphhopper.jsprit.core.algorithm.state.InternalStates;
import com.graphhopper.jsprit.core.algorithm.state.StateManager;
import com.graphhopper.jsprit.core.algorithm.state.StateUpdater;
import com.graphhopper.jsprit.core.problem.Capacity;
import com.graphhopper.jsprit.core.problem.job.Delivery;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.job.Pickup;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.ActivityVisitor;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import java.util.Collection;

class UpdateLoads
implements ActivityVisitor,
StateUpdater,
InsertionStartsListener,
JobInsertedListener {
    private StateManager stateManager;
    private Capacity currentLoad;
    private Capacity defaultValue;

    public UpdateLoads(StateManager stateManager) {
        this.stateManager = stateManager;
        this.defaultValue = Capacity.Builder.newInstance().build();
    }

    @Override
    public void begin(VehicleRoute route) {
        this.currentLoad = this.stateManager.getRouteState(route, InternalStates.LOAD_AT_BEGINNING, Capacity.class);
        if (this.currentLoad == null) {
            this.currentLoad = this.defaultValue;
        }
    }

    @Override
    public void visit(TourActivity act) {
        this.currentLoad = Capacity.addup(this.currentLoad, act.getSize());
        this.stateManager.putInternalTypedActivityState(act, InternalStates.LOAD, this.currentLoad);
    }

    @Override
    public void finish() {
        this.currentLoad = Capacity.Builder.newInstance().build();
    }

    void insertionStarts(VehicleRoute route) {
        Capacity loadAtDepot = Capacity.Builder.newInstance().build();
        Capacity loadAtEnd = Capacity.Builder.newInstance().build();
        for (Job j : route.getTourActivities().getJobs()) {
            if (j instanceof Delivery) {
                loadAtDepot = Capacity.addup(loadAtDepot, j.getSize());
                continue;
            }
            if (!(j instanceof Pickup) && !(j instanceof Service)) continue;
            loadAtEnd = Capacity.addup(loadAtEnd, j.getSize());
        }
        this.stateManager.putTypedInternalRouteState(route, InternalStates.LOAD_AT_BEGINNING, loadAtDepot);
        this.stateManager.putTypedInternalRouteState(route, InternalStates.LOAD_AT_END, loadAtEnd);
    }

    @Override
    public void informInsertionStarts(Collection<VehicleRoute> vehicleRoutes, Collection<Job> unassignedJobs) {
        for (VehicleRoute route : vehicleRoutes) {
            this.insertionStarts(route);
        }
    }

    @Override
    public void informJobInserted(Job job2insert, VehicleRoute inRoute, InsertionData insertionData) {
        if (job2insert instanceof Delivery) {
            Capacity loadAtDepot = this.stateManager.getRouteState(inRoute, InternalStates.LOAD_AT_BEGINNING, Capacity.class);
            if (loadAtDepot == null) {
                loadAtDepot = this.defaultValue;
            }
            this.stateManager.putTypedInternalRouteState(inRoute, InternalStates.LOAD_AT_BEGINNING, Capacity.addup(loadAtDepot, job2insert.getSize()));
        } else if (job2insert instanceof Pickup || job2insert instanceof Service) {
            Capacity loadAtEnd = this.stateManager.getRouteState(inRoute, InternalStates.LOAD_AT_END, Capacity.class);
            if (loadAtEnd == null) {
                loadAtEnd = this.defaultValue;
            }
            this.stateManager.putTypedInternalRouteState(inRoute, InternalStates.LOAD_AT_END, Capacity.addup(loadAtEnd, job2insert.getSize()));
        }
    }

    public void informRouteChanged(VehicleRoute route) {
        this.insertionStarts(route);
    }
}

