/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.state;

import com.graphhopper.jsprit.core.algorithm.state.InternalStates;
import com.graphhopper.jsprit.core.algorithm.state.StateManager;
import com.graphhopper.jsprit.core.algorithm.state.StateUpdater;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingActivityCosts;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingTransportCosts;
import com.graphhopper.jsprit.core.problem.solution.route.RouteVisitor;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class UpdateVehicleDependentPracticalTimeWindows
implements RouteVisitor,
StateUpdater {
    private VehiclesToUpdate vehiclesToUpdate = route -> Arrays.asList(route.getVehicle());
    private final StateManager stateManager;
    private final VehicleRoutingTransportCosts transportCosts;
    private final VehicleRoutingActivityCosts activityCosts;
    private VehicleRoute route;
    private double[] latest_arrTimes_at_prevAct;
    private Location[] location_of_prevAct;
    private Collection<Vehicle> vehicles;

    @Override
    public void visit(VehicleRoute route) {
        this.begin(route);
        Iterator<TourActivity> revIterator = route.getTourActivities().reverseActivityIterator();
        while (revIterator.hasNext()) {
            this.visit(revIterator.next());
        }
        this.finish();
    }

    public UpdateVehicleDependentPracticalTimeWindows(StateManager stateManager, VehicleRoutingTransportCosts tpCosts, VehicleRoutingActivityCosts activityCosts) {
        this.stateManager = stateManager;
        this.transportCosts = tpCosts;
        this.activityCosts = activityCosts;
        this.latest_arrTimes_at_prevAct = new double[stateManager.getMaxIndexOfVehicleTypeIdentifiers() + 1];
        this.location_of_prevAct = new Location[stateManager.getMaxIndexOfVehicleTypeIdentifiers() + 1];
    }

    public void setVehiclesToUpdate(VehiclesToUpdate vehiclesToUpdate) {
        this.vehiclesToUpdate = vehiclesToUpdate;
    }

    public void begin(VehicleRoute route) {
        this.route = route;
        this.vehicles = this.vehiclesToUpdate.get(route);
        for (Vehicle vehicle : this.vehicles) {
            this.latest_arrTimes_at_prevAct[vehicle.getVehicleTypeIdentifier().getIndex()] = vehicle.getLatestArrival();
            Location location = vehicle.getEndLocation();
            if (!vehicle.isReturnToDepot()) {
                location = route.getEnd().getLocation();
            }
            this.location_of_prevAct[vehicle.getVehicleTypeIdentifier().getIndex()] = location;
        }
    }

    public void visit(TourActivity activity) {
        for (Vehicle vehicle : this.vehicles) {
            double latestArrTimeAtPrevAct = this.latest_arrTimes_at_prevAct[vehicle.getVehicleTypeIdentifier().getIndex()];
            Location prevLocation = this.location_of_prevAct[vehicle.getVehicleTypeIdentifier().getIndex()];
            double potentialLatestArrivalTimeAtCurrAct = latestArrTimeAtPrevAct - this.transportCosts.getBackwardTransportTime(activity.getLocation(), prevLocation, latestArrTimeAtPrevAct, this.route.getDriver(), vehicle) - this.activityCosts.getActivityDuration(activity, latestArrTimeAtPrevAct, this.route.getDriver(), this.route.getVehicle());
            double latestArrivalTime = Math.min(activity.getTheoreticalLatestOperationStartTime(), potentialLatestArrivalTimeAtCurrAct);
            if (latestArrivalTime < activity.getTheoreticalEarliestOperationStartTime()) {
                this.stateManager.putTypedInternalRouteState(this.route, vehicle, InternalStates.SWITCH_NOT_FEASIBLE, true);
            }
            this.stateManager.putInternalTypedActivityState(activity, vehicle, InternalStates.LATEST_OPERATION_START_TIME, latestArrivalTime);
            this.latest_arrTimes_at_prevAct[vehicle.getVehicleTypeIdentifier().getIndex()] = latestArrivalTime;
            this.location_of_prevAct[vehicle.getVehicleTypeIdentifier().getIndex()] = activity.getLocation();
        }
    }

    public void finish() {
    }

    public static interface VehiclesToUpdate {
        public Collection<Vehicle> get(VehicleRoute var1);
    }
}

