/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.state;

import com.graphhopper.jsprit.core.algorithm.state.StateId;
import com.graphhopper.jsprit.core.algorithm.state.StateManager;
import com.graphhopper.jsprit.core.algorithm.state.StateUpdater;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.cost.TransportDistance;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.ActivityVisitor;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class VehicleDependentTraveledDistance
implements StateUpdater,
ActivityVisitor {
    private final TransportDistance transportDistance;
    private final StateManager stateManager;
    private final StateId traveledDistanceId;
    private VehicleRoute route;
    private List<Vehicle> uniqueVehicles;
    private Map<VehicleTypeKey, State> states;

    public VehicleDependentTraveledDistance(TransportDistance transportCostMatrices, StateManager stateManager, StateId distanceInRouteId, Collection<Vehicle> vehicles) {
        this.transportDistance = transportCostMatrices;
        this.stateManager = stateManager;
        this.traveledDistanceId = distanceInRouteId;
        this.uniqueVehicles = this.getUniqueVehicles(vehicles);
    }

    private List<Vehicle> getUniqueVehicles(Collection<Vehicle> vehicles) {
        HashSet<VehicleTypeKey> types = new HashSet<VehicleTypeKey>();
        ArrayList<Vehicle> uniqueVehicles = new ArrayList<Vehicle>();
        for (Vehicle v : vehicles) {
            if (types.contains(v.getVehicleTypeIdentifier())) continue;
            types.add(v.getVehicleTypeIdentifier());
            uniqueVehicles.add(v);
        }
        return uniqueVehicles;
    }

    @Override
    public void begin(VehicleRoute route) {
        this.route = route;
        this.states = new HashMap<VehicleTypeKey, State>();
        for (Vehicle v : this.uniqueVehicles) {
            State state = new State(v.getStartLocation(), 0.0);
            this.states.put(v.getVehicleTypeIdentifier(), state);
        }
    }

    @Override
    public void visit(TourActivity activity) {
        for (Vehicle v : this.uniqueVehicles) {
            State old = this.states.get(v.getVehicleTypeIdentifier());
            double distance = old.getDistance();
            this.stateManager.putActivityState(activity, v, this.traveledDistanceId, distance += this.transportDistance.getDistance(old.getPrevLocation(), activity.getLocation(), 0.0, v));
            this.states.put(v.getVehicleTypeIdentifier(), new State(activity.getLocation(), distance));
        }
    }

    @Override
    public void finish() {
        for (Vehicle v : this.uniqueVehicles) {
            State old = this.states.get(v.getVehicleTypeIdentifier());
            double distance = old.getDistance();
            if (v.isReturnToDepot()) {
                distance += this.transportDistance.getDistance(old.getPrevLocation(), v.getEndLocation(), 0.0, v);
            }
            this.stateManager.putRouteState(this.route, v, this.traveledDistanceId, distance);
        }
    }

    static class State {
        Location prevLocation;
        double distance;

        public State(Location prevLocation, double distance) {
            this.prevLocation = prevLocation;
            this.distance = distance;
        }

        public Location getPrevLocation() {
            return this.prevLocation;
        }

        public double getDistance() {
            return this.distance;
        }
    }
}

