/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.analysis;

import com.graphhopper.jsprit.core.algorithm.VariablePlusFixedSolutionCostCalculatorFactory;
import com.graphhopper.jsprit.core.algorithm.state.InternalStates;
import com.graphhopper.jsprit.core.algorithm.state.StateId;
import com.graphhopper.jsprit.core.algorithm.state.StateManager;
import com.graphhopper.jsprit.core.algorithm.state.StateUpdater;
import com.graphhopper.jsprit.core.algorithm.state.UpdateActivityTimes;
import com.graphhopper.jsprit.core.algorithm.state.UpdateVariableCosts;
import com.graphhopper.jsprit.core.problem.Capacity;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.cost.TransportDistance;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingActivityCosts;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingTransportCosts;
import com.graphhopper.jsprit.core.problem.solution.SolutionCostCalculator;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.ActivityVisitor;
import com.graphhopper.jsprit.core.problem.solution.route.activity.DeliverService;
import com.graphhopper.jsprit.core.problem.solution.route.activity.DeliverShipment;
import com.graphhopper.jsprit.core.problem.solution.route.activity.DeliveryActivity;
import com.graphhopper.jsprit.core.problem.solution.route.activity.End;
import com.graphhopper.jsprit.core.problem.solution.route.activity.PickupActivity;
import com.graphhopper.jsprit.core.problem.solution.route.activity.PickupService;
import com.graphhopper.jsprit.core.problem.solution.route.activity.PickupShipment;
import com.graphhopper.jsprit.core.problem.solution.route.activity.ServiceActivity;
import com.graphhopper.jsprit.core.problem.solution.route.activity.Start;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.util.ActivityTimeTracker;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolutionAnalyser {
    private static final String PICKUP_COUNT = "pickup-count";
    private static final String PICKUP_COUNT_AT_BEGINNING = "pickup-count-at-beginning";
    private static final String DELIVERY_COUNT = "delivery-count";
    private static final String DELIVERY_COUNT_AT_END = "delivery-count-at-end";
    private static final String LOAD_PICKED = "load-picked";
    private static final String LOAD_DELIVERED = "load-delivered";
    private static final Logger log = LoggerFactory.getLogger(SolutionAnalyser.class);
    private VehicleRoutingProblem vrp;
    private StateManager stateManager;
    private TransportDistance distanceCalculator;
    private StateId waitingTimeId;
    private StateId transportTimeId;
    private StateId serviceTimeId;
    private StateId distanceId;
    private StateId tooLateId;
    private StateId shipmentId;
    private StateId backhaulId;
    private StateId skillId;
    private StateId lastTransportDistanceId;
    private StateId lastTransportTimeId;
    private StateId lastTransportCostId;
    private ActivityTimeTracker.ActivityPolicy activityPolicy;
    private final SolutionCostCalculator solutionCostCalculator;
    private Double tp_distance;
    private Double tp_time;
    private Double waiting_time;
    private Double service_time;
    private Double operation_time;
    private Double tw_violation;
    private Capacity cap_violation;
    private Double fixed_costs;
    private Double variable_transport_costs;
    private Boolean hasSkillConstraintViolation;
    private Boolean hasBackhaulConstraintViolation;
    private Boolean hasShipmentConstraintViolation;
    private Integer noPickups;
    private Integer noPickupsAtBeginning;
    private Integer noDeliveries;
    private Integer noDeliveriesAtEnd;
    private Capacity pickupLoad;
    private Capacity pickupLoadAtBeginning;
    private Capacity deliveryLoad;
    private Capacity deliveryLoadAtEnd;
    private double maxOperationTime;
    private Double total_costs;
    private VehicleRoutingProblemSolution solution;

    public SolutionAnalyser(VehicleRoutingProblem vrp, VehicleRoutingProblemSolution solution, TransportDistance distanceCalculator) {
        this.vrp = vrp;
        this.solution = solution;
        this.distanceCalculator = distanceCalculator;
        this.initialise();
        this.solutionCostCalculator = new VariablePlusFixedSolutionCostCalculatorFactory(this.stateManager).createCalculator();
        this.refreshStates();
    }

    public SolutionAnalyser(VehicleRoutingProblem vrp, VehicleRoutingProblemSolution solution, SolutionCostCalculator solutionCostCalculator, TransportDistance distanceCalculator) {
        this.vrp = vrp;
        this.solution = solution;
        this.distanceCalculator = distanceCalculator;
        this.solutionCostCalculator = solutionCostCalculator;
        this.initialise();
        this.refreshStates();
    }

    private void initialise() {
        this.stateManager = new StateManager(this.vrp);
        this.stateManager.updateTimeWindowStates();
        this.stateManager.updateLoadStates();
        this.stateManager.updateSkillStates();
        this.activityPolicy = ActivityTimeTracker.ActivityPolicy.AS_SOON_AS_TIME_WINDOW_OPENS;
        this.stateManager.addStateUpdater(new UpdateActivityTimes(this.vrp.getTransportCosts(), this.activityPolicy, this.vrp.getActivityCosts()));
        this.stateManager.addStateUpdater(new UpdateVariableCosts(this.vrp.getActivityCosts(), this.vrp.getTransportCosts(), this.stateManager));
        this.waitingTimeId = this.stateManager.createStateId("waiting-time");
        this.transportTimeId = this.stateManager.createStateId("transport-time");
        this.serviceTimeId = this.stateManager.createStateId("service-time");
        this.distanceId = this.stateManager.createStateId("distance");
        this.tooLateId = this.stateManager.createStateId("too-late");
        this.shipmentId = this.stateManager.createStateId("shipment");
        this.backhaulId = this.stateManager.createStateId("backhaul");
        this.skillId = this.stateManager.createStateId("skills-violated");
        this.lastTransportCostId = this.stateManager.createStateId("last-transport-cost");
        this.lastTransportDistanceId = this.stateManager.createStateId("last-transport-distance");
        this.lastTransportTimeId = this.stateManager.createStateId("last-transport-time");
        this.stateManager.addStateUpdater(new SumUpActivityTimes(this.waitingTimeId, this.transportTimeId, this.serviceTimeId, this.tooLateId, this.stateManager, this.activityPolicy, this.vrp.getActivityCosts()));
        this.stateManager.addStateUpdater(new DistanceUpdater(this.distanceId, this.stateManager, this.distanceCalculator));
        this.stateManager.addStateUpdater(new BackhaulAndShipmentUpdater(this.backhaulId, this.shipmentId, this.stateManager));
        this.stateManager.addStateUpdater(new SkillUpdater(this.stateManager, this.skillId));
        this.stateManager.addStateUpdater(new LoadAndActivityCounter(this.stateManager));
        this.stateManager.addStateUpdater(new LastTransportUpdater(this.stateManager, this.vrp.getTransportCosts(), this.distanceCalculator, this.lastTransportDistanceId, this.lastTransportTimeId, this.lastTransportCostId));
    }

    private void refreshStates() {
        this.stateManager.clear();
        this.stateManager.informInsertionStarts(this.solution.getRoutes(), null);
        this.clearSolutionIndicators();
        this.recalculateSolutionIndicators();
    }

    private void recalculateSolutionIndicators() {
        for (VehicleRoute route : this.solution.getRoutes()) {
            this.maxOperationTime = Math.max(this.maxOperationTime, this.getOperationTime(route));
            this.tp_distance = this.tp_distance + this.getDistance(route);
            this.tp_time = this.tp_time + this.getTransportTime(route);
            this.waiting_time = this.waiting_time + this.getWaitingTime(route);
            this.service_time = this.service_time + this.getServiceTime(route);
            this.operation_time = this.operation_time + this.getOperationTime(route);
            this.tw_violation = this.tw_violation + this.getTimeWindowViolation(route);
            this.cap_violation = Capacity.addup(this.cap_violation, this.getCapacityViolation(route));
            this.fixed_costs = this.fixed_costs + this.getFixedCosts(route);
            this.variable_transport_costs = this.variable_transport_costs + this.getVariableTransportCosts(route);
            if (this.hasSkillConstraintViolation(route).booleanValue()) {
                this.hasSkillConstraintViolation = true;
            }
            if (this.hasShipmentConstraintViolation(route).booleanValue()) {
                this.hasShipmentConstraintViolation = true;
            }
            if (this.hasBackhaulConstraintViolation(route).booleanValue()) {
                this.hasBackhaulConstraintViolation = true;
            }
            this.noPickups = this.noPickups + this.getNumberOfPickups(route);
            this.noPickupsAtBeginning = this.noPickupsAtBeginning + this.getNumberOfPickupsAtBeginning(route);
            this.noDeliveries = this.noDeliveries + this.getNumberOfDeliveries(route);
            this.noDeliveriesAtEnd = this.noDeliveriesAtEnd + this.getNumberOfDeliveriesAtEnd(route);
            this.pickupLoad = Capacity.addup(this.pickupLoad, this.getLoadPickedUp(route));
            this.pickupLoadAtBeginning = Capacity.addup(this.pickupLoadAtBeginning, this.getLoadAtBeginning(route));
            this.deliveryLoad = Capacity.addup(this.deliveryLoad, this.getLoadDelivered(route));
            this.deliveryLoadAtEnd = Capacity.addup(this.deliveryLoadAtEnd, this.getLoadAtEnd(route));
        }
        this.total_costs = this.solutionCostCalculator.getCosts(this.solution);
    }

    private void clearSolutionIndicators() {
        this.maxOperationTime = 0.0;
        this.tp_distance = 0.0;
        this.tp_time = 0.0;
        this.waiting_time = 0.0;
        this.service_time = 0.0;
        this.operation_time = 0.0;
        this.tw_violation = 0.0;
        this.cap_violation = Capacity.Builder.newInstance().build();
        this.fixed_costs = 0.0;
        this.variable_transport_costs = 0.0;
        this.total_costs = 0.0;
        this.hasBackhaulConstraintViolation = false;
        this.hasShipmentConstraintViolation = false;
        this.hasSkillConstraintViolation = false;
        this.noPickups = 0;
        this.noPickupsAtBeginning = 0;
        this.noDeliveries = 0;
        this.noDeliveriesAtEnd = 0;
        this.pickupLoad = Capacity.Builder.newInstance().build();
        this.pickupLoadAtBeginning = Capacity.Builder.newInstance().build();
        this.deliveryLoad = Capacity.Builder.newInstance().build();
        this.deliveryLoadAtEnd = Capacity.Builder.newInstance().build();
    }

    public void informSolutionChanged(VehicleRoutingProblemSolution newSolution) {
        this.solution = newSolution;
        this.refreshStates();
    }

    public Capacity getLoadAtBeginning(VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        return this.stateManager.getRouteState(route, InternalStates.LOAD_AT_BEGINNING, Capacity.class);
    }

    public Capacity getLoadAtEnd(VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        return this.stateManager.getRouteState(route, InternalStates.LOAD_AT_END, Capacity.class);
    }

    public Capacity getMaxLoad(VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        return this.stateManager.getRouteState(route, InternalStates.MAXLOAD, Capacity.class);
    }

    public Capacity getLoadRightAfterActivity(TourActivity activity, VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        if (activity == null) {
            throw new IllegalArgumentException("activity is missing.");
        }
        if (activity instanceof Start) {
            return this.getLoadAtBeginning(route);
        }
        if (activity instanceof End) {
            return this.getLoadAtEnd(route);
        }
        this.verifyThatRouteContainsAct(activity, route);
        return this.stateManager.getActivityState(activity, InternalStates.LOAD, Capacity.class);
    }

    private void verifyThatRouteContainsAct(TourActivity activity, VehicleRoute route) {
        if (!route.getActivities().contains(activity)) {
            throw new IllegalArgumentException("specified route does not contain specified activity " + activity);
        }
    }

    public Capacity getLoadJustBeforeActivity(TourActivity activity, VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        if (activity == null) {
            throw new IllegalArgumentException("activity is missing.");
        }
        if (activity instanceof Start) {
            return this.getLoadAtBeginning(route);
        }
        if (activity instanceof End) {
            return this.getLoadAtEnd(route);
        }
        this.verifyThatRouteContainsAct(activity, route);
        Capacity afterAct = this.stateManager.getActivityState(activity, InternalStates.LOAD, Capacity.class);
        if (afterAct != null && activity.getSize() != null) {
            return Capacity.subtract(afterAct, activity.getSize());
        }
        if (afterAct != null) {
            return afterAct;
        }
        return null;
    }

    public Integer getNumberOfPickups(VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        return this.stateManager.getRouteState(route, this.stateManager.createStateId(PICKUP_COUNT), Integer.class);
    }

    public Integer getNumberOfDeliveries(VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        return this.stateManager.getRouteState(route, this.stateManager.createStateId(DELIVERY_COUNT), Integer.class);
    }

    public Capacity getLoadPickedUp(VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        return this.stateManager.getRouteState(route, this.stateManager.createStateId(LOAD_PICKED), Capacity.class);
    }

    public Capacity getLoadDelivered(VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        return this.stateManager.getRouteState(route, this.stateManager.createStateId(LOAD_DELIVERED), Capacity.class);
    }

    public Capacity getCapacityViolation(VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        Capacity maxLoad = this.getMaxLoad(route);
        return Capacity.max(Capacity.Builder.newInstance().build(), Capacity.subtract(maxLoad, route.getVehicle().getType().getCapacityDimensions()));
    }

    public Capacity getCapacityViolationAtBeginning(VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        Capacity atBeginning = this.getLoadAtBeginning(route);
        return Capacity.max(Capacity.Builder.newInstance().build(), Capacity.subtract(atBeginning, route.getVehicle().getType().getCapacityDimensions()));
    }

    public Capacity getCapacityViolationAtEnd(VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        Capacity atEnd = this.getLoadAtEnd(route);
        return Capacity.max(Capacity.Builder.newInstance().build(), Capacity.subtract(atEnd, route.getVehicle().getType().getCapacityDimensions()));
    }

    public Capacity getCapacityViolationAfterActivity(TourActivity activity, VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        if (activity == null) {
            throw new IllegalArgumentException("activity is missing.");
        }
        Capacity afterAct = this.getLoadRightAfterActivity(activity, route);
        return Capacity.max(Capacity.Builder.newInstance().build(), Capacity.subtract(afterAct, route.getVehicle().getType().getCapacityDimensions()));
    }

    public Double getTimeWindowViolation(VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        return this.stateManager.getRouteState(route, this.tooLateId, Double.class);
    }

    public Double getTimeWindowViolationAtActivity(TourActivity activity, VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        if (activity == null) {
            throw new IllegalArgumentException("activity is missing.");
        }
        return Math.max(0.0, activity.getArrTime() - activity.getTheoreticalLatestOperationStartTime());
    }

    public Boolean hasSkillConstraintViolation(VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        return this.stateManager.getRouteState(route, this.skillId, Boolean.class);
    }

    public Boolean hasSkillConstraintViolationAtActivity(TourActivity activity, VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        if (activity == null) {
            throw new IllegalArgumentException("activity is missing.");
        }
        if (activity instanceof Start) {
            return false;
        }
        if (activity instanceof End) {
            return false;
        }
        this.verifyThatRouteContainsAct(activity, route);
        return this.stateManager.getActivityState(activity, this.skillId, Boolean.class);
    }

    public Boolean hasBackhaulConstraintViolation(VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        return this.stateManager.getRouteState(route, this.backhaulId, Boolean.class);
    }

    public Boolean hasBackhaulConstraintViolationAtActivity(TourActivity activity, VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        if (activity == null) {
            throw new IllegalArgumentException("activity is missing.");
        }
        if (activity instanceof Start) {
            return false;
        }
        if (activity instanceof End) {
            return false;
        }
        this.verifyThatRouteContainsAct(activity, route);
        return this.stateManager.getActivityState(activity, this.backhaulId, Boolean.class);
    }

    public Boolean hasShipmentConstraintViolation(VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        return this.stateManager.getRouteState(route, this.shipmentId, Boolean.class);
    }

    public Boolean hasShipmentConstraintViolationAtActivity(TourActivity activity, VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        if (activity == null) {
            throw new IllegalArgumentException("activity is missing.");
        }
        if (activity instanceof Start) {
            return false;
        }
        if (activity instanceof End) {
            return false;
        }
        this.verifyThatRouteContainsAct(activity, route);
        return this.stateManager.getActivityState(activity, this.shipmentId, Boolean.class);
    }

    public Double getOperationTime(VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        return route.getEnd().getArrTime() - route.getStart().getEndTime();
    }

    public Double getWaitingTime(VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        return this.stateManager.getRouteState(route, this.waitingTimeId, Double.class);
    }

    public Double getTransportTime(VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        return this.stateManager.getRouteState(route, this.transportTimeId, Double.class);
    }

    public Double getServiceTime(VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        return this.stateManager.getRouteState(route, this.serviceTimeId, Double.class);
    }

    public Double getVariableTransportCosts(VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        return this.stateManager.getRouteState(route, InternalStates.COSTS, Double.class);
    }

    public Double getFixedCosts(VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        return route.getVehicle().getType().getVehicleCostParams().fix;
    }

    public Double getVariableTransportCostsAtActivity(TourActivity activity, VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        if (activity == null) {
            throw new IllegalArgumentException("activity is missing.");
        }
        if (activity instanceof Start) {
            return 0.0;
        }
        if (activity instanceof End) {
            return this.getVariableTransportCosts(route);
        }
        this.verifyThatRouteContainsAct(activity, route);
        return this.stateManager.getActivityState(activity, InternalStates.COSTS, Double.class);
    }

    public Double getTransportTimeAtActivity(TourActivity activity, VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        if (activity == null) {
            throw new IllegalArgumentException("activity is missing.");
        }
        if (activity instanceof Start) {
            return 0.0;
        }
        if (activity instanceof End) {
            return this.getTransportTime(route);
        }
        this.verifyThatRouteContainsAct(activity, route);
        return this.stateManager.getActivityState(activity, this.transportTimeId, Double.class);
    }

    public Double getLastTransportTimeAtActivity(TourActivity activity, VehicleRoute route) {
        return this.getLastTransport(activity, route, this.lastTransportTimeId);
    }

    public Double getLastTransportDistanceAtActivity(TourActivity activity, VehicleRoute route) {
        return this.getLastTransport(activity, route, this.lastTransportDistanceId);
    }

    public Double getLastTransportCostAtActivity(TourActivity activity, VehicleRoute route) {
        return this.getLastTransport(activity, route, this.lastTransportCostId);
    }

    private Double getLastTransport(TourActivity activity, VehicleRoute route, StateId id) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        if (activity == null) {
            throw new IllegalArgumentException("activity is missing.");
        }
        if (activity instanceof Start) {
            return 0.0;
        }
        if (activity instanceof End) {
            return this.stateManager.getRouteState(route, id, Double.class);
        }
        this.verifyThatRouteContainsAct(activity, route);
        return this.stateManager.getActivityState(activity, id, Double.class);
    }

    public Double getWaitingTimeAtActivity(TourActivity activity, VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        if (activity == null) {
            throw new IllegalArgumentException("activity is missing.");
        }
        double waitingTime = 0.0;
        if (this.activityPolicy.equals((Object)ActivityTimeTracker.ActivityPolicy.AS_SOON_AS_TIME_WINDOW_OPENS)) {
            waitingTime = Math.max(0.0, activity.getTheoreticalEarliestOperationStartTime() - activity.getArrTime());
        }
        return waitingTime;
    }

    public Double getDistance(VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        return this.stateManager.getRouteState(route, this.distanceId, Double.class);
    }

    public Double getDistanceAtActivity(TourActivity activity, VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        if (activity == null) {
            throw new IllegalArgumentException("activity is missing.");
        }
        if (activity instanceof Start) {
            return 0.0;
        }
        if (activity instanceof End) {
            return this.getDistance(route);
        }
        this.verifyThatRouteContainsAct(activity, route);
        return this.stateManager.getActivityState(activity, this.distanceId, Double.class);
    }

    public Integer getNumberOfPickups() {
        return this.noPickups;
    }

    public Integer getNumberOfPickupsAtBeginning(VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        return this.stateManager.getRouteState(route, this.stateManager.createStateId(PICKUP_COUNT_AT_BEGINNING), Integer.class);
    }

    public Integer getNumberOfPickupsAtBeginning() {
        return this.noPickupsAtBeginning;
    }

    public Integer getNumberOfDeliveries() {
        return this.noDeliveries;
    }

    public Integer getNumberOfDeliveriesAtEnd() {
        return this.noDeliveriesAtEnd;
    }

    public Integer getNumberOfDeliveriesAtEnd(VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route is missing.");
        }
        return this.stateManager.getRouteState(route, this.stateManager.createStateId(DELIVERY_COUNT_AT_END), Integer.class);
    }

    public Capacity getLoadPickedUp() {
        return this.pickupLoad;
    }

    public Capacity getLoadAtBeginning() {
        return this.pickupLoadAtBeginning;
    }

    public Capacity getLoadDelivered() {
        return this.deliveryLoad;
    }

    public Capacity getLoadAtEnd() {
        return this.deliveryLoadAtEnd;
    }

    public Double getDistance() {
        return this.tp_distance;
    }

    public Double getOperationTime() {
        return this.operation_time;
    }

    public Double getMaxOperationTime() {
        return this.maxOperationTime;
    }

    public Double getWaitingTime() {
        return this.waiting_time;
    }

    public Double getTransportTime() {
        return this.tp_time;
    }

    public Double getTimeWindowViolation() {
        return this.tw_violation;
    }

    public Capacity getCapacityViolation() {
        return this.cap_violation;
    }

    public Double getServiceTime() {
        return this.service_time;
    }

    public Double getFixedCosts() {
        return this.fixed_costs;
    }

    public Double getVariableTransportCosts() {
        return this.variable_transport_costs;
    }

    public Double getTotalCosts() {
        return this.total_costs;
    }

    public Boolean hasShipmentConstraintViolation() {
        return this.hasShipmentConstraintViolation;
    }

    public Boolean hasBackhaulConstraintViolation() {
        return this.hasBackhaulConstraintViolation;
    }

    public Boolean hasSkillConstraintViolation() {
        return this.hasSkillConstraintViolation;
    }

    private static class SkillUpdater
    implements StateUpdater,
    ActivityVisitor {
        private StateManager stateManager;
        private StateId skill_id;
        private VehicleRoute route;
        private boolean skillConstraintViolatedOnRoute;

        private SkillUpdater(StateManager stateManager, StateId skill_id) {
            this.stateManager = stateManager;
            this.skill_id = skill_id;
        }

        @Override
        public void begin(VehicleRoute route) {
            this.route = route;
            this.skillConstraintViolatedOnRoute = false;
        }

        @Override
        public void visit(TourActivity activity) {
            boolean violatedAtActivity = false;
            if (activity instanceof TourActivity.JobActivity) {
                Set<String> requiredForActivity = ((TourActivity.JobActivity)activity).getJob().getRequiredSkills().values();
                for (String skill : requiredForActivity) {
                    if (this.route.getVehicle().getSkills().containsSkill(skill)) continue;
                    violatedAtActivity = true;
                    this.skillConstraintViolatedOnRoute = true;
                }
            }
            this.stateManager.putActivityState(activity, this.skill_id, violatedAtActivity);
        }

        @Override
        public void finish() {
            this.stateManager.putRouteState(this.route, this.skill_id, this.skillConstraintViolatedOnRoute);
        }
    }

    private static class DistanceUpdater
    implements StateUpdater,
    ActivityVisitor {
        private StateId distanceId;
        private StateManager stateManager;
        private double sumDistance = 0.0;
        private TransportDistance distanceCalculator;
        private TourActivity prevAct;
        private VehicleRoute route;

        private DistanceUpdater(StateId distanceId, StateManager stateManager, TransportDistance distanceCalculator) {
            this.distanceId = distanceId;
            this.stateManager = stateManager;
            this.distanceCalculator = distanceCalculator;
        }

        @Override
        public void begin(VehicleRoute route) {
            this.sumDistance = 0.0;
            this.route = route;
            this.prevAct = route.getStart();
        }

        @Override
        public void visit(TourActivity activity) {
            double distance = this.distanceCalculator.getDistance(this.prevAct.getLocation(), activity.getLocation(), this.prevAct.getEndTime(), this.route.getVehicle());
            this.sumDistance += distance;
            this.stateManager.putActivityState(activity, this.distanceId, this.sumDistance);
            this.prevAct = activity;
        }

        @Override
        public void finish() {
            double distance = this.distanceCalculator.getDistance(this.prevAct.getLocation(), this.route.getEnd().getLocation(), this.prevAct.getEndTime(), this.route.getVehicle());
            this.sumDistance += distance;
            this.stateManager.putRouteState(this.route, this.distanceId, this.sumDistance);
        }
    }

    private static class LastTransportUpdater
    implements StateUpdater,
    ActivityVisitor {
        private final StateManager stateManager;
        private final VehicleRoutingTransportCosts transportCost;
        private final TransportDistance distanceCalculator;
        private final StateId last_transport_distance_id;
        private final StateId last_transport_time_id;
        private final StateId last_transport_cost_id;
        private TourActivity prevAct;
        private double prevActDeparture;
        private VehicleRoute route;

        private LastTransportUpdater(StateManager stateManager, VehicleRoutingTransportCosts transportCost, TransportDistance distanceCalculator, StateId last_distance_id, StateId last_time_id, StateId last_cost_id) {
            this.stateManager = stateManager;
            this.transportCost = transportCost;
            this.distanceCalculator = distanceCalculator;
            this.last_transport_distance_id = last_distance_id;
            this.last_transport_time_id = last_time_id;
            this.last_transport_cost_id = last_cost_id;
        }

        @Override
        public void begin(VehicleRoute route) {
            this.route = route;
            this.prevAct = route.getStart();
            this.prevActDeparture = route.getDepartureTime();
        }

        @Override
        public void visit(TourActivity activity) {
            this.stateManager.putActivityState(activity, this.last_transport_distance_id, this.distance(activity));
            this.stateManager.putActivityState(activity, this.last_transport_time_id, this.transportTime(activity));
            this.stateManager.putActivityState(activity, this.last_transport_cost_id, this.transportCost(activity));
            this.prevAct = activity;
            this.prevActDeparture = activity.getEndTime();
        }

        private double transportCost(TourActivity activity) {
            return this.transportCost.getTransportCost(this.prevAct.getLocation(), activity.getLocation(), this.prevActDeparture, this.route.getDriver(), this.route.getVehicle());
        }

        private double transportTime(TourActivity activity) {
            return activity.getArrTime() - this.prevActDeparture;
        }

        private double distance(TourActivity activity) {
            return this.distanceCalculator.getDistance(this.prevAct.getLocation(), activity.getLocation(), this.prevActDeparture, this.route.getVehicle());
        }

        @Override
        public void finish() {
            this.stateManager.putRouteState(this.route, this.last_transport_distance_id, this.distance(this.route.getEnd()));
            this.stateManager.putRouteState(this.route, this.last_transport_time_id, this.transportTime(this.route.getEnd()));
            this.stateManager.putRouteState(this.route, this.last_transport_cost_id, this.transportCost(this.route.getEnd()));
        }
    }

    private static class SumUpActivityTimes
    implements StateUpdater,
    ActivityVisitor {
        private StateId waiting_time_id;
        private StateId transport_time_id;
        private StateId service_time_id;
        private StateId too_late_id;
        private StateManager stateManager;
        private final VehicleRoutingActivityCosts activityCosts;
        private ActivityTimeTracker.ActivityPolicy activityPolicy;
        private VehicleRoute route;
        double sum_waiting_time = 0.0;
        double sum_transport_time = 0.0;
        double sum_service_time = 0.0;
        double sum_too_late = 0.0;
        double prevActDeparture;

        private SumUpActivityTimes(StateId waiting_time_id, StateId transport_time_id, StateId service_time_id, StateId too_late_id, StateManager stateManager, ActivityTimeTracker.ActivityPolicy activityPolicy, VehicleRoutingActivityCosts activityCosts) {
            this.waiting_time_id = waiting_time_id;
            this.transport_time_id = transport_time_id;
            this.service_time_id = service_time_id;
            this.too_late_id = too_late_id;
            this.stateManager = stateManager;
            this.activityPolicy = activityPolicy;
            this.activityCosts = activityCosts;
        }

        @Override
        public void begin(VehicleRoute route) {
            this.route = route;
            this.sum_waiting_time = 0.0;
            this.sum_transport_time = 0.0;
            this.sum_service_time = 0.0;
            this.sum_too_late = 0.0;
            this.prevActDeparture = route.getDepartureTime();
        }

        @Override
        public void visit(TourActivity activity) {
            double waitAtAct = 0.0;
            double tooLate = 0.0;
            if (this.activityPolicy.equals((Object)ActivityTimeTracker.ActivityPolicy.AS_SOON_AS_TIME_WINDOW_OPENS)) {
                waitAtAct = Math.max(0.0, activity.getTheoreticalEarliestOperationStartTime() - activity.getArrTime());
                tooLate = Math.max(0.0, activity.getArrTime() - activity.getTheoreticalLatestOperationStartTime());
            }
            this.sum_waiting_time += waitAtAct;
            this.sum_too_late += tooLate;
            double transportTime = activity.getArrTime() - this.prevActDeparture;
            this.sum_transport_time += transportTime;
            this.prevActDeparture = activity.getEndTime();
            this.sum_service_time += this.activityCosts.getActivityDuration(activity, activity.getArrTime(), this.route.getDriver(), this.route.getVehicle());
            this.stateManager.putActivityState(activity, this.transport_time_id, this.sum_transport_time);
        }

        @Override
        public void finish() {
            this.sum_transport_time += this.route.getEnd().getArrTime() - this.prevActDeparture;
            this.sum_too_late += Math.max(0.0, this.route.getEnd().getArrTime() - this.route.getEnd().getTheoreticalLatestOperationStartTime());
            this.stateManager.putRouteState(this.route, this.transport_time_id, this.sum_transport_time);
            this.stateManager.putRouteState(this.route, this.waiting_time_id, this.sum_waiting_time);
            this.stateManager.putRouteState(this.route, this.service_time_id, this.sum_service_time);
            this.stateManager.putRouteState(this.route, this.too_late_id, this.sum_too_late);
        }
    }

    private static class BackhaulAndShipmentUpdater
    implements StateUpdater,
    ActivityVisitor {
        private final StateId backhaul_id;
        private final StateId shipment_id;
        private final StateManager stateManager;
        private Map<String, PickupShipment> openShipments;
        private VehicleRoute route;
        private Boolean shipmentConstraintOnRouteViolated;
        private Boolean backhaulConstraintOnRouteViolated;
        private boolean pickupOccured;

        private BackhaulAndShipmentUpdater(StateId backhaul_id, StateId shipment_id, StateManager stateManager) {
            this.stateManager = stateManager;
            this.backhaul_id = backhaul_id;
            this.shipment_id = shipment_id;
        }

        @Override
        public void begin(VehicleRoute route) {
            this.route = route;
            this.openShipments = new HashMap<String, PickupShipment>();
            this.pickupOccured = false;
            this.shipmentConstraintOnRouteViolated = false;
            this.backhaulConstraintOnRouteViolated = false;
        }

        @Override
        public void visit(TourActivity activity) {
            if (activity instanceof PickupShipment) {
                this.openShipments.put(((PickupShipment)activity).getJob().getId(), (PickupShipment)activity);
            } else if (activity instanceof DeliverShipment) {
                String jobId = ((DeliverShipment)activity).getJob().getId();
                if (!this.openShipments.containsKey(jobId)) {
                    this.stateManager.putActivityState(activity, this.shipment_id, true);
                    this.shipmentConstraintOnRouteViolated = true;
                } else {
                    PickupShipment removed = this.openShipments.remove(jobId);
                    this.stateManager.putActivityState(removed, this.shipment_id, false);
                    this.stateManager.putActivityState(activity, this.shipment_id, false);
                }
            } else {
                this.stateManager.putActivityState(activity, this.shipment_id, false);
            }
            if (activity instanceof DeliverService && this.pickupOccured) {
                this.stateManager.putActivityState(activity, this.backhaul_id, true);
                this.backhaulConstraintOnRouteViolated = true;
            } else if (activity instanceof PickupService || activity instanceof ServiceActivity || activity instanceof PickupShipment) {
                this.pickupOccured = true;
                this.stateManager.putActivityState(activity, this.backhaul_id, false);
            } else {
                this.stateManager.putActivityState(activity, this.backhaul_id, false);
            }
        }

        @Override
        public void finish() {
            for (TourActivity tourActivity : this.openShipments.values()) {
                this.stateManager.putActivityState(tourActivity, this.shipment_id, true);
                this.shipmentConstraintOnRouteViolated = true;
            }
            this.stateManager.putRouteState(this.route, this.shipment_id, this.shipmentConstraintOnRouteViolated);
            this.stateManager.putRouteState(this.route, this.backhaul_id, this.backhaulConstraintOnRouteViolated);
        }
    }

    private static class LoadAndActivityCounter
    implements StateUpdater,
    ActivityVisitor {
        private final StateManager stateManager;
        private int pickupCounter;
        private int pickupAtBeginningCounter;
        private int deliveryCounter;
        private int deliverAtEndCounter;
        private Capacity pickedUp;
        private Capacity delivered;
        private StateId pickup_count_id;
        private StateId pickup_at_beginning_count_id;
        private StateId delivery_count_id;
        private StateId delivery_at_end_count_id;
        private StateId load_picked_id;
        private StateId load_delivered_id;
        private VehicleRoute route;

        private LoadAndActivityCounter(StateManager stateManager) {
            this.stateManager = stateManager;
            this.pickup_count_id = stateManager.createStateId(SolutionAnalyser.PICKUP_COUNT);
            this.delivery_count_id = stateManager.createStateId(SolutionAnalyser.DELIVERY_COUNT);
            this.load_picked_id = stateManager.createStateId(SolutionAnalyser.LOAD_PICKED);
            this.load_delivered_id = stateManager.createStateId(SolutionAnalyser.LOAD_DELIVERED);
            this.pickup_at_beginning_count_id = stateManager.createStateId(SolutionAnalyser.PICKUP_COUNT_AT_BEGINNING);
            this.delivery_at_end_count_id = stateManager.createStateId(SolutionAnalyser.DELIVERY_COUNT_AT_END);
        }

        @Override
        public void begin(VehicleRoute route) {
            this.route = route;
            this.pickupCounter = 0;
            this.pickupAtBeginningCounter = 0;
            this.deliveryCounter = 0;
            this.deliverAtEndCounter = 0;
            this.pickedUp = Capacity.Builder.newInstance().build();
            this.delivered = Capacity.Builder.newInstance().build();
        }

        @Override
        public void visit(TourActivity activity) {
            if (activity instanceof PickupActivity) {
                ++this.pickupCounter;
                this.pickedUp = Capacity.addup(this.pickedUp, ((PickupActivity)activity).getJob().getSize());
                if (activity instanceof PickupService) {
                    ++this.deliverAtEndCounter;
                }
            } else if (activity instanceof DeliveryActivity) {
                ++this.deliveryCounter;
                this.delivered = Capacity.addup(this.delivered, ((DeliveryActivity)activity).getJob().getSize());
                if (activity instanceof DeliverService) {
                    ++this.pickupAtBeginningCounter;
                }
            }
        }

        @Override
        public void finish() {
            this.stateManager.putRouteState(this.route, this.pickup_count_id, this.pickupCounter);
            this.stateManager.putRouteState(this.route, this.delivery_count_id, this.deliveryCounter);
            this.stateManager.putRouteState(this.route, this.load_picked_id, this.pickedUp);
            this.stateManager.putRouteState(this.route, this.load_delivered_id, this.delivered);
            this.stateManager.putRouteState(this.route, this.pickup_at_beginning_count_id, this.pickupAtBeginningCounter);
            this.stateManager.putRouteState(this.route, this.delivery_at_end_count_id, this.deliverAtEndCounter);
        }
    }
}

