/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem.constraint;

import com.graphhopper.jsprit.core.algorithm.state.InternalStates;
import com.graphhopper.jsprit.core.problem.Capacity;
import com.graphhopper.jsprit.core.problem.constraint.HardActivityConstraint;
import com.graphhopper.jsprit.core.problem.misc.JobInsertionContext;
import com.graphhopper.jsprit.core.problem.solution.route.activity.DeliverService;
import com.graphhopper.jsprit.core.problem.solution.route.activity.PickupService;
import com.graphhopper.jsprit.core.problem.solution.route.activity.ServiceActivity;
import com.graphhopper.jsprit.core.problem.solution.route.activity.Start;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.problem.solution.route.state.RouteAndActivityStateGetter;

public class ServiceLoadActivityLevelConstraint
implements HardActivityConstraint {
    private RouteAndActivityStateGetter stateManager;
    private Capacity defaultValue;

    public ServiceLoadActivityLevelConstraint(RouteAndActivityStateGetter stateManager) {
        this.stateManager = stateManager;
        this.defaultValue = Capacity.Builder.newInstance().build();
    }

    @Override
    public HardActivityConstraint.ConstraintsStatus fulfilled(JobInsertionContext iFacts, TourActivity prevAct, TourActivity newAct, TourActivity nextAct, double prevActDepTime) {
        Capacity prevMaxLoad;
        Capacity futureMaxLoad;
        if (prevAct instanceof Start) {
            futureMaxLoad = this.stateManager.getRouteState(iFacts.getRoute(), InternalStates.MAXLOAD, Capacity.class);
            if (futureMaxLoad == null) {
                futureMaxLoad = this.defaultValue;
            }
            if ((prevMaxLoad = this.stateManager.getRouteState(iFacts.getRoute(), InternalStates.LOAD_AT_BEGINNING, Capacity.class)) == null) {
                prevMaxLoad = this.defaultValue;
            }
        } else {
            futureMaxLoad = this.stateManager.getActivityState(prevAct, InternalStates.FUTURE_MAXLOAD, Capacity.class);
            if (futureMaxLoad == null) {
                futureMaxLoad = this.defaultValue;
            }
            if ((prevMaxLoad = this.stateManager.getActivityState(prevAct, InternalStates.PAST_MAXLOAD, Capacity.class)) == null) {
                prevMaxLoad = this.defaultValue;
            }
        }
        if ((newAct instanceof PickupService || newAct instanceof ServiceActivity) && !Capacity.addup(newAct.getSize(), futureMaxLoad).isLessOrEqual(iFacts.getNewVehicle().getType().getCapacityDimensions())) {
            return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED;
        }
        if (newAct instanceof DeliverService && !Capacity.addup(Capacity.invert(newAct.getSize()), prevMaxLoad).isLessOrEqual(iFacts.getNewVehicle().getType().getCapacityDimensions())) {
            return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED_BREAK;
        }
        return HardActivityConstraint.ConstraintsStatus.FULFILLED;
    }
}

