/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem.job;

import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TimeWindow;
import java.util.Collection;

public class Activity {
    private Location location;
    private Collection<TimeWindow> timeWindows;
    private double serviceTime;
    private Type activityType;

    Activity(Builder builder) {
        this.location = builder.location;
        this.timeWindows = builder.timeWindows;
        this.serviceTime = builder.serviceTime;
        this.activityType = builder.activityType;
    }

    public Type getActivityType() {
        return this.activityType;
    }

    public Location getLocation() {
        return this.location;
    }

    public Collection<TimeWindow> getTimeWindows() {
        return this.timeWindows;
    }

    public double getServiceTime() {
        return this.serviceTime;
    }

    public static class Builder {
        private final Type activityType;
        private Location location;
        Collection<TimeWindow> timeWindows;
        private double serviceTime;

        public Builder(Location location, Type activityType) {
            this.location = location;
            this.activityType = activityType;
        }

        public Builder setTimeWindows(Collection<TimeWindow> timeWindows) {
            this.timeWindows = timeWindows;
            return this;
        }

        public Builder setServiceTime(double serviceTime) {
            this.serviceTime = serviceTime;
            return this;
        }

        public Activity build() {
            return new Activity(this);
        }
    }

    public static enum Type {
        PICKUP,
        DELIVERY,
        SERVICE,
        BREAK;

    }
}

