/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem.solution.route;

import com.graphhopper.jsprit.core.problem.AbstractActivity;
import com.graphhopper.jsprit.core.problem.JobActivityFactory;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.driver.Driver;
import com.graphhopper.jsprit.core.problem.driver.DriverImpl;
import com.graphhopper.jsprit.core.problem.job.Break;
import com.graphhopper.jsprit.core.problem.job.Delivery;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.job.Pickup;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.job.Shipment;
import com.graphhopper.jsprit.core.problem.solution.route.activity.BreakActivity;
import com.graphhopper.jsprit.core.problem.solution.route.activity.DefaultShipmentActivityFactory;
import com.graphhopper.jsprit.core.problem.solution.route.activity.DefaultTourActivityFactory;
import com.graphhopper.jsprit.core.problem.solution.route.activity.End;
import com.graphhopper.jsprit.core.problem.solution.route.activity.Start;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TimeWindow;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivities;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivityFactory;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourShipmentActivityFactory;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VehicleRoute {
    private TourActivities tourActivities;
    private Vehicle vehicle;
    private Driver driver;
    private Start start;
    private End end;

    public static VehicleRoute copyOf(VehicleRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("route must not be null");
        }
        return new VehicleRoute(route);
    }

    public static VehicleRoute emptyRoute() {
        return Builder.newInstance(VehicleImpl.createNoVehicle(), DriverImpl.noDriver()).build();
    }

    private VehicleRoute(VehicleRoute route) {
        this.start = Start.copyOf(route.getStart());
        this.end = End.copyOf(route.getEnd());
        this.tourActivities = TourActivities.copyOf(route.getTourActivities());
        this.vehicle = route.getVehicle();
        this.driver = route.getDriver();
    }

    private VehicleRoute(Builder builder) {
        this.tourActivities = builder.tourActivities;
        this.vehicle = builder.vehicle;
        this.driver = builder.driver;
        this.start = builder.start;
        this.end = builder.end;
    }

    public List<TourActivity> getActivities() {
        return this.tourActivities.getActivities();
    }

    public TourActivities getTourActivities() {
        return this.tourActivities;
    }

    public Vehicle getVehicle() {
        return this.vehicle;
    }

    public Driver getDriver() {
        return this.driver;
    }

    public void setVehicleAndDepartureTime(Vehicle vehicle, double vehicleDepTime) {
        this.vehicle = vehicle;
        this.setStartAndEnd(vehicle, vehicleDepTime);
    }

    private void setStartAndEnd(Vehicle vehicle, double vehicleDepTime) {
        if (!(vehicle instanceof VehicleImpl.NoVehicle)) {
            if (this.start == null && this.end == null) {
                this.start = new Start(vehicle.getStartLocation(), vehicle.getEarliestDeparture(), vehicle.getLatestArrival());
                this.end = new End(vehicle.getEndLocation(), vehicle.getEarliestDeparture(), vehicle.getLatestArrival());
            }
            this.start.setEndTime(Math.max(vehicleDepTime, vehicle.getEarliestDeparture()));
            this.start.setTheoreticalEarliestOperationStartTime(vehicle.getEarliestDeparture());
            this.start.setTheoreticalLatestOperationStartTime(vehicle.getLatestArrival());
            this.start.setLocation(vehicle.getStartLocation());
            this.end.setLocation(vehicle.getEndLocation());
            this.end.setTheoreticalEarliestOperationStartTime(vehicle.getEarliestDeparture());
            this.end.setTheoreticalLatestOperationStartTime(vehicle.getLatestArrival());
        }
    }

    public double getDepartureTime() {
        if (this.start == null) {
            throw new IllegalArgumentException("cannot get departureTime without having a vehicle on this route. use setVehicle(vehicle,departureTime) instead.");
        }
        return this.start.getEndTime();
    }

    public boolean isEmpty() {
        return this.tourActivities.isEmpty();
    }

    public Start getStart() {
        return this.start;
    }

    public End getEnd() {
        return this.end;
    }

    public String toString() {
        return "[start=" + this.start + "][end=" + this.end + "][departureTime=" + this.start.getEndTime() + "][vehicle=" + this.vehicle + "][driver=" + this.driver + "][nuOfActs=" + this.tourActivities.getActivities().size() + "]";
    }

    public static class Builder {
        private Map<Shipment, TourActivity> openActivities = new HashMap<Shipment, TourActivity>();
        private Vehicle vehicle;
        private Driver driver;
        private Start start;
        private End end;
        private final TourActivities tourActivities = new TourActivities();
        private final Set<Shipment> openShipments = new HashSet<Shipment>();
        private JobActivityFactory jobActivityFactory = new JobActivityFactory(){
            private final TourShipmentActivityFactory shipmentActivityFactory = new DefaultShipmentActivityFactory();
            private final TourActivityFactory serviceActivityFactory = new DefaultTourActivityFactory();

            @Override
            public List<AbstractActivity> createActivities(Job job) {
                ArrayList<AbstractActivity> acts = new ArrayList<AbstractActivity>();
                if (job instanceof Break) {
                    acts.add(BreakActivity.newInstance((Break)job));
                } else if (job instanceof Service) {
                    acts.add(this.serviceActivityFactory.createActivity((Service)job));
                } else if (job instanceof Shipment) {
                    acts.add(this.shipmentActivityFactory.createPickup((Shipment)job));
                    acts.add(this.shipmentActivityFactory.createDelivery((Shipment)job));
                }
                return acts;
            }
        };

        public static Builder newInstance(Vehicle vehicle, Driver driver) {
            if (vehicle == null || driver == null) {
                throw new IllegalArgumentException("null arguments not accepted. ini emptyRoute with VehicleImpl.createNoVehicle() and DriverImpl.noDriver()");
            }
            return new Builder(vehicle, driver);
        }

        public static Builder newInstance(Vehicle vehicle) {
            if (vehicle == null) {
                throw new IllegalArgumentException("null arguments not accepted. ini emptyRoute with VehicleImpl.createNoVehicle() and DriverImpl.noDriver()");
            }
            return new Builder(vehicle, DriverImpl.noDriver());
        }

        public Builder setJobActivityFactory(JobActivityFactory jobActivityFactory) {
            this.jobActivityFactory = jobActivityFactory;
            return this;
        }

        private Builder(Vehicle vehicle, Driver driver) {
            this.vehicle = vehicle;
            this.driver = driver;
            this.start = new Start(vehicle.getStartLocation(), vehicle.getEarliestDeparture(), Double.MAX_VALUE);
            this.start.setEndTime(vehicle.getEarliestDeparture());
            this.end = new End(vehicle.getEndLocation(), 0.0, vehicle.getLatestArrival());
        }

        public Builder setDepartureTime(double departureTime) {
            if (departureTime < this.start.getEndTime()) {
                throw new IllegalArgumentException("departureTime < vehicle.getEarliestDepartureTime(). this must not be.");
            }
            this.start.setEndTime(departureTime);
            return this;
        }

        public Builder addService(Service service) {
            return this.addService(service, service.getTimeWindow());
        }

        public Builder addService(Service service, TimeWindow timeWindow) {
            if (service == null) {
                throw new IllegalArgumentException("service must not be null");
            }
            List<AbstractActivity> acts = this.jobActivityFactory.createActivities(service);
            TourActivity act = acts.get(0);
            act.setTheoreticalEarliestOperationStartTime(timeWindow.getStart());
            act.setTheoreticalLatestOperationStartTime(timeWindow.getEnd());
            this.tourActivities.addActivity(act);
            return this;
        }

        @Deprecated
        public Builder addBreak(Break currentbreak) {
            if (currentbreak == null) {
                throw new IllegalArgumentException("break must not be null");
            }
            return this.addBreak(currentbreak, currentbreak.getTimeWindow());
        }

        @Deprecated
        public Builder addBreak(Break currentbreak, TimeWindow timeWindow) {
            if (currentbreak == null) {
                throw new IllegalArgumentException("break must not be null");
            }
            return this.addService(currentbreak, timeWindow);
        }

        public Builder addBreak(Break currentbreak, TimeWindow timeWindow, Location location) {
            if (currentbreak == null) {
                throw new IllegalArgumentException("break must not be null");
            }
            return this.addBreakInternally(currentbreak, timeWindow, location);
        }

        private Builder addBreakInternally(Break currentBreak, TimeWindow timeWindow, Location breakLocation) {
            List<AbstractActivity> acts = this.jobActivityFactory.createActivities(currentBreak);
            BreakActivity act = (BreakActivity)acts.get(0);
            act.setTheoreticalEarliestOperationStartTime(timeWindow.getStart());
            act.setTheoreticalLatestOperationStartTime(timeWindow.getEnd());
            act.setLocation(breakLocation);
            this.tourActivities.addActivity(act);
            return this;
        }

        public Builder addPickup(Pickup pickup) {
            if (pickup == null) {
                throw new IllegalArgumentException("pickup must not be null");
            }
            return this.addService(pickup);
        }

        public Builder addPickup(Pickup pickup, TimeWindow timeWindow) {
            if (pickup == null) {
                throw new IllegalArgumentException("pickup must not be null");
            }
            return this.addService(pickup, timeWindow);
        }

        public Builder addDelivery(Delivery delivery) {
            if (delivery == null) {
                throw new IllegalArgumentException("delivery must not be null");
            }
            return this.addService(delivery);
        }

        public Builder addDelivery(Delivery delivery, TimeWindow timeWindow) {
            if (delivery == null) {
                throw new IllegalArgumentException("delivery must not be null");
            }
            return this.addService(delivery, timeWindow);
        }

        public Builder addPickup(Shipment shipment) {
            return this.addPickup(shipment, shipment.getPickupTimeWindow());
        }

        public Builder addPickup(Shipment shipment, TimeWindow pickupTimeWindow) {
            if (this.openShipments.contains(shipment)) {
                throw new IllegalArgumentException("shipment has already been added. cannot add it twice.");
            }
            List<AbstractActivity> acts = this.jobActivityFactory.createActivities(shipment);
            TourActivity act = acts.get(0);
            act.setTheoreticalEarliestOperationStartTime(pickupTimeWindow.getStart());
            act.setTheoreticalLatestOperationStartTime(pickupTimeWindow.getEnd());
            this.tourActivities.addActivity(act);
            this.openShipments.add(shipment);
            this.openActivities.put(shipment, acts.get(1));
            return this;
        }

        public Builder addDelivery(Shipment shipment) {
            return this.addDelivery(shipment, shipment.getDeliveryTimeWindow());
        }

        public Builder addDelivery(Shipment shipment, TimeWindow deliveryTimeWindow) {
            if (!this.openShipments.contains(shipment)) {
                throw new IllegalArgumentException("cannot deliver shipment. shipment " + shipment + " needs to be picked up first.");
            }
            TourActivity act = this.openActivities.get(shipment);
            act.setTheoreticalEarliestOperationStartTime(deliveryTimeWindow.getStart());
            act.setTheoreticalLatestOperationStartTime(deliveryTimeWindow.getEnd());
            this.tourActivities.addActivity(act);
            this.openShipments.remove(shipment);
            return this;
        }

        public VehicleRoute build() {
            if (!this.openShipments.isEmpty()) {
                throw new IllegalArgumentException("there are still shipments that have not been delivered yet.");
            }
            if (!this.vehicle.isReturnToDepot() && !this.tourActivities.isEmpty()) {
                this.end.setLocation(this.tourActivities.getActivities().get(this.tourActivities.getActivities().size() - 1).getLocation());
            }
            return new VehicleRoute(this);
        }
    }
}

