/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem.solution.route.activity;

import com.graphhopper.jsprit.core.problem.AbstractActivity;
import com.graphhopper.jsprit.core.problem.Capacity;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.job.Shipment;
import com.graphhopper.jsprit.core.problem.solution.route.activity.Activities;
import com.graphhopper.jsprit.core.problem.solution.route.activity.DeliveryActivity;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;

public final class DeliverShipment
extends AbstractActivity
implements DeliveryActivity {
    private Shipment shipment;
    private double endTime;
    private double arrTime;
    private Capacity capacity;
    private double earliest = 0.0;
    private double latest = Double.MAX_VALUE;

    public DeliverShipment(Shipment shipment) {
        this.shipment = shipment;
        this.capacity = Capacity.invert(shipment.getSize());
    }

    private DeliverShipment(DeliverShipment deliveryShipmentActivity) {
        this.shipment = (Shipment)deliveryShipmentActivity.getJob();
        this.arrTime = deliveryShipmentActivity.getArrTime();
        this.endTime = deliveryShipmentActivity.getEndTime();
        this.capacity = deliveryShipmentActivity.getSize();
        this.setIndex(deliveryShipmentActivity.getIndex());
        this.earliest = deliveryShipmentActivity.getTheoreticalEarliestOperationStartTime();
        this.latest = deliveryShipmentActivity.getTheoreticalLatestOperationStartTime();
    }

    @Override
    public Job getJob() {
        return this.shipment;
    }

    @Override
    public void setTheoreticalEarliestOperationStartTime(double earliest) {
        this.earliest = earliest;
    }

    @Override
    public void setTheoreticalLatestOperationStartTime(double latest) {
        this.latest = latest;
    }

    @Override
    public String getName() {
        return "deliverShipment";
    }

    @Override
    public Location getLocation() {
        return this.shipment.getDeliveryLocation();
    }

    @Override
    public double getTheoreticalEarliestOperationStartTime() {
        return this.earliest;
    }

    @Override
    public double getTheoreticalLatestOperationStartTime() {
        return this.latest;
    }

    @Override
    public double getOperationTime() {
        return this.shipment.getDeliveryServiceTime();
    }

    @Override
    public double getArrTime() {
        return this.arrTime;
    }

    @Override
    public double getEndTime() {
        return this.endTime;
    }

    @Override
    public void setArrTime(double arrTime) {
        this.arrTime = arrTime;
    }

    @Override
    public void setEndTime(double endTime) {
        this.endTime = endTime;
    }

    @Override
    public TourActivity duplicate() {
        return new DeliverShipment(this);
    }

    public String toString() {
        return "[type=" + this.getName() + "][locationId=" + this.getLocation().getId() + "][size=" + this.getSize().toString() + "][twStart=" + Activities.round(this.getTheoreticalEarliestOperationStartTime()) + "][twEnd=" + Activities.round(this.getTheoreticalLatestOperationStartTime()) + "]";
    }

    @Override
    public Capacity getSize() {
        return this.capacity;
    }
}

