/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem.vehicle;

import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Skills;

public class VehicleTypeKey
extends AbstractVehicle.AbstractTypeKey {
    public final String type;
    public final String startLocationId;
    public final String endLocationId;
    public final double earliestStart;
    public final double latestEnd;
    public final Skills skills;
    public final boolean returnToDepot;

    public VehicleTypeKey(String typeId, String startLocationId, String endLocationId, double earliestStart, double latestEnd, Skills skills, boolean returnToDepot) {
        this.type = typeId;
        this.startLocationId = startLocationId;
        this.endLocationId = endLocationId;
        this.earliestStart = earliestStart;
        this.latestEnd = latestEnd;
        this.skills = skills;
        this.returnToDepot = returnToDepot;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VehicleTypeKey that = (VehicleTypeKey)o;
        if (Double.compare(that.earliestStart, this.earliestStart) != 0) {
            return false;
        }
        if (Double.compare(that.latestEnd, this.latestEnd) != 0) {
            return false;
        }
        if (this.returnToDepot != that.returnToDepot) {
            return false;
        }
        if (!this.endLocationId.equals(that.endLocationId)) {
            return false;
        }
        if (!this.skills.equals(that.skills)) {
            return false;
        }
        if (!this.startLocationId.equals(that.startLocationId)) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.startLocationId.hashCode();
        result = 31 * result + this.endLocationId.hashCode();
        long temp = Double.doubleToLongBits(this.earliestStart);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.latestEnd);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.skills.hashCode();
        result = 31 * result + (this.returnToDepot ? 1 : 0);
        return result;
    }

    public String toString() {
        return this.type + "_" + this.startLocationId + "_" + this.endLocationId + "_" + Double.toString(this.earliestStart) + "_" + Double.toString(this.latestEnd);
    }
}

