/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.util;

import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.cost.AbstractForwardVehicleRoutingTransportCosts;
import com.graphhopper.jsprit.core.problem.driver.Driver;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import com.graphhopper.jsprit.core.util.Coordinate;
import com.graphhopper.jsprit.core.util.DistanceUnit;
import com.graphhopper.jsprit.core.util.GreatCircleDistanceCalculator;

public class GreatCircleCosts
extends AbstractForwardVehicleRoutingTransportCosts {
    private double speed = 1.0;
    private double detour = 1.0;
    private DistanceUnit distanceUnit = DistanceUnit.Kilometer;

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public void setDetour(double detour) {
        this.detour = detour;
    }

    public GreatCircleCosts() {
    }

    public GreatCircleCosts(DistanceUnit distanceUnit) {
        this.distanceUnit = distanceUnit;
    }

    @Override
    public double getTransportCost(Location from, Location to, double time, Driver driver, Vehicle vehicle) {
        double distance;
        try {
            distance = this.calculateDistance(from, to);
        }
        catch (NullPointerException e) {
            throw new NullPointerException("cannot calculate euclidean distance. coordinates are missing. either add coordinates or use another transport-cost-calculator.");
        }
        double costs = distance;
        if (vehicle != null && vehicle.getType() != null) {
            costs = distance * vehicle.getType().getVehicleCostParams().perDistanceUnit;
        }
        return costs;
    }

    private double calculateDistance(Location fromLocation, Location toLocation) {
        Coordinate from = null;
        Coordinate to = null;
        if (fromLocation.getCoordinate() != null && toLocation.getCoordinate() != null) {
            from = fromLocation.getCoordinate();
            to = toLocation.getCoordinate();
        }
        if (from == null || to == null) {
            throw new NullPointerException("either from or to location is null");
        }
        return GreatCircleDistanceCalculator.calculateDistance(from, to, this.distanceUnit) * this.detour;
    }

    @Override
    public double getTransportTime(Location from, Location to, double time, Driver driver, Vehicle vehicle) {
        return this.calculateDistance(from, to) / this.speed;
    }

    @Override
    public double getDistance(Location from, Location to, double departureTime, Vehicle vehicle) {
        return this.calculateDistance(from, to);
    }
}

