/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.module;

import com.graphhopper.jsprit.core.algorithm.SearchStrategyModule;
import com.graphhopper.jsprit.core.algorithm.listener.SearchStrategyModuleListener;
import com.graphhopper.jsprit.core.algorithm.recreate.InsertionStrategy;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.InsertionListener;
import com.graphhopper.jsprit.core.algorithm.ruin.RuinStrategy;
import com.graphhopper.jsprit.core.algorithm.ruin.listener.RuinListener;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.util.RandomNumberGeneration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Random;

public class RuinAndRecreateModule
implements SearchStrategyModule {
    private InsertionStrategy insertion;
    private RuinStrategy ruin;
    private String moduleName;
    private Random random = RandomNumberGeneration.newInstance();
    private int minUnassignedJobsToBeReinserted = Integer.MAX_VALUE;
    private double proportionOfUnassignedJobsToBeReinserted = 1.0;

    public RuinAndRecreateModule(String moduleName, InsertionStrategy insertion, RuinStrategy ruin) {
        this.insertion = insertion;
        this.ruin = ruin;
        this.moduleName = moduleName;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public void setMinUnassignedJobsToBeReinserted(int minUnassignedJobsToBeReinserted) {
        this.minUnassignedJobsToBeReinserted = minUnassignedJobsToBeReinserted;
    }

    public void setProportionOfUnassignedJobsToBeReinserted(double proportionOfUnassignedJobsToBeReinserted) {
        this.proportionOfUnassignedJobsToBeReinserted = proportionOfUnassignedJobsToBeReinserted;
    }

    @Override
    public VehicleRoutingProblemSolution runAndGetSolution(VehicleRoutingProblemSolution previousVrpSolution) {
        Collection<Job> ruinedJobs = this.ruin.ruin(previousVrpSolution.getRoutes());
        HashSet<Job> ruinedJobSet = new HashSet<Job>(ruinedJobs);
        ArrayList stillUnassignedInThisIteration = new ArrayList();
        if (previousVrpSolution.getUnassignedJobs().size() < this.minUnassignedJobsToBeReinserted) {
            ruinedJobSet.addAll(previousVrpSolution.getUnassignedJobs());
        } else {
            int i;
            int noUnassignedToBeInserted = Math.max(this.minUnassignedJobsToBeReinserted, (int)((double)previousVrpSolution.getUnassignedJobs().size() * this.proportionOfUnassignedJobsToBeReinserted));
            ArrayList<Job> jobList = new ArrayList<Job>(previousVrpSolution.getUnassignedJobs());
            Collections.shuffle(jobList, this.random);
            for (i = 0; i < noUnassignedToBeInserted; ++i) {
                ruinedJobSet.add((Job)jobList.get(i));
            }
            for (i = noUnassignedToBeInserted; i < jobList.size(); ++i) {
                stillUnassignedInThisIteration.add(jobList.get(i));
            }
        }
        ArrayList<Job> orderedRuinedJobs = new ArrayList<Job>(ruinedJobSet);
        orderedRuinedJobs.sort(Comparator.comparing(Job::getId));
        Collection<Job> unassignedJobs = this.insertion.insertJobs(previousVrpSolution.getRoutes(), orderedRuinedJobs);
        previousVrpSolution.getUnassignedJobs().clear();
        previousVrpSolution.getUnassignedJobs().addAll(unassignedJobs);
        previousVrpSolution.getUnassignedJobs().addAll(stillUnassignedInThisIteration);
        return previousVrpSolution;
    }

    @Override
    public String getName() {
        return this.moduleName;
    }

    @Override
    public void addModuleListener(SearchStrategyModuleListener moduleListener) {
        if (moduleListener instanceof InsertionListener) {
            InsertionListener iListener = (InsertionListener)moduleListener;
            if (!this.insertion.getListeners().contains(iListener)) {
                this.insertion.addListener(iListener);
            }
        }
        if (moduleListener instanceof RuinListener) {
            RuinListener rListener = (RuinListener)moduleListener;
            if (!this.ruin.getListeners().contains(rListener)) {
                this.ruin.addListener(rListener);
            }
        }
    }

    public InsertionStrategy getInsertion() {
        return this.insertion;
    }

    public RuinStrategy getRuin() {
        return this.ruin;
    }
}

