/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.algorithm.recreate.Event;
import com.graphhopper.jsprit.core.algorithm.recreate.EventListeners;
import com.graphhopper.jsprit.core.algorithm.recreate.InsertionData;
import com.graphhopper.jsprit.core.algorithm.recreate.InsertionStrategy;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.InsertionListener;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.InsertionListeners;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.driver.Driver;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import com.graphhopper.jsprit.core.util.RandomNumberGeneration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInsertionStrategy
implements InsertionStrategy {
    private static final Logger logger = LoggerFactory.getLogger(AbstractInsertionStrategy.class);
    protected Random random = RandomNumberGeneration.getRandom();
    protected static final double NO_NEW_DEPARTURE_TIME_YET = -12345.12345;
    protected static final Vehicle NO_NEW_VEHICLE_YET = null;
    protected static final Driver NO_NEW_DRIVER_YET = null;
    private InsertionListeners insertionsListeners = new InsertionListeners();
    private EventListeners eventListeners;
    protected VehicleRoutingProblem vrp;

    public AbstractInsertionStrategy(VehicleRoutingProblem vrp) {
        this.vrp = vrp;
        this.eventListeners = new EventListeners();
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    @Override
    public Collection<Job> insertJobs(Collection<VehicleRoute> vehicleRoutes, Collection<Job> unassignedJobs) {
        this.insertionsListeners.informInsertionStarts(vehicleRoutes, unassignedJobs);
        Collection<Job> badJobs = this.insertUnassignedJobs(vehicleRoutes, unassignedJobs);
        this.insertionsListeners.informInsertionEndsListeners(vehicleRoutes, badJobs);
        return badJobs;
    }

    public void markUnassigned(Job unassigned, List<String> reasons) {
        this.insertionsListeners.informJobUnassignedListeners(unassigned, reasons);
    }

    public abstract Collection<Job> insertUnassignedJobs(Collection<VehicleRoute> var1, Collection<Job> var2);

    @Override
    public void removeListener(InsertionListener insertionListener) {
        this.insertionsListeners.removeListener(insertionListener);
    }

    @Override
    public Collection<InsertionListener> getListeners() {
        return Collections.unmodifiableCollection(this.insertionsListeners.getListeners());
    }

    @Override
    public void addListener(InsertionListener insertionListener) {
        this.insertionsListeners.addListener(insertionListener);
    }

    protected void insertJob(Job unassignedJob, InsertionData iData, VehicleRoute inRoute) {
        logger.trace("insert: [jobId={}]{}", (Object)unassignedJob.getId(), (Object)iData);
        this.insertionsListeners.informBeforeJobInsertion(unassignedJob, iData, inRoute);
        if (!inRoute.getVehicle().getId().equals(iData.getSelectedVehicle().getId())) {
            this.insertionsListeners.informVehicleSwitched(inRoute, inRoute.getVehicle(), iData.getSelectedVehicle());
        }
        for (Event e : iData.getEvents()) {
            this.eventListeners.inform(e);
        }
        this.insertionsListeners.informJobInserted(unassignedJob, inRoute, iData);
    }

    protected class Insertion {
        private final VehicleRoute route;
        private final InsertionData insertionData;

        public Insertion(VehicleRoute vehicleRoute, InsertionData insertionData) {
            this.route = vehicleRoute;
            this.insertionData = insertionData;
        }

        public VehicleRoute getRoute() {
            return this.route;
        }

        public InsertionData getInsertionData() {
            return this.insertionData;
        }
    }
}

