/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.algorithm.recreate.AbstractInsertionStrategy;
import com.graphhopper.jsprit.core.algorithm.recreate.AccordingToPriorities;
import com.graphhopper.jsprit.core.algorithm.recreate.InsertionData;
import com.graphhopper.jsprit.core.algorithm.recreate.JobInsertionCostsCalculator;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.driver.Driver;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BestInsertionConcurrent
extends AbstractInsertionStrategy {
    private static final Logger logger = LoggerFactory.getLogger(BestInsertionConcurrent.class);
    private static final double NO_NEW_DEPARTURE_TIME_YET = -12345.12345;
    private static final Vehicle NO_NEW_VEHICLE_YET = null;
    private static final Driver NO_NEW_DRIVER_YET = null;
    private final JobInsertionCostsCalculator bestInsertionCostCalculator;
    private final ExecutorService executorService;

    public BestInsertionConcurrent(JobInsertionCostsCalculator jobInsertionCalculator, ExecutorService executorService, int nuOfBatches, VehicleRoutingProblem vehicleRoutingProblem) {
        super(vehicleRoutingProblem);
        this.bestInsertionCostCalculator = jobInsertionCalculator;
        this.executorService = executorService;
        logger.debug("initialise {}", (Object)this);
    }

    public String toString() {
        return "[name=bestInsertion]";
    }

    @Override
    public Collection<Job> insertUnassignedJobs(Collection<VehicleRoute> vehicleRoutes, Collection<Job> unassignedJobs) {
        ArrayList<Job> badJobs = new ArrayList<Job>(unassignedJobs.size());
        ArrayList<Job> unassignedJobList = new ArrayList<Job>(unassignedJobs);
        Collections.shuffle(unassignedJobList, this.random);
        unassignedJobList.sort(new AccordingToPriorities());
        ArrayList<String> failedConstraintNames = new ArrayList<String>();
        for (Job unassignedJob : unassignedJobList) {
            Insertion bestInsertion = null;
            double bestInsertionCost = Double.MAX_VALUE;
            ArrayList<Callable<Insertion>> tasks = new ArrayList<Callable<Insertion>>(vehicleRoutes.size());
            for (VehicleRoute route : vehicleRoutes) {
                tasks.add(() -> this.getBestInsertion(route, unassignedJob));
            }
            try {
                List futureResponses = this.executorService.invokeAll(tasks);
                for (int i = 0; i < vehicleRoutes.size(); ++i) {
                    Insertion insertion = (Insertion)futureResponses.get(i).get();
                    if (insertion.insertionData instanceof InsertionData.NoInsertionFound) {
                        failedConstraintNames.addAll(insertion.getInsertionData().getFailedConstraintNames());
                        continue;
                    }
                    if (!(insertion.getInsertionData().getInsertionCost() < bestInsertionCost)) continue;
                    bestInsertion = insertion;
                    bestInsertionCost = insertion.getInsertionData().getInsertionCost();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            VehicleRoute newRoute = VehicleRoute.emptyRoute();
            InsertionData newIData = this.bestInsertionCostCalculator.getInsertionData(newRoute, unassignedJob, NO_NEW_VEHICLE_YET, -12345.12345, NO_NEW_DRIVER_YET, bestInsertionCost);
            if (newIData.getInsertionCost() < bestInsertionCost) {
                bestInsertion = new Insertion(newRoute, newIData);
                vehicleRoutes.add(newRoute);
            }
            if (bestInsertion == null) {
                badJobs.add(unassignedJob);
                this.markUnassigned(unassignedJob, failedConstraintNames);
                continue;
            }
            this.insertJob(unassignedJob, bestInsertion.getInsertionData(), bestInsertion.getRoute());
        }
        return badJobs;
    }

    private Insertion getBestInsertion(VehicleRoute vehicleRoute, Job unassignedJob) {
        InsertionData.NoInsertionFound empty = new InsertionData.NoInsertionFound();
        InsertionData iData = this.bestInsertionCostCalculator.getInsertionData(vehicleRoute, unassignedJob, NO_NEW_VEHICLE_YET, -12345.12345, NO_NEW_DRIVER_YET, Double.MAX_VALUE);
        if (iData instanceof InsertionData.NoInsertionFound) {
            empty.getFailedConstraintNames().addAll(iData.getFailedConstraintNames());
            return new Insertion(null, empty);
        }
        return new Insertion(vehicleRoute, iData);
    }

    static class Insertion {
        private final VehicleRoute route;
        private final InsertionData insertionData;

        public Insertion(VehicleRoute vehicleRoute, InsertionData insertionData) {
            this.route = vehicleRoute;
            this.insertionData = insertionData;
        }

        public VehicleRoute getRoute() {
            return this.route;
        }

        public InsertionData getInsertionData() {
            return this.insertionData;
        }
    }
}

