/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.algorithm.listener.VehicleRoutingAlgorithmListeners;
import com.graphhopper.jsprit.core.algorithm.recreate.AbstractInsertionStrategy;
import com.graphhopper.jsprit.core.algorithm.recreate.ActivityInsertionCostsCalculator;
import com.graphhopper.jsprit.core.algorithm.recreate.BestInsertion;
import com.graphhopper.jsprit.core.algorithm.recreate.BestInsertionConcurrent;
import com.graphhopper.jsprit.core.algorithm.recreate.InsertionStrategy;
import com.graphhopper.jsprit.core.algorithm.recreate.JobInsertionCostsCalculator;
import com.graphhopper.jsprit.core.algorithm.recreate.JobInsertionCostsCalculatorBuilder;
import com.graphhopper.jsprit.core.algorithm.recreate.JobInsertionCostsCalculatorFactory;
import com.graphhopper.jsprit.core.algorithm.recreate.RegretInsertion;
import com.graphhopper.jsprit.core.algorithm.recreate.RegretInsertionConcurrent;
import com.graphhopper.jsprit.core.algorithm.recreate.RegretInsertionConcurrentFast;
import com.graphhopper.jsprit.core.algorithm.recreate.RegretInsertionFast;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.InsertionListener;
import com.graphhopper.jsprit.core.algorithm.state.StateManager;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.constraint.ConstraintManager;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleFleetManager;
import com.graphhopper.jsprit.core.util.RandomNumberGeneration;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ExecutorService;

public class InsertionStrategyBuilder {
    private final VehicleRoutingProblem vrp;
    private final StateManager stateManager;
    private boolean local = true;
    private final ConstraintManager constraintManager;
    private final VehicleFleetManager fleetManager;
    private double weightOfFixedCosts;
    private boolean considerFixedCosts = false;
    private ActivityInsertionCostsCalculator actInsertionCostsCalculator = null;
    private int forwaredLooking;
    private int memory;
    private ExecutorService executor;
    private int nuOfThreads;
    private boolean allowVehicleSwitch = true;
    private boolean addDefaultCostCalc = true;
    private Strategy strategy = Strategy.BEST;
    private boolean isFastRegret = false;
    private JobInsertionCostsCalculatorFactory shipmentInsertionCalculatorFactory;
    private JobInsertionCostsCalculatorFactory serviceInsertionCalculatorFactory;
    private JobInsertionCostsCalculatorFactory breakInsertionCalculatorFactory;
    private Random random = RandomNumberGeneration.getRandom();

    public InsertionStrategyBuilder(VehicleRoutingProblem vrp, VehicleFleetManager vehicleFleetManager, StateManager stateManager, ConstraintManager constraintManager) {
        this.vrp = vrp;
        this.stateManager = stateManager;
        this.constraintManager = constraintManager;
        this.fleetManager = vehicleFleetManager;
    }

    public InsertionStrategyBuilder setShipmentInsertionCalculatorFactory(JobInsertionCostsCalculatorFactory shipmentInsertionCalculatorFactory) {
        this.shipmentInsertionCalculatorFactory = shipmentInsertionCalculatorFactory;
        return this;
    }

    public InsertionStrategyBuilder setServiceInsertionCalculator(JobInsertionCostsCalculatorFactory serviceInsertionCalculator) {
        this.serviceInsertionCalculatorFactory = serviceInsertionCalculator;
        return this;
    }

    public InsertionStrategyBuilder setBreakInsertionCalculator(JobInsertionCostsCalculatorFactory breakInsertionCalculator) {
        this.breakInsertionCalculatorFactory = breakInsertionCalculator;
        return this;
    }

    public InsertionStrategyBuilder setInsertionStrategy(Strategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public InsertionStrategyBuilder setRandom(Random random) {
        this.random = random;
        return this;
    }

    public InsertionStrategyBuilder setRouteLevel(int forwardLooking, int memory) {
        this.local = false;
        this.forwaredLooking = forwardLooking;
        this.memory = memory;
        return this;
    }

    public InsertionStrategyBuilder setRouteLevel(int forwardLooking, int memory, boolean addDefaultMarginalCostCalculation) {
        this.local = false;
        this.forwaredLooking = forwardLooking;
        this.memory = memory;
        this.addDefaultCostCalc = addDefaultMarginalCostCalculation;
        return this;
    }

    public InsertionStrategyBuilder setFastRegret(boolean fastRegret) {
        this.isFastRegret = fastRegret;
        return this;
    }

    public InsertionStrategyBuilder setLocalLevel() {
        this.local = true;
        return this;
    }

    public InsertionStrategyBuilder setLocalLevel(boolean addDefaultMarginalCostCalculation) {
        this.local = true;
        this.addDefaultCostCalc = addDefaultMarginalCostCalculation;
        return this;
    }

    public InsertionStrategyBuilder considerFixedCosts(double weightOfFixedCosts) {
        this.weightOfFixedCosts = weightOfFixedCosts;
        this.considerFixedCosts = true;
        return this;
    }

    public InsertionStrategyBuilder setActivityInsertionCostCalculator(ActivityInsertionCostsCalculator activityInsertionCostsCalculator) {
        this.actInsertionCostsCalculator = activityInsertionCostsCalculator;
        return this;
    }

    public InsertionStrategyBuilder setConcurrentMode(ExecutorService executor, int nuOfThreads) {
        this.executor = executor;
        this.nuOfThreads = nuOfThreads;
        return this;
    }

    public InsertionStrategy build() {
        AbstractInsertionStrategy insertion;
        ArrayList<InsertionListener> iListeners = new ArrayList<InsertionListener>();
        ArrayList<VehicleRoutingAlgorithmListeners.PrioritizedVRAListener> algorithmListeners = new ArrayList<VehicleRoutingAlgorithmListeners.PrioritizedVRAListener>();
        JobInsertionCostsCalculatorBuilder calcBuilder = new JobInsertionCostsCalculatorBuilder(iListeners, algorithmListeners);
        if (this.local) {
            calcBuilder.setLocalLevel(this.addDefaultCostCalc);
        } else {
            calcBuilder.setRouteLevel(this.forwaredLooking, this.memory, this.addDefaultCostCalc);
        }
        if (this.shipmentInsertionCalculatorFactory != null) {
            calcBuilder.setShipmentCalculatorFactory(this.shipmentInsertionCalculatorFactory);
        }
        if (this.serviceInsertionCalculatorFactory != null) {
            calcBuilder.setServiceCalculatorFactory(this.serviceInsertionCalculatorFactory);
        }
        if (this.breakInsertionCalculatorFactory != null) {
            calcBuilder.setBreakCalculatorFactory(this.breakInsertionCalculatorFactory);
        }
        calcBuilder.setConstraintManager(this.constraintManager);
        calcBuilder.setStateManager(this.stateManager);
        calcBuilder.setVehicleRoutingProblem(this.vrp);
        calcBuilder.setVehicleFleetManager(this.fleetManager);
        calcBuilder.setActivityInsertionCostsCalculator(this.actInsertionCostsCalculator);
        if (this.considerFixedCosts) {
            calcBuilder.considerFixedCosts(this.weightOfFixedCosts);
        }
        calcBuilder.setAllowVehicleSwitch(this.allowVehicleSwitch);
        JobInsertionCostsCalculator costCalculator = calcBuilder.build();
        if (this.strategy.equals((Object)Strategy.BEST)) {
            AbstractInsertionStrategy bestInsertion;
            if (this.executor == null) {
                bestInsertion = new BestInsertion(costCalculator, this.vrp);
                bestInsertion.setRandom(this.random);
                insertion = bestInsertion;
            } else {
                bestInsertion = new BestInsertionConcurrent(costCalculator, this.executor, this.nuOfThreads, this.vrp);
                bestInsertion.setRandom(this.random);
                insertion = bestInsertion;
            }
        } else if (this.strategy.equals((Object)Strategy.REGRET)) {
            AbstractInsertionStrategy regret;
            if (this.executor == null) {
                if (this.isFastRegret) {
                    regret = new RegretInsertionFast(costCalculator, this.vrp, this.fleetManager);
                    ((RegretInsertionFast)regret).setSwitchAllowed(this.allowVehicleSwitch);
                    regret.setRandom(this.random);
                    insertion = regret;
                } else {
                    regret = new RegretInsertion(costCalculator, this.vrp);
                    regret.setRandom(this.random);
                    insertion = regret;
                }
            } else if (this.isFastRegret) {
                regret = new RegretInsertionConcurrentFast(costCalculator, this.vrp, this.executor, this.fleetManager);
                ((RegretInsertionConcurrentFast)regret).setSwitchAllowed(this.allowVehicleSwitch);
                regret.setRandom(this.random);
                insertion = regret;
            } else {
                regret = new RegretInsertionConcurrent(costCalculator, this.vrp, this.executor);
                regret.setRandom(this.random);
                insertion = regret;
            }
        } else {
            throw new IllegalStateException("you should never get here");
        }
        for (InsertionListener l : iListeners) {
            insertion.addListener(l);
        }
        return insertion;
    }

    public InsertionStrategyBuilder setAllowVehicleSwitch(boolean allowVehicleSwitch) {
        this.allowVehicleSwitch = allowVehicleSwitch;
        return this;
    }

    public static enum Strategy {
        REGRET,
        BEST;

    }
}

