/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.algorithm.recreate.InsertionData;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import java.util.List;

class ScoredJob {
    private Job job;
    private double score;
    private InsertionData insertionData;
    private VehicleRoute route;
    private boolean newRoute;

    ScoredJob(Job job, double score, InsertionData insertionData, VehicleRoute route, boolean isNewRoute) {
        this.job = job;
        this.score = score;
        this.insertionData = insertionData;
        this.route = route;
        this.newRoute = isNewRoute;
    }

    public boolean isNewRoute() {
        return this.newRoute;
    }

    public Job getJob() {
        return this.job;
    }

    public double getScore() {
        return this.score;
    }

    public InsertionData getInsertionData() {
        return this.insertionData;
    }

    public VehicleRoute getRoute() {
        return this.route;
    }

    static class BadJob
    extends ScoredJob {
        BadJob(Job job, List<String> failedConstraintNames) {
            super(job, 0.0, BadJob.getEmptyInsertion(failedConstraintNames), null, false);
        }

        private static InsertionData getEmptyInsertion(List<String> failedConstraintNames) {
            InsertionData.NoInsertionFound empty = new InsertionData.NoInsertionFound();
            empty.getFailedConstraintNames().addAll(failedConstraintNames);
            return empty;
        }
    }
}

