/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.algorithm.recreate.InsertionData;
import com.graphhopper.jsprit.core.algorithm.recreate.JobInsertionCostsCalculator;
import com.graphhopper.jsprit.core.algorithm.recreate.RegretScoringFunction;
import com.graphhopper.jsprit.core.algorithm.recreate.ScoredJob;
import com.graphhopper.jsprit.core.problem.driver.Driver;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import java.util.ArrayList;
import java.util.Collection;

class Scorer {
    static final double NO_NEW_DEPARTURE_TIME_YET = -12345.12345;
    static final Vehicle NO_NEW_VEHICLE_YET = null;
    static final Driver NO_NEW_DRIVER_YET = null;

    Scorer() {
    }

    static ScoredJob scoreUnassignedJob(Collection<VehicleRoute> routes, Job unassignedJob, JobInsertionCostsCalculator insertionCostsCalculator, RegretScoringFunction scoringFunction) {
        InsertionData best = null;
        InsertionData secondBest = null;
        VehicleRoute bestRoute = null;
        ArrayList<String> failedConstraintNames = new ArrayList<String>();
        double benchmark = Double.MAX_VALUE;
        for (VehicleRoute route : routes) {
            InsertionData iData;
            if (secondBest != null) {
                benchmark = secondBest.getInsertionCost();
            }
            if ((iData = insertionCostsCalculator.getInsertionData(route, unassignedJob, NO_NEW_VEHICLE_YET, -12345.12345, NO_NEW_DRIVER_YET, benchmark)) instanceof InsertionData.NoInsertionFound) {
                failedConstraintNames.addAll(iData.getFailedConstraintNames());
                continue;
            }
            if (best == null) {
                best = iData;
                bestRoute = route;
                continue;
            }
            if (iData.getInsertionCost() < best.getInsertionCost()) {
                secondBest = best;
                best = iData;
                bestRoute = route;
                continue;
            }
            if (secondBest != null && !(iData.getInsertionCost() < secondBest.getInsertionCost())) continue;
            secondBest = iData;
        }
        VehicleRoute emptyRoute = VehicleRoute.emptyRoute();
        InsertionData iData = insertionCostsCalculator.getInsertionData(emptyRoute, unassignedJob, NO_NEW_VEHICLE_YET, -12345.12345, NO_NEW_DRIVER_YET, benchmark);
        if (!(iData instanceof InsertionData.NoInsertionFound)) {
            if (best == null) {
                best = iData;
                bestRoute = emptyRoute;
            } else if (iData.getInsertionCost() < best.getInsertionCost()) {
                secondBest = best;
                best = iData;
                bestRoute = emptyRoute;
            } else if (secondBest == null || iData.getInsertionCost() < secondBest.getInsertionCost()) {
                secondBest = iData;
            }
        } else {
            failedConstraintNames.addAll(iData.getFailedConstraintNames());
        }
        if (best == null) {
            ScoredJob.BadJob badJob = new ScoredJob.BadJob(unassignedJob, failedConstraintNames);
            return badJob;
        }
        double score = scoringFunction.score(best, secondBest, unassignedJob);
        ScoredJob scoredJob = bestRoute == emptyRoute ? new ScoredJob(unassignedJob, score, best, bestRoute, true) : new ScoredJob(unassignedJob, score, best, bestRoute, false);
        return scoredJob;
    }
}

