/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.ruin;

import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingTransportCosts;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.util.RandomNumberGeneration;
import com.graphhopper.jsprit.core.util.RandomUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.math3.ml.clustering.Cluster;
import org.apache.commons.math3.ml.clustering.Clusterable;
import org.apache.commons.math3.ml.distance.DistanceMeasure;

public class DBSCANClusterer {
    private VehicleRoutingTransportCosts costs;
    private int minNoOfJobsInCluster = 1;
    private int noDistanceSamples = 10;
    private double epsFactor = 0.8;
    private Double epsDistance;
    private Random random = RandomNumberGeneration.getRandom();

    public void setRandom(Random random) {
        this.random = random;
    }

    public DBSCANClusterer(VehicleRoutingTransportCosts costs) {
        this.costs = costs;
    }

    public void setMinPts(int pts) {
        this.minNoOfJobsInCluster = pts;
    }

    public void setEpsFactor(double epsFactor) {
        this.epsFactor = epsFactor;
    }

    public void setEpsDistance(double epsDistance) {
        this.epsDistance = epsDistance;
    }

    public List<List<Job>> getClusters(VehicleRoute route) {
        List<LocationWrapper> locations = this.getLocationWrappers(route);
        List<Cluster<LocationWrapper>> clusterResults = this.getClusters(route, locations);
        return this.makeList(clusterResults);
    }

    private List<LocationWrapper> getLocationWrappers(VehicleRoute route) {
        ArrayList<LocationWrapper> locations = new ArrayList<LocationWrapper>(route.getTourActivities().getJobs().size());
        HashMap jobs2locations = new HashMap();
        for (TourActivity act : route.getActivities()) {
            if (!(act instanceof TourActivity.JobActivity)) continue;
            Job job = ((TourActivity.JobActivity)act).getJob();
            if (!jobs2locations.containsKey(job)) {
                jobs2locations.put(job, new ArrayList());
            }
            ((List)jobs2locations.get(job)).add(act.getLocation());
        }
        for (Job j : jobs2locations.keySet()) {
            locations.add(new LocationWrapper(j, (List)jobs2locations.get(j)));
        }
        return locations;
    }

    private List<Cluster<LocationWrapper>> getClusters(VehicleRoute route, List<LocationWrapper> locations) {
        double sampledDistance = this.epsDistance != null ? this.epsDistance : Math.max(0.0, this.sample(this.costs, route));
        org.apache.commons.math3.ml.clustering.DBSCANClusterer clusterer = new org.apache.commons.math3.ml.clustering.DBSCANClusterer(sampledDistance, this.minNoOfJobsInCluster, (DistanceMeasure)new MyDistance(locations, this.costs));
        return clusterer.cluster(locations);
    }

    private List<List<Job>> makeList(List<Cluster<LocationWrapper>> clusterResults) {
        ArrayList<List<Job>> l = new ArrayList<List<Job>>();
        for (Cluster<LocationWrapper> c : clusterResults) {
            List<Job> l_ = this.getJobList(c);
            l.add(l_);
        }
        return l;
    }

    private List<Job> getJobList(Cluster<LocationWrapper> c) {
        ArrayList<Job> l_ = new ArrayList<Job>();
        if (c == null) {
            return l_;
        }
        for (LocationWrapper lw : c.getPoints()) {
            l_.add(lw.getJob());
        }
        return l_;
    }

    public List<Job> getRandomCluster(VehicleRoute route) {
        if (route.isEmpty()) {
            return Collections.emptyList();
        }
        List<LocationWrapper> locations = this.getLocationWrappers(route);
        List<Cluster<LocationWrapper>> clusterResults = this.getClusters(route, locations);
        if (clusterResults.isEmpty()) {
            return Collections.emptyList();
        }
        Cluster<LocationWrapper> randomCluster = RandomUtils.nextItem(clusterResults, this.random);
        return this.getJobList(randomCluster);
    }

    private double sample(VehicleRoutingTransportCosts costs, VehicleRoute r) {
        double min = Double.MAX_VALUE;
        double sum = 0.0;
        for (int i = 0; i < this.noDistanceSamples; ++i) {
            TourActivity act1 = RandomUtils.nextItem(r.getActivities(), this.random);
            TourActivity act2 = RandomUtils.nextItem(r.getActivities(), this.random);
            double dist = costs.getTransportCost(act1.getLocation(), act2.getLocation(), 0.0, null, r.getVehicle());
            if (dist < min) {
                min = dist;
            }
            sum += dist;
        }
        double avg = sum / (double)this.noDistanceSamples;
        return (avg - min) * this.epsFactor;
    }

    private static class MyDistance
    implements DistanceMeasure {
        private final Map<Integer, LocationWrapper> locations = new HashMap<Integer, LocationWrapper>();
        private final VehicleRoutingTransportCosts costs;

        public MyDistance(List<LocationWrapper> locations, VehicleRoutingTransportCosts costs) {
            for (LocationWrapper lw : locations) {
                this.locations.put((int)lw.getPoint()[0], lw);
            }
            this.costs = costs;
        }

        public double compute(double[] doubles, double[] doubles1) {
            LocationWrapper l1 = this.locations.get((int)doubles[0]);
            LocationWrapper l2 = this.locations.get((int)doubles1[0]);
            int count = 0;
            double sum = 0.0;
            for (Location loc_1 : l1.getLocations()) {
                for (Location loc_2 : l2.getLocations()) {
                    sum += this.costs.getTransportCost(loc_1, loc_2, 0.0, null, null);
                    ++count;
                }
            }
            return sum / (double)count;
        }
    }

    private static class LocationWrapper
    implements Clusterable {
        private static int objCounter = 0;
        private final Job job;
        private final List<Location> locations;
        private final int id;

        public LocationWrapper(Job job, List<Location> locations) {
            this.locations = locations;
            this.job = job;
            this.id = ++objCounter;
        }

        public List<Location> getLocations() {
            return this.locations;
        }

        public double[] getPoint() {
            return new double[]{this.id};
        }

        public Job getJob() {
            return this.job;
        }
    }
}

