/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.ruin.distance;

import com.graphhopper.jsprit.core.algorithm.ruin.distance.EuclideanServiceDistance;
import com.graphhopper.jsprit.core.algorithm.ruin.distance.JobDistance;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingTransportCosts;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.job.Service;

public class AvgServiceDistance
implements JobDistance {
    private VehicleRoutingTransportCosts costs;

    public AvgServiceDistance(VehicleRoutingTransportCosts costs) {
        this.costs = costs;
    }

    @Override
    public double getDistance(Job i, Job j) {
        double avgCost = 0.0;
        if (i instanceof Service && j instanceof Service) {
            if (i.equals(j)) {
                avgCost = 0.0;
            } else {
                Service s_i = (Service)i;
                Service s_j = (Service)j;
                avgCost = this.calcDist(s_i, s_j);
            }
        } else {
            throw new UnsupportedOperationException("currently, this class just works services.");
        }
        return avgCost;
    }

    private double calcDist(Service s_i, Service s_j) {
        try {
            double distance = this.costs.getTransportCost(s_i.getLocation(), s_j.getLocation(), 0.0, null, null);
            return distance;
        }
        catch (IllegalStateException illegalStateException) {
            EuclideanServiceDistance euclidean = new EuclideanServiceDistance();
            double distance = euclidean.getDistance(s_i, s_j);
            return distance;
        }
    }
}

