/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem.constraint;

import com.graphhopper.jsprit.core.problem.constraint.ConstraintManager;
import com.graphhopper.jsprit.core.problem.constraint.HardActivityConstraint;
import com.graphhopper.jsprit.core.problem.misc.JobInsertionContext;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

class HardActivityLevelConstraintManager
implements HardActivityConstraint {
    private Collection<HardActivityConstraint> criticalConstraints = new ArrayList<HardActivityConstraint>();
    private Collection<HardActivityConstraint> highPrioConstraints = new ArrayList<HardActivityConstraint>();
    private Collection<HardActivityConstraint> lowPrioConstraints = new ArrayList<HardActivityConstraint>();
    private int numActivityConstraints = 0;

    HardActivityLevelConstraintManager() {
    }

    public void addConstraint(HardActivityConstraint constraint, ConstraintManager.Priority priority) {
        if (priority.equals((Object)ConstraintManager.Priority.CRITICAL)) {
            this.criticalConstraints.add(constraint);
        } else if (priority.equals((Object)ConstraintManager.Priority.HIGH)) {
            this.highPrioConstraints.add(constraint);
        } else {
            this.lowPrioConstraints.add(constraint);
        }
        ++this.numActivityConstraints;
    }

    boolean hasHardActivityConstraints() {
        return this.numActivityConstraints != 0;
    }

    Collection<HardActivityConstraint> getCriticalConstraints() {
        return Collections.unmodifiableCollection(this.criticalConstraints);
    }

    Collection<HardActivityConstraint> getHighPrioConstraints() {
        return Collections.unmodifiableCollection(this.highPrioConstraints);
    }

    Collection<HardActivityConstraint> getLowPrioConstraints() {
        return Collections.unmodifiableCollection(this.lowPrioConstraints);
    }

    Collection<HardActivityConstraint> getAllConstraints() {
        ArrayList<HardActivityConstraint> c = new ArrayList<HardActivityConstraint>();
        c.addAll(this.criticalConstraints);
        c.addAll(this.highPrioConstraints);
        c.addAll(this.lowPrioConstraints);
        return Collections.unmodifiableCollection(c);
    }

    @Override
    public HardActivityConstraint.ConstraintsStatus fulfilled(JobInsertionContext iFacts, TourActivity prevAct, TourActivity newAct, TourActivity nextAct, double prevActDepTime) {
        HardActivityConstraint.ConstraintsStatus status;
        if (this.numActivityConstraints == 0) {
            return HardActivityConstraint.ConstraintsStatus.FULFILLED;
        }
        HardActivityConstraint.ConstraintsStatus notFulfilled = null;
        for (HardActivityConstraint c : this.criticalConstraints) {
            status = c.fulfilled(iFacts, prevAct, newAct, nextAct, prevActDepTime);
            if (status.equals((Object)HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED_BREAK)) {
                return status;
            }
            if (!status.equals((Object)HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED)) continue;
            notFulfilled = status;
        }
        if (notFulfilled != null) {
            return notFulfilled;
        }
        for (HardActivityConstraint c : this.highPrioConstraints) {
            status = c.fulfilled(iFacts, prevAct, newAct, nextAct, prevActDepTime);
            if (status.equals((Object)HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED_BREAK)) {
                return status;
            }
            if (!status.equals((Object)HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED)) continue;
            notFulfilled = status;
        }
        if (notFulfilled != null) {
            return notFulfilled;
        }
        for (HardActivityConstraint constraint : this.lowPrioConstraints) {
            status = constraint.fulfilled(iFacts, prevAct, newAct, nextAct, prevActDepTime);
            if (!status.equals((Object)HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED_BREAK) && !status.equals((Object)HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED)) continue;
            return status;
        }
        return HardActivityConstraint.ConstraintsStatus.FULFILLED;
    }
}

