/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem.job;

import com.graphhopper.jsprit.core.problem.job.Activity;
import com.graphhopper.jsprit.core.problem.job.Service;

public class Delivery
extends Service {
    Delivery(Builder builder) {
        super(builder);
    }

    public static class Builder
    extends Service.Builder<Delivery> {
        public static Builder newInstance(String id) {
            return new Builder(id);
        }

        Builder(String id) {
            super(id);
        }

        public Builder setMaxTimeInVehicle(double maxTimeInVehicle) {
            if (maxTimeInVehicle < 0.0) {
                throw new IllegalArgumentException("maxTimeInVehicle should not be negative");
            }
            this.maxTimeInVehicle = maxTimeInVehicle;
            return this;
        }

        @Override
        public Delivery build() {
            if (this.location == null) {
                throw new IllegalArgumentException("location is missing");
            }
            this.setType("delivery");
            this.capacity = this.capacityBuilder.build();
            this.skills = this.skillBuilder.build();
            this.activity = new Activity.Builder(this.location, Activity.Type.DELIVERY).setTimeWindows(this.timeWindows.getTimeWindows()).setServiceTime(this.serviceTime).build();
            return new Delivery(this);
        }
    }
}

