/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem.job;

import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.Capacity;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.Skills;
import com.graphhopper.jsprit.core.problem.job.Activity;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TimeWindow;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TimeWindows;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TimeWindowsImpl;
import com.graphhopper.jsprit.core.util.Coordinate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Service
extends AbstractJob {
    private final String id;
    private final String type;
    private final double serviceTime;
    private final Capacity size;
    private final Skills skills;
    private final String name;
    private final Location location;
    private final TimeWindows timeWindows;
    private final int priority;
    private final double maxTimeInVehicle;
    private List<Activity> activities = new ArrayList<Activity>();

    Service(Builder<?> builder) {
        this.setUserData(builder.userData);
        this.id = ((Builder)builder).id;
        this.serviceTime = builder.serviceTime;
        this.type = ((Builder)builder).type;
        this.size = builder.capacity;
        this.skills = builder.skills;
        this.name = ((Builder)builder).name;
        this.location = builder.location;
        this.timeWindows = builder.timeWindows;
        this.priority = ((Builder)builder).priority;
        this.maxTimeInVehicle = builder.maxTimeInVehicle;
        this.activities.add(builder.activity);
        this.activities = Collections.unmodifiableList(this.activities);
    }

    public Collection<TimeWindow> getTimeWindows() {
        return this.timeWindows.getTimeWindows();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Location getLocation() {
        return this.location;
    }

    public double getServiceDuration() {
        return this.serviceTime;
    }

    public TimeWindow getTimeWindow() {
        return this.timeWindows.getTimeWindows().iterator().next();
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return "[id=" + this.id + "][name=" + this.name + "][type=" + this.type + "][location=" + this.location + "][capacity=" + this.size + "][serviceTime=" + this.serviceTime + "][timeWindows=" + this.timeWindows + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Service other = (Service)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    public Capacity getSize() {
        return this.size;
    }

    @Override
    public Skills getRequiredSkills() {
        return this.skills;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public double getMaxTimeInVehicle() {
        return this.maxTimeInVehicle;
    }

    @Override
    public List<Activity> getActivities() {
        return this.activities;
    }

    public static class Builder<T extends Service> {
        private String id;
        protected String locationId;
        private String type = "service";
        protected Coordinate coord;
        protected double serviceTime;
        protected Capacity.Builder capacityBuilder = Capacity.Builder.newInstance();
        protected Capacity capacity;
        protected Skills.Builder skillBuilder = Skills.Builder.newInstance();
        protected Skills skills;
        private String name = "no-name";
        protected Location location;
        protected TimeWindowsImpl timeWindows;
        private boolean twAdded = false;
        private int priority = 2;
        protected Object userData;
        protected double maxTimeInVehicle = Double.MAX_VALUE;
        protected Activity activity;

        public static Builder newInstance(String id) {
            return new Builder(id);
        }

        Builder(String id) {
            this.id = id;
            this.timeWindows = new TimeWindowsImpl();
            this.timeWindows.add(TimeWindow.newInstance(0.0, Double.MAX_VALUE));
        }

        protected Builder<T> setType(String name) {
            this.type = name;
            return this;
        }

        public Builder<T> setLocation(Location location) {
            this.location = location;
            return this;
        }

        public Builder<T> setServiceTime(double serviceTime) {
            if (serviceTime < 0.0) {
                throw new IllegalArgumentException("The service time of a service must be greater than or equal to zero.");
            }
            this.serviceTime = serviceTime;
            return this;
        }

        public Builder<T> setUserData(Object userData) {
            this.userData = userData;
            return this;
        }

        public Builder<T> addSizeDimension(int dimensionIndex, int dimensionValue) {
            if (dimensionValue < 0) {
                throw new IllegalArgumentException("The capacity value must not be negative.");
            }
            this.capacityBuilder.addDimension(dimensionIndex, dimensionValue);
            return this;
        }

        public Builder<T> setTimeWindow(TimeWindow tw) {
            if (tw == null) {
                throw new IllegalArgumentException("The time window must not be null.");
            }
            this.timeWindows = new TimeWindowsImpl();
            this.timeWindows.add(tw);
            return this;
        }

        public Builder<T> addTimeWindow(TimeWindow timeWindow) {
            if (timeWindow == null) {
                throw new IllegalArgumentException("The time window must not be null.");
            }
            if (!this.twAdded) {
                this.timeWindows = new TimeWindowsImpl();
                this.twAdded = true;
            }
            this.timeWindows.add(timeWindow);
            return this;
        }

        public Builder<T> addTimeWindow(double earliest, double latest) {
            return this.addTimeWindow(TimeWindow.newInstance(earliest, latest));
        }

        public Builder<T> addAllTimeWindows(Collection<TimeWindow> timeWindows) {
            for (TimeWindow tw : timeWindows) {
                this.addTimeWindow(tw);
            }
            return this;
        }

        public T build() {
            this.setType("service");
            this.capacity = this.capacityBuilder.build();
            this.skills = this.skillBuilder.build();
            this.activity = new Activity.Builder(this.location, Activity.Type.SERVICE).setServiceTime(this.serviceTime).setTimeWindows(this.timeWindows.getTimeWindows()).build();
            return (T)new Service(this);
        }

        public Builder<T> addRequiredSkill(String skill) {
            this.skillBuilder.addSkill(skill);
            return this;
        }

        public Builder<T> setName(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> addAllRequiredSkills(Collection<String> skills) {
            this.skillBuilder.addAllSkills(skills);
            return this;
        }

        public Builder<T> addAllRequiredSkills(Skills skills) {
            this.skillBuilder.addAllSkills(skills.values());
            return this;
        }

        public Builder<T> addAllSizeDimensions(Capacity size) {
            for (int i = 0; i < size.getNuOfDimensions(); ++i) {
                this.addSizeDimension(i, size.get(i));
            }
            return this;
        }

        public Builder<T> setPriority(int priority) {
            if (priority < 1 || priority > 10) {
                throw new IllegalArgumentException("The priority value is not valid. Only 1 (very high) to 10 (very low) are allowed.");
            }
            this.priority = priority;
            return this;
        }

        public Builder<T> setMaxTimeInVehicle(double maxTimeInVehicle) {
            throw new UnsupportedOperationException("The maximum time in vehicle is not yet supported for Pickups and Services (only for Deliveries and Shipments).");
        }
    }
}

