/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem.solution.route;

import com.graphhopper.jsprit.core.problem.solution.route.RouteVisitor;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.ActivityVisitor;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import java.util.ArrayList;
import java.util.Collection;

public class RouteActivityVisitor
implements RouteVisitor {
    private Collection<ActivityVisitor> visitors = new ArrayList<ActivityVisitor>();

    @Override
    public void visit(VehicleRoute route) {
        if (this.visitors.isEmpty()) {
            return;
        }
        this.begin(route);
        for (TourActivity act : route.getTourActivities().getActivities()) {
            this.visit(act);
        }
        this.end(route);
    }

    private void end(VehicleRoute route) {
        for (ActivityVisitor visitor : this.visitors) {
            visitor.finish();
        }
    }

    private void visit(TourActivity act) {
        for (ActivityVisitor visitor : this.visitors) {
            visitor.visit(act);
        }
    }

    private void begin(VehicleRoute route) {
        for (ActivityVisitor visitor : this.visitors) {
            visitor.begin(route);
        }
    }

    public RouteActivityVisitor addActivityVisitor(ActivityVisitor activityVisitor) {
        if (!this.visitors.contains(activityVisitor)) {
            this.visitors.add(activityVisitor);
        }
        return this;
    }
}

