/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem.solution.route.activity;

import com.graphhopper.jsprit.core.problem.AbstractActivity;
import com.graphhopper.jsprit.core.problem.Capacity;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.solution.route.activity.Activities;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;

public class ServiceActivity
extends AbstractActivity
implements TourActivity.JobActivity {
    public double arrTime;
    public double endTime;
    private double theoreticalEarliest;
    private double theoreticalLatest;
    private final Service service;

    @Override
    public double getArrTime() {
        return this.arrTime;
    }

    @Override
    public void setArrTime(double arrTime) {
        this.arrTime = arrTime;
    }

    @Override
    public double getEndTime() {
        return this.endTime;
    }

    @Override
    public void setEndTime(double endTime) {
        this.endTime = endTime;
    }

    public static ServiceActivity copyOf(ServiceActivity serviceActivity) {
        return new ServiceActivity(serviceActivity);
    }

    public static ServiceActivity newInstance(Service service) {
        return new ServiceActivity(service);
    }

    protected ServiceActivity(Service service) {
        this.service = service;
    }

    protected ServiceActivity(ServiceActivity serviceActivity) {
        this.service = serviceActivity.getJob();
        this.arrTime = serviceActivity.getArrTime();
        this.endTime = serviceActivity.getEndTime();
        this.setIndex(serviceActivity.getIndex());
        this.theoreticalEarliest = serviceActivity.getTheoreticalEarliestOperationStartTime();
        this.theoreticalLatest = serviceActivity.getTheoreticalLatestOperationStartTime();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.service == null ? 0 : this.service.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceActivity other = (ServiceActivity)obj;
        return !(this.service == null ? other.service != null : !this.service.equals(other.service));
    }

    @Override
    public double getTheoreticalEarliestOperationStartTime() {
        return this.theoreticalEarliest;
    }

    @Override
    public double getTheoreticalLatestOperationStartTime() {
        return this.theoreticalLatest;
    }

    @Override
    public void setTheoreticalEarliestOperationStartTime(double earliest) {
        this.theoreticalEarliest = earliest;
    }

    @Override
    public void setTheoreticalLatestOperationStartTime(double latest) {
        this.theoreticalLatest = latest;
    }

    @Override
    public double getOperationTime() {
        return this.service.getServiceDuration();
    }

    @Override
    public Location getLocation() {
        return this.service.getLocation();
    }

    @Override
    public Service getJob() {
        return this.service;
    }

    public String toString() {
        return "[type=" + this.getName() + "][location=" + this.getLocation() + "][size=" + this.getSize().toString() + "][twStart=" + Activities.round(this.getTheoreticalEarliestOperationStartTime()) + "][twEnd=" + Activities.round(this.getTheoreticalLatestOperationStartTime()) + "]";
    }

    @Override
    public String getName() {
        return this.service.getType();
    }

    @Override
    public TourActivity duplicate() {
        return new ServiceActivity(this);
    }

    @Override
    public Capacity getSize() {
        return this.service.getSize();
    }
}

