/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem.vehicle;

import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleFleetManager;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InfiniteVehicles
implements VehicleFleetManager {
    private static Logger logger = LoggerFactory.getLogger(InfiniteVehicles.class);
    private Map<VehicleTypeKey, Vehicle> types = new HashMap<VehicleTypeKey, Vehicle>();

    InfiniteVehicles(Collection<Vehicle> vehicles) {
        this.extractTypes(vehicles);
        logger.debug("initialise " + this);
    }

    public String toString() {
        return "[name=infiniteVehicle]";
    }

    private void extractTypes(Collection<Vehicle> vehicles) {
        for (Vehicle v : vehicles) {
            this.types.put(v.getVehicleTypeIdentifier(), v);
        }
    }

    @Override
    public void lock(Vehicle vehicle) {
    }

    @Override
    public void unlock(Vehicle vehicle) {
    }

    @Override
    public boolean isLocked(Vehicle vehicle) {
        return false;
    }

    @Override
    public void unlockAll() {
    }

    @Override
    public Collection<Vehicle> getAvailableVehicles() {
        return this.types.values();
    }

    @Override
    public Collection<Vehicle> getAvailableVehicles(Vehicle withoutThisType) {
        ArrayList<Vehicle> vehicles = new ArrayList<Vehicle>();
        VehicleTypeKey thisKey = new VehicleTypeKey(withoutThisType.getType().getTypeId(), withoutThisType.getStartLocation().getId(), withoutThisType.getEndLocation().getId(), withoutThisType.getEarliestDeparture(), withoutThisType.getLatestArrival(), withoutThisType.getSkills(), withoutThisType.isReturnToDepot());
        for (VehicleTypeKey key : this.types.keySet()) {
            if (key.equals(thisKey)) continue;
            vehicles.add(this.types.get(key));
        }
        return vehicles;
    }

    @Override
    public Vehicle getAvailableVehicle(VehicleTypeKey vehicleTypeIdentifier) {
        return this.types.get(vehicleTypeIdentifier);
    }
}

