/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem.vehicle;

import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleFleetManager;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VehicleFleetManagerImpl
implements VehicleFleetManager {
    private static Logger logger = LoggerFactory.getLogger(VehicleFleetManagerImpl.class);
    private Collection<Vehicle> vehicles;
    private TypeContainer[] vehicleTypes;
    private boolean[] locked;
    private Vehicle[] vehicleArr;

    public VehicleFleetManagerImpl newInstance(Collection<Vehicle> vehicles) {
        return new VehicleFleetManagerImpl(vehicles);
    }

    VehicleFleetManagerImpl(Collection<Vehicle> vehicles) {
        this.vehicles = vehicles;
        int arrSize = vehicles.size() + 2;
        this.locked = new boolean[arrSize];
        this.vehicleArr = new Vehicle[arrSize];
    }

    void init() {
        this.initializeVehicleTypes();
        logger.debug("initialise {}", (Object)this);
    }

    public String toString() {
        return "[name=finiteVehicles]";
    }

    private void initializeVehicleTypes() {
        int maxTypeIndex = 0;
        for (Vehicle v : this.vehicles) {
            if (v.getVehicleTypeIdentifier().getIndex() <= maxTypeIndex) continue;
            maxTypeIndex = v.getVehicleTypeIdentifier().getIndex();
        }
        this.vehicleTypes = new TypeContainer[maxTypeIndex + 1];
        for (int i = 0; i < this.vehicleTypes.length; ++i) {
            TypeContainer typeContainer;
            this.vehicleTypes[i] = typeContainer = new TypeContainer();
        }
        Iterator<Vehicle> iterator = this.vehicles.iterator();
        while (iterator.hasNext()) {
            Vehicle v;
            this.vehicleArr[v.getIndex()] = v = iterator.next();
            this.addVehicle(v);
        }
    }

    private void addVehicle(Vehicle v) {
        if (v.getType() == null) {
            throw new IllegalStateException("vehicle needs type");
        }
        this.vehicleTypes[v.getVehicleTypeIdentifier().getIndex()].add(v);
    }

    private void removeVehicle(Vehicle v) {
        this.vehicleTypes[v.getVehicleTypeIdentifier().getIndex()].remove(v);
    }

    @Override
    public Collection<Vehicle> getAvailableVehicles() {
        ArrayList<Vehicle> vehicles = new ArrayList<Vehicle>();
        for (TypeContainer vehicleType : this.vehicleTypes) {
            if (vehicleType.isEmpty()) continue;
            vehicles.add(vehicleType.getVehicle());
        }
        return vehicles;
    }

    @Override
    public Collection<Vehicle> getAvailableVehicles(Vehicle withoutThisType) {
        ArrayList<Vehicle> vehicles = new ArrayList<Vehicle>();
        for (int i = 0; i < this.vehicleTypes.length; ++i) {
            if (this.vehicleTypes[i].isEmpty() || i == withoutThisType.getVehicleTypeIdentifier().getIndex()) continue;
            vehicles.add(this.vehicleTypes[i].getVehicle());
        }
        return vehicles;
    }

    @Override
    public Vehicle getAvailableVehicle(VehicleTypeKey vehicleTypeIdentifier) {
        if (!this.vehicleTypes[vehicleTypeIdentifier.getIndex()].isEmpty()) {
            return this.vehicleTypes[vehicleTypeIdentifier.getIndex()].getVehicle();
        }
        return null;
    }

    @Override
    public void lock(Vehicle vehicle) {
        if (this.vehicles.isEmpty() || vehicle instanceof VehicleImpl.NoVehicle) {
            return;
        }
        if (this.locked[vehicle.getIndex()]) {
            throw new IllegalStateException("cannot lock vehicle twice " + vehicle.getId());
        }
        this.locked[vehicle.getIndex()] = true;
        this.removeVehicle(vehicle);
    }

    @Override
    public void unlock(Vehicle vehicle) {
        if (vehicle == null || this.vehicles.isEmpty() || vehicle instanceof VehicleImpl.NoVehicle) {
            return;
        }
        this.locked[vehicle.getIndex()] = false;
        this.addVehicle(vehicle);
    }

    @Override
    public boolean isLocked(Vehicle vehicle) {
        return this.locked[vehicle.getIndex()];
    }

    @Override
    public void unlockAll() {
        for (int i = 0; i < this.vehicleArr.length; ++i) {
            if (!this.locked[i]) continue;
            this.unlock(this.vehicleArr[i]);
        }
        for (TypeContainer vehicleType : this.vehicleTypes) {
            vehicleType.incIndex();
        }
    }

    static class TypeContainer {
        private ArrayList<Vehicle> vehicleList = new ArrayList();
        private int index = 0;

        TypeContainer() {
        }

        void add(Vehicle vehicle) {
            if (this.vehicleList.contains(vehicle)) {
                throw new IllegalStateException("cannot add vehicle twice " + vehicle.getId());
            }
            this.vehicleList.add(vehicle);
        }

        void remove(Vehicle vehicle) {
            this.vehicleList.remove(vehicle);
        }

        Vehicle getVehicle() {
            if (this.index >= this.vehicleList.size()) {
                this.index = 0;
            }
            return this.vehicleList.get(this.index);
        }

        void incIndex() {
            ++this.index;
        }

        boolean isEmpty() {
            return this.vehicleList.isEmpty();
        }
    }
}

