/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.util;

import com.graphhopper.jsprit.core.algorithm.recreate.listener.JobUnassignedListener;
import com.graphhopper.jsprit.core.problem.job.Job;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.stat.Frequency;

public class UnassignedJobReasonTracker
implements JobUnassignedListener {
    private static final String NO_REASON = "cannot determine a particular reason";
    Map<String, Frequency> failedConstraintNamesFrequencyMapping = new HashMap<String, Frequency>();
    Map<Integer, String> codesToHumanReadableReason = new HashMap<Integer, String>();
    Map<String, Integer> failedConstraintNamesToCode = new HashMap<String, Integer>();
    Set<String> failedConstraintNamesToBeIgnored = new HashSet<String>();

    public static String getMostLikelyFailedConstraintName(Frequency failedConstraintNamesFrequency) {
        if (failedConstraintNamesFrequency == null || failedConstraintNamesFrequency.getUniqueCount() == 0) {
            return NO_REASON;
        }
        Iterator entryIterator = failedConstraintNamesFrequency.entrySetIterator();
        long maxCount = 0L;
        String mostLikely = null;
        while (entryIterator.hasNext()) {
            Map.Entry entry = (Map.Entry)entryIterator.next();
            if ((Long)entry.getValue() <= maxCount) continue;
            Comparable key = (Comparable)entry.getKey();
            maxCount = (Long)entry.getValue();
            mostLikely = key.toString();
        }
        return mostLikely;
    }

    public UnassignedJobReasonTracker() {
        this.codesToHumanReadableReason.put(-1, NO_REASON);
        this.codesToHumanReadableReason.put(1, "cannot serve required skill");
        this.codesToHumanReadableReason.put(2, "cannot be visited within time window");
        this.codesToHumanReadableReason.put(3, "does not fit into any vehicle due to capacity");
        this.codesToHumanReadableReason.put(4, "cannot be assigned due to max distance constraint of vehicle");
        this.failedConstraintNamesToCode.put("HardSkillConstraint", 1);
        this.failedConstraintNamesToCode.put("VehicleDependentTimeWindowConstraints", 2);
        this.failedConstraintNamesToCode.put("ServiceLoadRouteLevelConstraint", 3);
        this.failedConstraintNamesToCode.put("PickupAndDeliverShipmentLoadActivityLevelConstraint", 3);
        this.failedConstraintNamesToCode.put("ServiceLoadActivityLevelConstraint", 3);
        this.failedConstraintNamesToCode.put("MaxDistanceConstraint", 4);
    }

    public void ignore(String simpleNameOfConstraint) {
        this.failedConstraintNamesToBeIgnored.add(simpleNameOfConstraint);
    }

    @Override
    public void informJobUnassigned(Job unassigned, Collection<String> failedConstraintNames) {
        if (!this.failedConstraintNamesFrequencyMapping.containsKey(unassigned.getId())) {
            this.failedConstraintNamesFrequencyMapping.put(unassigned.getId(), new Frequency());
        }
        for (String r : failedConstraintNames) {
            if (this.failedConstraintNamesToBeIgnored.contains(r)) continue;
            this.failedConstraintNamesFrequencyMapping.get(unassigned.getId()).addValue((Comparable)((Object)r));
        }
    }

    public void put(String simpleNameOfFailedConstraint, int code, String reason) {
        if (code <= 20) {
            throw new IllegalArgumentException("first 20 codes are reserved internally. choose a code > 20");
        }
        this.codesToHumanReadableReason.put(code, reason);
        if (this.failedConstraintNamesToCode.containsKey(simpleNameOfFailedConstraint)) {
            throw new IllegalArgumentException(simpleNameOfFailedConstraint + " already assigned to code and reason");
        }
        this.failedConstraintNamesToCode.put(simpleNameOfFailedConstraint, code);
    }

    @Deprecated
    public Map<String, Frequency> getReasons() {
        return Collections.unmodifiableMap(this.failedConstraintNamesFrequencyMapping);
    }

    public Map<String, Frequency> getFailedConstraintNamesFrequencyMapping() {
        return Collections.unmodifiableMap(this.failedConstraintNamesFrequencyMapping);
    }

    public Map<Integer, String> getCodesToReason() {
        return Collections.unmodifiableMap(this.codesToHumanReadableReason);
    }

    public Map<String, Integer> getFailedConstraintNamesToCode() {
        return Collections.unmodifiableMap(this.failedConstraintNamesToCode);
    }

    public int getCode(String failedConstraintName) {
        return this.toCode(failedConstraintName);
    }

    public String getHumanReadableReason(int code) {
        return this.getCodesToReason().get(code);
    }

    public String getHumanReadableReason(String failedConstraintName) {
        return this.getCodesToReason().get(this.getCode(failedConstraintName));
    }

    public int getMostLikelyReasonCode(String jobId) {
        if (!this.failedConstraintNamesFrequencyMapping.containsKey(jobId)) {
            return -1;
        }
        Frequency reasons = this.failedConstraintNamesFrequencyMapping.get(jobId);
        String mostLikelyReason = UnassignedJobReasonTracker.getMostLikelyFailedConstraintName(reasons);
        return this.toCode(mostLikelyReason);
    }

    public String getMostLikelyReason(String jobId) {
        if (!this.failedConstraintNamesFrequencyMapping.containsKey(jobId)) {
            return this.codesToHumanReadableReason.get(-1);
        }
        Frequency reasons = this.failedConstraintNamesFrequencyMapping.get(jobId);
        String mostLikelyReason = UnassignedJobReasonTracker.getMostLikelyFailedConstraintName(reasons);
        int code = this.toCode(mostLikelyReason);
        if (code == -1) {
            return mostLikelyReason;
        }
        return this.codesToHumanReadableReason.get(code);
    }

    private int toCode(String mostLikelyReason) {
        if (this.failedConstraintNamesToCode.containsKey(mostLikelyReason)) {
            return this.failedConstraintNamesToCode.get(mostLikelyReason);
        }
        return -1;
    }
}

