/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm;

import com.graphhopper.jsprit.core.algorithm.AlgorithmUtil;
import com.graphhopper.jsprit.core.algorithm.InsertionInitialSolutionFactory;
import com.graphhopper.jsprit.core.algorithm.RemoveEmptyVehicles;
import com.graphhopper.jsprit.core.algorithm.ResetAndIniFleetManager;
import com.graphhopper.jsprit.core.algorithm.SearchStrategy;
import com.graphhopper.jsprit.core.algorithm.SearchStrategyManager;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.acceptor.SchrimpfAcceptance;
import com.graphhopper.jsprit.core.algorithm.acceptor.SolutionAcceptor;
import com.graphhopper.jsprit.core.algorithm.recreate.InsertionStrategy;
import com.graphhopper.jsprit.core.algorithm.recreate.VehicleSwitched;
import com.graphhopper.jsprit.core.algorithm.state.StateManager;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.constraint.ConstraintManager;
import com.graphhopper.jsprit.core.problem.solution.SolutionCostCalculator;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleFleetManager;
import java.util.Random;

public class PrettyAlgorithmBuilder {
    private final VehicleRoutingProblem vrp;
    private final VehicleFleetManager fleetManager;
    private final StateManager stateManager;
    private final ConstraintManager constraintManager;
    private SearchStrategyManager searchStrategyManager;
    private InsertionStrategy iniInsertionStrategy;
    private SolutionCostCalculator iniObjFunction;
    private boolean coreStuff = false;
    private SolutionCostCalculator objectiveFunction = null;

    public static PrettyAlgorithmBuilder newInstance(VehicleRoutingProblem vrp, VehicleFleetManager fleetManager, StateManager stateManager, ConstraintManager constraintManager) {
        return new PrettyAlgorithmBuilder(vrp, fleetManager, stateManager, constraintManager);
    }

    PrettyAlgorithmBuilder(VehicleRoutingProblem vrp, VehicleFleetManager fleetManager, StateManager stateManager, ConstraintManager constraintManager) {
        this.vrp = vrp;
        this.fleetManager = fleetManager;
        this.stateManager = stateManager;
        this.constraintManager = constraintManager;
        this.searchStrategyManager = new SearchStrategyManager();
    }

    public PrettyAlgorithmBuilder setRandom(Random random) {
        this.searchStrategyManager.setRandom(random);
        return this;
    }

    public PrettyAlgorithmBuilder withStrategy(SearchStrategy strategy, double weight) {
        this.searchStrategyManager.addStrategy(strategy, weight);
        return this;
    }

    public PrettyAlgorithmBuilder constructInitialSolutionWith(InsertionStrategy insertionStrategy, SolutionCostCalculator objFunction) {
        this.iniInsertionStrategy = insertionStrategy;
        this.iniObjFunction = objFunction;
        return this;
    }

    public VehicleRoutingAlgorithm build() {
        if (this.coreStuff) {
            AlgorithmUtil.addCoreConstraints(this.constraintManager, this.stateManager, this.vrp);
        }
        VehicleRoutingAlgorithm vra = new VehicleRoutingAlgorithm(this.vrp, this.searchStrategyManager, this.objectiveFunction);
        vra.addListener(this.stateManager);
        RemoveEmptyVehicles removeEmptyVehicles = new RemoveEmptyVehicles(this.fleetManager);
        ResetAndIniFleetManager resetAndIniFleetManager = new ResetAndIniFleetManager(this.fleetManager);
        VehicleSwitched vehicleSwitched = new VehicleSwitched(this.fleetManager);
        vra.addListener(removeEmptyVehicles);
        vra.addListener(resetAndIniFleetManager);
        vra.addListener(vehicleSwitched);
        if (this.iniInsertionStrategy != null) {
            if (!this.iniInsertionStrategy.getListeners().contains(removeEmptyVehicles)) {
                this.iniInsertionStrategy.addListener(removeEmptyVehicles);
            }
            if (!this.iniInsertionStrategy.getListeners().contains(resetAndIniFleetManager)) {
                this.iniInsertionStrategy.addListener(resetAndIniFleetManager);
            }
            if (!this.iniInsertionStrategy.getListeners().contains(vehicleSwitched)) {
                this.iniInsertionStrategy.addListener(vehicleSwitched);
            }
            if (!this.iniInsertionStrategy.getListeners().contains(this.stateManager)) {
                this.iniInsertionStrategy.addListener(this.stateManager);
            }
            vra.addListener((problem, algorithm, solutions) -> {
                if (solutions.isEmpty()) {
                    solutions.add(new InsertionInitialSolutionFactory(this.iniInsertionStrategy, this.iniObjFunction).createSolution(this.vrp));
                }
            });
        }
        this.addArbitraryListener(vra);
        return vra;
    }

    private void addArbitraryListener(VehicleRoutingAlgorithm vra) {
        this.searchSchrimpfAndRegister(vra);
    }

    private void searchSchrimpfAndRegister(VehicleRoutingAlgorithm vra) {
        boolean schrimpfAdded = false;
        for (SearchStrategy strategy : vra.getSearchStrategyManager().getStrategies()) {
            SolutionAcceptor acceptor = strategy.getSolutionAcceptor();
            if (!(acceptor instanceof SchrimpfAcceptance) || schrimpfAdded) continue;
            vra.addListener((SchrimpfAcceptance)acceptor);
            schrimpfAdded = true;
        }
    }

    public PrettyAlgorithmBuilder addCoreStateAndConstraintStuff() {
        this.coreStuff = true;
        return this;
    }

    public PrettyAlgorithmBuilder withObjectiveFunction(SolutionCostCalculator objectiveFunction) {
        this.objectiveFunction = objectiveFunction;
        return this;
    }
}

