/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.acceptor;

import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.acceptor.SolutionAcceptor;
import com.graphhopper.jsprit.core.algorithm.listener.AlgorithmStartsListener;
import com.graphhopper.jsprit.core.algorithm.listener.IterationStartsListener;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordToRecordTravelAcceptance
implements SolutionAcceptor,
IterationStartsListener,
AlgorithmStartsListener {
    private static Logger logger = LoggerFactory.getLogger((String)RecordToRecordTravelAcceptance.class.getName());
    private final int solutionMemory = 1;
    private int maxIterations = 1000;
    private int currentIteration = 0;
    private double initialThreshold = 0.0167;
    private double endThreshold = 0.0;
    private double bestEver = Double.MAX_VALUE;

    public RecordToRecordTravelAcceptance() {
        logger.debug("initialise {}", (Object)this);
    }

    @Override
    public boolean acceptSolution(Collection<VehicleRoutingProblemSolution> solutions, VehicleRoutingProblemSolution newSolution) {
        boolean solutionAccepted = false;
        if (solutions.size() == 0) {
            solutions.add(newSolution);
            solutionAccepted = true;
        } else {
            double threshold = this.getThreshold();
            VehicleRoutingProblemSolution currentSolution = solutions.iterator().next();
            if ((newSolution.getCost() - this.bestEver) / newSolution.getCost() < threshold) {
                solutions.remove(currentSolution);
                solutions.add(newSolution);
                solutionAccepted = true;
            }
        }
        if (newSolution.getCost() < this.bestEver) {
            this.bestEver = newSolution.getCost();
        }
        return solutionAccepted;
    }

    private double getThreshold() {
        return this.initialThreshold - (this.initialThreshold - this.endThreshold) * (double)this.currentIteration / (double)this.maxIterations;
    }

    public String toString() {
        return "[name=record-to-record-travel]";
    }

    public double getInitialThreshold() {
        return this.initialThreshold;
    }

    public double getEndThreshold() {
        return this.endThreshold;
    }

    public void setInitialThreshold(double initialThreshold) {
        this.initialThreshold = initialThreshold;
    }

    public void setEndThreshold(double endThreshold) {
        this.endThreshold = endThreshold;
    }

    public void setMaxIterations(int maxIteration) {
        this.maxIterations = maxIteration;
    }

    @Override
    public void informAlgorithmStarts(VehicleRoutingProblem problem, VehicleRoutingAlgorithm algorithm, Collection<VehicleRoutingProblemSolution> solutions) {
        this.reset();
        this.maxIterations = algorithm.getMaxIterations();
    }

    private void reset() {
        this.currentIteration = 0;
    }

    @Override
    public void informIterationStarts(int i, VehicleRoutingProblem problem, Collection<VehicleRoutingProblemSolution> solutions) {
        this.currentIteration = i;
    }
}

