/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.box;

import com.graphhopper.jsprit.core.algorithm.PrettyAlgorithmBuilder;
import com.graphhopper.jsprit.core.algorithm.SearchStrategy;
import com.graphhopper.jsprit.core.algorithm.SearchStrategyModule;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.acceptor.SchrimpfAcceptance;
import com.graphhopper.jsprit.core.algorithm.acceptor.SolutionAcceptor;
import com.graphhopper.jsprit.core.algorithm.box.ConcurrentInsertionNoiseMaker;
import com.graphhopper.jsprit.core.algorithm.box.InsertionNoiseMaker;
import com.graphhopper.jsprit.core.algorithm.listener.AlgorithmEndsListener;
import com.graphhopper.jsprit.core.algorithm.listener.IterationStartsListener;
import com.graphhopper.jsprit.core.algorithm.module.RuinAndRecreateModule;
import com.graphhopper.jsprit.core.algorithm.recreate.AbstractInsertionStrategy;
import com.graphhopper.jsprit.core.algorithm.recreate.ActivityInsertionCostsCalculator;
import com.graphhopper.jsprit.core.algorithm.recreate.BestInsertion;
import com.graphhopper.jsprit.core.algorithm.recreate.BestInsertionConcurrent;
import com.graphhopper.jsprit.core.algorithm.recreate.BreakScheduling;
import com.graphhopper.jsprit.core.algorithm.recreate.DefaultScorer;
import com.graphhopper.jsprit.core.algorithm.recreate.IncreasingAbsoluteFixedCosts;
import com.graphhopper.jsprit.core.algorithm.recreate.InsertionStrategyBuilder;
import com.graphhopper.jsprit.core.algorithm.recreate.RegretInsertion;
import com.graphhopper.jsprit.core.algorithm.recreate.RegretInsertionConcurrent;
import com.graphhopper.jsprit.core.algorithm.recreate.RegretInsertionConcurrentFast;
import com.graphhopper.jsprit.core.algorithm.recreate.RegretInsertionFast;
import com.graphhopper.jsprit.core.algorithm.recreate.ScoringFunction;
import com.graphhopper.jsprit.core.algorithm.ruin.JobNeighborhoods;
import com.graphhopper.jsprit.core.algorithm.ruin.JobNeighborhoodsFactory;
import com.graphhopper.jsprit.core.algorithm.ruin.RuinClusters;
import com.graphhopper.jsprit.core.algorithm.ruin.RuinRadial;
import com.graphhopper.jsprit.core.algorithm.ruin.RuinRandom;
import com.graphhopper.jsprit.core.algorithm.ruin.RuinShareFactory;
import com.graphhopper.jsprit.core.algorithm.ruin.RuinString;
import com.graphhopper.jsprit.core.algorithm.ruin.RuinWorst;
import com.graphhopper.jsprit.core.algorithm.ruin.distance.AvgServiceAndShipmentDistance;
import com.graphhopper.jsprit.core.algorithm.selector.SelectBest;
import com.graphhopper.jsprit.core.algorithm.state.StateManager;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.constraint.ConstraintManager;
import com.graphhopper.jsprit.core.problem.constraint.SoftActivityConstraint;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.SolutionCostCalculator;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.BreakActivity;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.problem.vehicle.FiniteFleetManagerFactory;
import com.graphhopper.jsprit.core.problem.vehicle.InfiniteFleetManagerFactory;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleFleetManager;
import com.graphhopper.jsprit.core.util.RandomNumberGeneration;
import com.graphhopper.jsprit.core.util.Solutions;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Jsprit {
    private final ActivityInsertionCostsCalculator activityInsertion;
    private StateManager stateManager;
    private ConstraintManager constraintManager;
    private ExecutorService es;
    private Integer noThreads;
    private boolean setupExecutorInternally = false;
    private boolean addCoreConstraints;
    private SolutionCostCalculator objectiveFunction;
    private Properties properties;
    private Random random;
    private SolutionAcceptor acceptor;
    private ScoringFunction regretScorer;
    private final Map<SearchStrategy, Double> customStrategies = new HashMap<SearchStrategy, Double>();
    private VehicleFleetManager vehicleFleetManager;

    public static VehicleRoutingAlgorithm createAlgorithm(VehicleRoutingProblem vehicleRoutingProblem) {
        return Builder.newInstance(vehicleRoutingProblem).buildAlgorithm();
    }

    private Jsprit(Builder builder) {
        this.stateManager = builder.stateManager;
        this.constraintManager = builder.constraintManager;
        this.es = builder.es;
        this.noThreads = builder.noThreads;
        this.addCoreConstraints = builder.addConstraints;
        this.properties = builder.properties;
        this.objectiveFunction = builder.objectiveFunction;
        this.random = builder.random;
        this.activityInsertion = builder.activityInsertionCalculator;
        this.acceptor = builder.solutionAcceptor;
        this.regretScorer = builder.regretScorer;
        this.customStrategies.putAll(builder.customStrategies);
        this.vehicleFleetManager = builder.fleetManager;
    }

    private void ini(VehicleRoutingProblem vrp) {
        if (this.regretScorer == null) {
            this.regretScorer = this.getRegretScorer(vrp);
        }
    }

    private VehicleRoutingAlgorithm create(VehicleRoutingProblem vrp) {
        AbstractInsertionStrategy bestInsertion;
        AbstractInsertionStrategy regret;
        ScoringFunction scorer;
        AbstractInsertionStrategy regretInsertion;
        IterationStartsListener noiseConfigurator;
        IterationStartsListener noiseMaker;
        this.ini(vrp);
        if (this.vehicleFleetManager == null) {
            if (vrp.getFleetSize().equals((Object)VehicleRoutingProblem.FleetSize.INFINITE)) {
                this.vehicleFleetManager = new InfiniteFleetManagerFactory(vrp.getVehicles()).createFleetManager();
            } else {
                FiniteFleetManagerFactory finiteFleetManagerFactory = new FiniteFleetManagerFactory(vrp.getVehicles());
                this.vehicleFleetManager = finiteFleetManagerFactory.createFleetManager();
            }
        }
        if (this.stateManager == null) {
            this.stateManager = new StateManager(vrp);
        }
        if (this.constraintManager == null) {
            this.constraintManager = new ConstraintManager(vrp, this.stateManager);
        }
        if (this.noThreads == null) {
            this.noThreads = this.toInteger(this.getProperty(Parameter.THREADS.toString()));
        }
        if (this.noThreads > 1 && this.es == null) {
            this.setupExecutorInternally = true;
            this.es = Executors.newFixedThreadPool(this.noThreads);
        }
        double fixedCostParam = this.toDouble(this.getProperty(Parameter.FIXED_COST_PARAM.toString()));
        IncreasingAbsoluteFixedCosts increasingAbsoluteFixedCosts = null;
        if (fixedCostParam > 0.0) {
            increasingAbsoluteFixedCosts = new IncreasingAbsoluteFixedCosts(vrp.getJobs().size());
            increasingAbsoluteFixedCosts.setWeightOfFixCost(fixedCostParam);
            this.constraintManager.addConstraint(increasingAbsoluteFixedCosts);
        }
        double noiseLevel = this.toDouble(this.getProperty(Parameter.INSERTION_NOISE_LEVEL.toString()));
        double noiseProbability = this.toDouble(this.getProperty(Parameter.INSERTION_NOISE_PROB.toString()));
        JobNeighborhoods jobNeighborhoods = new JobNeighborhoodsFactory().createNeighborhoods(vrp, new AvgServiceAndShipmentDistance(vrp.getTransportCosts()), (int)((double)vrp.getJobs().values().size() * 0.5));
        jobNeighborhoods.initialise();
        double maxCosts = this.properties.containsKey(Parameter.MAX_TRANSPORT_COSTS.toString()) ? Double.parseDouble(this.getProperty(Parameter.MAX_TRANSPORT_COSTS.toString())) : jobNeighborhoods.getMaxDistance();
        if (this.noThreads > 1) {
            noiseMaker = new ConcurrentInsertionNoiseMaker(vrp, maxCosts, noiseLevel, noiseProbability);
            ((ConcurrentInsertionNoiseMaker)noiseMaker).setRandom(this.random);
            this.constraintManager.addConstraint((SoftActivityConstraint)((Object)noiseMaker));
            noiseConfigurator = noiseMaker;
        } else {
            noiseMaker = new InsertionNoiseMaker(vrp, maxCosts, noiseLevel, noiseProbability);
            ((InsertionNoiseMaker)noiseMaker).setRandom(this.random);
            this.constraintManager.addConstraint((SoftActivityConstraint)((Object)noiseMaker));
            noiseConfigurator = noiseMaker;
        }
        RuinRadial radial = new RuinRadial(vrp, vrp.getJobs().size(), jobNeighborhoods);
        radial.setRandom(this.random);
        radial.setRuinShareFactory(new RuinShareFactoryImpl(this.toInteger(this.properties.getProperty(Parameter.RADIAL_MIN_SHARE.toString())), this.toInteger(this.properties.getProperty(Parameter.RADIAL_MAX_SHARE.toString())), this.random));
        RuinRandom random_for_regret = new RuinRandom(vrp, 0.5);
        random_for_regret.setRandom(this.random);
        random_for_regret.setRuinShareFactory(new RuinShareFactoryImpl(this.toInteger(this.properties.getProperty(Parameter.RANDOM_REGRET_MIN_SHARE.toString())), this.toInteger(this.properties.getProperty(Parameter.RANDOM_REGRET_MAX_SHARE.toString())), this.random));
        RuinRandom random_for_best = new RuinRandom(vrp, 0.5);
        random_for_best.setRandom(this.random);
        random_for_best.setRuinShareFactory(new RuinShareFactoryImpl(this.toInteger(this.properties.getProperty(Parameter.RANDOM_BEST_MIN_SHARE.toString())), this.toInteger(this.properties.getProperty(Parameter.RANDOM_BEST_MAX_SHARE.toString())), this.random));
        RuinWorst worst = new RuinWorst(vrp, (int)((double)vrp.getJobs().values().size() * 0.5));
        worst.setRandom(this.random);
        worst.setRuinShareFactory(new RuinShareFactoryImpl(this.toInteger(this.properties.getProperty(Parameter.WORST_MIN_SHARE.toString())), this.toInteger(this.properties.getProperty(Parameter.WORST_MAX_SHARE.toString())), this.random));
        IterationStartsListener noise = (i, problem, solutions) -> worst.setNoiseMaker(() -> {
            if (this.random.nextDouble() < this.toDouble(this.getProperty(Parameter.RUIN_WORST_NOISE_PROB.toString()))) {
                return this.toDouble(this.getProperty(Parameter.RUIN_WORST_NOISE_LEVEL.toString())) * maxCosts * this.random.nextDouble();
            }
            return 0.0;
        });
        RuinClusters clusters = new RuinClusters(vrp, (int)((double)vrp.getJobs().values().size() * 0.5), jobNeighborhoods);
        clusters.setRandom(this.random);
        clusters.setRuinShareFactory(new RuinShareFactoryImpl(this.toInteger(this.properties.getProperty(Parameter.WORST_MIN_SHARE.toString())), this.toInteger(this.properties.getProperty(Parameter.WORST_MAX_SHARE.toString())), this.random));
        int kMin = this.toInteger(this.properties.getProperty(Parameter.STRING_K_MIN.toString()));
        int kMax = this.toInteger(this.properties.getProperty(Parameter.STRING_K_MAX.toString()));
        int lMin = this.toInteger(this.properties.getProperty(Parameter.STRING_L_MIN.toString()));
        int lMax = this.toInteger(this.properties.getProperty(Parameter.STRING_L_MAX.toString()));
        RuinString stringRuin = new RuinString(vrp, jobNeighborhoods);
        stringRuin.setNoRoutes(kMin, kMax);
        stringRuin.setStringLength(lMin, lMax);
        stringRuin.setRandom(this.random);
        boolean fastRegret = Boolean.parseBoolean(this.getProperty(Parameter.FAST_REGRET.toString()));
        if (this.es != null) {
            if (fastRegret) {
                regretInsertion = (RegretInsertionConcurrentFast)new InsertionStrategyBuilder(vrp, this.vehicleFleetManager, this.stateManager, this.constraintManager).setInsertionStrategy(InsertionStrategyBuilder.Strategy.REGRET).setConcurrentMode(this.es, this.noThreads).setFastRegret(true).considerFixedCosts(this.toDouble(this.getProperty(Parameter.FIXED_COST_PARAM.toString()))).setAllowVehicleSwitch(this.toBoolean(this.getProperty(Parameter.VEHICLE_SWITCH.toString()))).setActivityInsertionCostCalculator(this.activityInsertion).build();
                scorer = this.regretScorer;
                ((RegretInsertionConcurrentFast)regretInsertion).setScoringFunction(scorer);
                ((RegretInsertionConcurrentFast)regretInsertion).setDependencyTypes(this.constraintManager.getDependencyTypes());
                regret = regretInsertion;
            } else {
                regretInsertion = (RegretInsertionConcurrent)new InsertionStrategyBuilder(vrp, this.vehicleFleetManager, this.stateManager, this.constraintManager).setInsertionStrategy(InsertionStrategyBuilder.Strategy.REGRET).setConcurrentMode(this.es, this.noThreads).considerFixedCosts(this.toDouble(this.getProperty(Parameter.FIXED_COST_PARAM.toString()))).setAllowVehicleSwitch(this.toBoolean(this.getProperty(Parameter.VEHICLE_SWITCH.toString()))).setActivityInsertionCostCalculator(this.activityInsertion).build();
                scorer = this.regretScorer;
                ((RegretInsertionConcurrent)regretInsertion).setScoringFunction(scorer);
                regret = regretInsertion;
            }
        } else if (fastRegret) {
            regretInsertion = (RegretInsertionFast)new InsertionStrategyBuilder(vrp, this.vehicleFleetManager, this.stateManager, this.constraintManager).setInsertionStrategy(InsertionStrategyBuilder.Strategy.REGRET).setFastRegret(true).setAllowVehicleSwitch(this.toBoolean(this.getProperty(Parameter.VEHICLE_SWITCH.toString()))).considerFixedCosts(this.toDouble(this.getProperty(Parameter.FIXED_COST_PARAM.toString()))).setActivityInsertionCostCalculator(this.activityInsertion).build();
            scorer = this.regretScorer;
            ((RegretInsertionFast)regretInsertion).setScoringFunction(scorer);
            ((RegretInsertionFast)regretInsertion).setDependencyTypes(this.constraintManager.getDependencyTypes());
            regret = regretInsertion;
        } else {
            regretInsertion = (RegretInsertion)new InsertionStrategyBuilder(vrp, this.vehicleFleetManager, this.stateManager, this.constraintManager).setInsertionStrategy(InsertionStrategyBuilder.Strategy.REGRET).setAllowVehicleSwitch(this.toBoolean(this.getProperty(Parameter.VEHICLE_SWITCH.toString()))).considerFixedCosts(this.toDouble(this.getProperty(Parameter.FIXED_COST_PARAM.toString()))).setActivityInsertionCostCalculator(this.activityInsertion).build();
            scorer = this.regretScorer;
            ((RegretInsertion)regretInsertion).setScoringFunction(scorer);
            regret = regretInsertion;
        }
        regret.setRandom(this.random);
        AbstractInsertionStrategy best = vrp.getJobs().size() < 250 || this.es == null ? (bestInsertion = (BestInsertion)new InsertionStrategyBuilder(vrp, this.vehicleFleetManager, this.stateManager, this.constraintManager).setInsertionStrategy(InsertionStrategyBuilder.Strategy.BEST).considerFixedCosts(Double.valueOf(this.properties.getProperty(Parameter.FIXED_COST_PARAM.toString()))).setAllowVehicleSwitch(this.toBoolean(this.getProperty(Parameter.VEHICLE_SWITCH.toString()))).setActivityInsertionCostCalculator(this.activityInsertion).build()) : (bestInsertion = (BestInsertionConcurrent)new InsertionStrategyBuilder(vrp, this.vehicleFleetManager, this.stateManager, this.constraintManager).setInsertionStrategy(InsertionStrategyBuilder.Strategy.BEST).considerFixedCosts(Double.valueOf(this.properties.getProperty(Parameter.FIXED_COST_PARAM.toString()))).setAllowVehicleSwitch(this.toBoolean(this.getProperty(Parameter.VEHICLE_SWITCH.toString()))).setConcurrentMode(this.es, this.noThreads).setActivityInsertionCostCalculator(this.activityInsertion).build());
        best.setRandom(this.random);
        IterationStartsListener schrimpfThreshold = null;
        if (this.acceptor == null) {
            SchrimpfAcceptance schrimpfAcceptance = new SchrimpfAcceptance(1, this.toDouble(this.getProperty(Parameter.THRESHOLD_ALPHA.toString())));
            if (this.properties.containsKey(Parameter.THRESHOLD_INI_ABS.toString())) {
                schrimpfAcceptance.setInitialThreshold(Double.valueOf(this.properties.getProperty(Parameter.THRESHOLD_INI_ABS.toString())));
            } else {
                schrimpfThreshold = (i, problem, solutions) -> {
                    if (i == 1) {
                        double initialThreshold = Solutions.bestOf(solutions).getCost() * this.toDouble(this.getProperty(Parameter.THRESHOLD_INI.toString()));
                        schrimpfAcceptance.setInitialThreshold(initialThreshold);
                    }
                };
            }
            this.acceptor = schrimpfAcceptance;
        }
        SolutionCostCalculator objectiveFunction = this.getObjectiveFunction(vrp, maxCosts);
        SearchStrategy radialRegret = new SearchStrategy(Strategy.RADIAL_REGRET.toString(), new SelectBest(), this.acceptor, objectiveFunction);
        radialRegret.addModule(this.configureModule(new RuinAndRecreateModule(Strategy.RADIAL_REGRET.toString(), regret, radial)));
        SearchStrategy radialBest = new SearchStrategy(Strategy.RADIAL_BEST.toString(), new SelectBest(), this.acceptor, objectiveFunction);
        radialBest.addModule(this.configureModule(new RuinAndRecreateModule(Strategy.RADIAL_BEST.toString(), best, radial)));
        SearchStrategy randomBest = new SearchStrategy(Strategy.RANDOM_BEST.toString(), new SelectBest(), this.acceptor, objectiveFunction);
        randomBest.addModule(this.configureModule(new RuinAndRecreateModule(Strategy.RANDOM_BEST.toString(), best, random_for_best)));
        SearchStrategy randomRegret = new SearchStrategy(Strategy.RANDOM_REGRET.toString(), new SelectBest(), this.acceptor, objectiveFunction);
        randomRegret.addModule(this.configureModule(new RuinAndRecreateModule(Strategy.RANDOM_REGRET.toString(), regret, random_for_regret)));
        SearchStrategy worstRegret = new SearchStrategy(Strategy.WORST_REGRET.toString(), new SelectBest(), this.acceptor, objectiveFunction);
        worstRegret.addModule(this.configureModule(new RuinAndRecreateModule(Strategy.WORST_REGRET.toString(), regret, worst)));
        SearchStrategy worstBest = new SearchStrategy(Strategy.WORST_BEST.toString(), new SelectBest(), this.acceptor, objectiveFunction);
        worstBest.addModule(this.configureModule(new RuinAndRecreateModule(Strategy.WORST_BEST.toString(), best, worst)));
        SearchStrategy clustersRegret = new SearchStrategy(Strategy.CLUSTER_REGRET.toString(), new SelectBest(), this.acceptor, objectiveFunction);
        clustersRegret.addModule(this.configureModule(new RuinAndRecreateModule(Strategy.CLUSTER_REGRET.toString(), regret, clusters)));
        SearchStrategy clustersBest = new SearchStrategy(Strategy.CLUSTER_BEST.toString(), new SelectBest(), this.acceptor, objectiveFunction);
        clustersBest.addModule(this.configureModule(new RuinAndRecreateModule(Strategy.CLUSTER_BEST.toString(), best, clusters)));
        SearchStrategy stringRegret = new SearchStrategy(Strategy.STRING_REGRET.toString(), new SelectBest(), this.acceptor, objectiveFunction);
        stringRegret.addModule(this.configureModule(new RuinAndRecreateModule(Strategy.STRING_REGRET.toString(), regret, stringRuin)));
        SearchStrategy stringBest = new SearchStrategy(Strategy.STRING_BEST.toString(), new SelectBest(), this.acceptor, objectiveFunction);
        stringBest.addModule(this.configureModule(new RuinAndRecreateModule(Strategy.STRING_BEST.toString(), best, stringRuin)));
        PrettyAlgorithmBuilder prettyBuilder = PrettyAlgorithmBuilder.newInstance(vrp, this.vehicleFleetManager, this.stateManager, this.constraintManager);
        prettyBuilder.setRandom(this.random);
        if (this.addCoreConstraints) {
            prettyBuilder.addCoreStateAndConstraintStuff();
        }
        prettyBuilder.withStrategy(radialRegret, this.toDouble(this.getProperty(Strategy.RADIAL_REGRET.toString()))).withStrategy(radialBest, this.toDouble(this.getProperty(Strategy.RADIAL_BEST.toString()))).withStrategy(randomBest, this.toDouble(this.getProperty(Strategy.RANDOM_BEST.toString()))).withStrategy(randomRegret, this.toDouble(this.getProperty(Strategy.RANDOM_REGRET.toString()))).withStrategy(worstBest, this.toDouble(this.getProperty(Strategy.WORST_BEST.toString()))).withStrategy(worstRegret, this.toDouble(this.getProperty(Strategy.WORST_REGRET.toString()))).withStrategy(clustersRegret, this.toDouble(this.getProperty(Strategy.CLUSTER_REGRET.toString()))).withStrategy(clustersBest, this.toDouble(this.getProperty(Strategy.CLUSTER_BEST.toString()))).withStrategy(stringBest, this.toDouble(this.getProperty(Strategy.STRING_BEST.toString()))).withStrategy(stringRegret, this.toDouble(this.getProperty(Strategy.STRING_REGRET.toString())));
        for (SearchStrategy customStrategy : this.customStrategies.keySet()) {
            prettyBuilder.withStrategy(customStrategy, this.customStrategies.get(customStrategy));
        }
        if (this.getProperty(Parameter.CONSTRUCTION.toString()).equals(Construction.BEST_INSERTION.toString())) {
            prettyBuilder.constructInitialSolutionWith(best, objectiveFunction);
        } else {
            prettyBuilder.constructInitialSolutionWith(regret, objectiveFunction);
        }
        prettyBuilder.withObjectiveFunction(objectiveFunction);
        VehicleRoutingAlgorithm vra = prettyBuilder.build();
        if (schrimpfThreshold != null) {
            vra.addListener(schrimpfThreshold);
        }
        vra.addListener(noiseConfigurator);
        vra.addListener(noise);
        vra.addListener(clusters);
        if (increasingAbsoluteFixedCosts != null) {
            vra.addListener(increasingAbsoluteFixedCosts);
        }
        if (this.toBoolean(this.getProperty(Parameter.BREAK_SCHEDULING.toString()))) {
            vra.addListener(new BreakScheduling(vrp, this.stateManager, this.constraintManager));
        }
        this.handleExecutorShutdown(vra);
        vra.setMaxIterations(Integer.valueOf(this.properties.getProperty(Parameter.ITERATIONS.toString())));
        return vra;
    }

    private SearchStrategyModule configureModule(RuinAndRecreateModule ruinAndRecreateModule) {
        ruinAndRecreateModule.setRandom(this.random);
        ruinAndRecreateModule.setMinUnassignedJobsToBeReinserted(Integer.valueOf(this.properties.getProperty(Parameter.MIN_UNASSIGNED.toString())));
        ruinAndRecreateModule.setProportionOfUnassignedJobsToBeReinserted(Double.valueOf(this.properties.getProperty(Parameter.PROPORTION_UNASSIGNED.toString())));
        return ruinAndRecreateModule;
    }

    private DefaultScorer getRegretScorer(VehicleRoutingProblem vrp) {
        DefaultScorer scorer = new DefaultScorer(vrp);
        scorer.setTimeWindowParam(Double.valueOf(this.properties.getProperty(Parameter.REGRET_TIME_WINDOW_SCORER.toString())));
        scorer.setDepotDistanceParam(Double.valueOf(this.properties.getProperty(Parameter.REGRET_DISTANCE_SCORER.toString())));
        return scorer;
    }

    private void handleExecutorShutdown(VehicleRoutingAlgorithm vra) {
        if (this.setupExecutorInternally) {
            final Thread hook = new Thread(){

                @Override
                public void run() {
                    if (!Jsprit.this.es.isShutdown()) {
                        System.err.println("shutdownHook shuts down executorService");
                        Jsprit.this.es.shutdown();
                    }
                }
            };
            Runtime.getRuntime().addShutdownHook(hook);
            vra.addListener(new AlgorithmEndsListener(){

                @Override
                public void informAlgorithmEnds(VehicleRoutingProblem problem, Collection<VehicleRoutingProblemSolution> solutions) {
                    Jsprit.this.es.shutdown();
                    Runtime.getRuntime().removeShutdownHook(hook);
                }
            });
        }
    }

    String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    private boolean toBoolean(String property) {
        return Boolean.valueOf(property);
    }

    private int toInteger(String string) {
        return Integer.valueOf(string);
    }

    private double toDouble(String string) {
        return Double.valueOf(string);
    }

    private SolutionCostCalculator getObjectiveFunction(final VehicleRoutingProblem vrp, final double maxCosts) {
        if (this.objectiveFunction != null) {
            return this.objectiveFunction;
        }
        SolutionCostCalculator solutionCostCalculator = new SolutionCostCalculator(){

            @Override
            public double getCosts(VehicleRoutingProblemSolution solution) {
                double costs = 0.0;
                for (VehicleRoute route : solution.getRoutes()) {
                    costs += route.getVehicle().getType().getVehicleCostParams().fix;
                    boolean hasBreak = false;
                    TourActivity prevAct = route.getStart();
                    for (TourActivity act : route.getActivities()) {
                        if (act instanceof BreakActivity) {
                            hasBreak = true;
                        }
                        costs += vrp.getTransportCosts().getTransportCost(prevAct.getLocation(), act.getLocation(), prevAct.getEndTime(), route.getDriver(), route.getVehicle());
                        costs += vrp.getActivityCosts().getActivityCost(act, act.getArrTime(), route.getDriver(), route.getVehicle());
                        prevAct = act;
                    }
                    costs += vrp.getTransportCosts().getTransportCost(prevAct.getLocation(), route.getEnd().getLocation(), prevAct.getEndTime(), route.getDriver(), route.getVehicle());
                    if (route.getVehicle().getBreak() == null || hasBreak || !(route.getEnd().getArrTime() > route.getVehicle().getBreak().getTimeWindow().getEnd())) continue;
                    costs += 4.0 * (maxCosts * 2.0 + route.getVehicle().getBreak().getServiceDuration() * route.getVehicle().getType().getVehicleCostParams().perServiceTimeUnit);
                }
                for (Job j : solution.getUnassignedJobs()) {
                    costs += maxCosts * 2.0 * (double)(11 - j.getPriority());
                }
                return costs;
            }
        };
        return solutionCostCalculator;
    }

    static class RuinShareFactoryImpl
    implements RuinShareFactory {
        private int maxShare;
        private int minShare;
        private Random random = RandomNumberGeneration.getRandom();

        public void setRandom(Random random) {
            this.random = random;
        }

        public RuinShareFactoryImpl(int minShare, int maxShare) {
            if (maxShare < minShare) {
                throw new IllegalArgumentException("maxShare must be equal or greater than minShare");
            }
            this.minShare = minShare;
            this.maxShare = maxShare;
        }

        public RuinShareFactoryImpl(int minShare, int maxShare, Random random) {
            if (maxShare < minShare) {
                throw new IllegalArgumentException("maxShare must be equal or greater than minShare");
            }
            this.minShare = minShare;
            this.maxShare = maxShare;
            this.random = random;
        }

        @Override
        public int createNumberToBeRemoved() {
            return (int)((double)this.minShare + (double)(this.maxShare - this.minShare) * this.random.nextDouble());
        }
    }

    public static class Builder {
        private VehicleRoutingProblem vrp;
        private ExecutorService es;
        private Integer noThreads;
        private StateManager stateManager = null;
        private ConstraintManager constraintManager = null;
        private SolutionCostCalculator objectiveFunction = null;
        private Properties properties;
        private boolean addConstraints = true;
        private Random random = RandomNumberGeneration.newInstance();
        private ActivityInsertionCostsCalculator activityInsertionCalculator;
        private SolutionAcceptor solutionAcceptor;
        private ScoringFunction regretScorer = null;
        private Map<SearchStrategy, Double> customStrategies = new HashMap<SearchStrategy, Double>();
        private VehicleFleetManager fleetManager = null;

        public static Builder newInstance(VehicleRoutingProblem vrp) {
            return new Builder(vrp);
        }

        private Builder(VehicleRoutingProblem vrp) {
            this.vrp = vrp;
            this.properties = new Properties(this.createDefaultProperties());
        }

        private Properties createDefaultProperties() {
            Properties defaults = new Properties();
            defaults.put(Strategy.RADIAL_BEST.toString(), "0.");
            defaults.put(Strategy.RADIAL_REGRET.toString(), ".5");
            defaults.put(Strategy.RANDOM_BEST.toString(), ".5");
            defaults.put(Strategy.RANDOM_REGRET.toString(), ".5");
            defaults.put(Strategy.STRING_BEST.toString(), "0.0");
            defaults.put(Strategy.STRING_REGRET.toString(), "0.0");
            defaults.put(Parameter.STRING_K_MIN.toString(), "1");
            defaults.put(Parameter.STRING_K_MAX.toString(), "6");
            defaults.put(Parameter.STRING_L_MIN.toString(), "10");
            defaults.put(Parameter.STRING_L_MAX.toString(), "30");
            defaults.put(Strategy.WORST_BEST.toString(), "0.");
            defaults.put(Strategy.WORST_REGRET.toString(), "1.");
            defaults.put(Strategy.CLUSTER_BEST.toString(), "0.");
            defaults.put(Strategy.CLUSTER_REGRET.toString(), "1.");
            defaults.put(Parameter.FIXED_COST_PARAM.toString(), "0.");
            defaults.put(Parameter.VEHICLE_SWITCH.toString(), "true");
            defaults.put(Parameter.ITERATIONS.toString(), "2000");
            defaults.put(Parameter.REGRET_DISTANCE_SCORER.toString(), ".05");
            defaults.put(Parameter.REGRET_TIME_WINDOW_SCORER.toString(), "-.1");
            defaults.put(Parameter.THREADS.toString(), "1");
            int minShare = (int)Math.min(20.0, Math.max(3.0, (double)this.vrp.getJobs().size() * 0.05));
            int maxShare = (int)Math.min(50.0, Math.max(5.0, (double)this.vrp.getJobs().size() * 0.3));
            defaults.put(Parameter.RADIAL_MIN_SHARE.toString(), String.valueOf(minShare));
            defaults.put(Parameter.RADIAL_MAX_SHARE.toString(), String.valueOf(maxShare));
            defaults.put(Parameter.WORST_MIN_SHARE.toString(), String.valueOf(minShare));
            defaults.put(Parameter.WORST_MAX_SHARE.toString(), String.valueOf(maxShare));
            defaults.put(Parameter.CLUSTER_MIN_SHARE.toString(), String.valueOf(minShare));
            defaults.put(Parameter.CLUSTER_MAX_SHARE.toString(), String.valueOf(maxShare));
            int minShare_ = (int)Math.min(70.0, Math.max(5.0, (double)this.vrp.getJobs().size() * 0.5));
            int maxShare_ = (int)Math.min(70.0, Math.max(5.0, (double)this.vrp.getJobs().size() * 0.5));
            defaults.put(Parameter.RANDOM_REGRET_MIN_SHARE.toString(), String.valueOf(minShare_));
            defaults.put(Parameter.RANDOM_REGRET_MAX_SHARE.toString(), String.valueOf(maxShare_));
            defaults.put(Parameter.RANDOM_BEST_MIN_SHARE.toString(), String.valueOf(minShare_));
            defaults.put(Parameter.RANDOM_BEST_MAX_SHARE.toString(), String.valueOf(maxShare_));
            defaults.put(Parameter.THRESHOLD_ALPHA.toString(), String.valueOf(0.15));
            defaults.put(Parameter.THRESHOLD_INI.toString(), String.valueOf(0.03));
            defaults.put(Parameter.INSERTION_NOISE_LEVEL.toString(), String.valueOf(0.15));
            defaults.put(Parameter.INSERTION_NOISE_PROB.toString(), String.valueOf(0.2));
            defaults.put(Parameter.RUIN_WORST_NOISE_LEVEL.toString(), String.valueOf(0.15));
            defaults.put(Parameter.RUIN_WORST_NOISE_PROB.toString(), String.valueOf(0.2));
            defaults.put(Parameter.VEHICLE_SWITCH.toString(), String.valueOf(true));
            defaults.put(Parameter.FAST_REGRET.toString(), String.valueOf(false));
            defaults.put(Parameter.BREAK_SCHEDULING.toString(), String.valueOf(true));
            defaults.put(Parameter.CONSTRUCTION.toString(), Construction.REGRET_INSERTION.toString());
            defaults.put(Parameter.MIN_UNASSIGNED.toString(), String.valueOf(Integer.MAX_VALUE));
            defaults.put(Parameter.PROPORTION_UNASSIGNED.toString(), String.valueOf(1.0));
            return defaults;
        }

        public Builder addSearchStrategy(SearchStrategy searchStrategy, double weight) {
            this.customStrategies.put(searchStrategy, weight);
            return this;
        }

        public Builder setVehicleFleetManager(VehicleFleetManager fleetManager) {
            this.fleetManager = fleetManager;
            return this;
        }

        public Builder setExecutorService(ExecutorService es, int noThreads) {
            this.es = es;
            this.noThreads = noThreads;
            return this;
        }

        public Builder setCustomAcceptor(SolutionAcceptor acceptor) {
            this.solutionAcceptor = acceptor;
            return this;
        }

        public Builder setRandom(Random random) {
            this.random = random;
            return this;
        }

        public Builder setProperty(String key, String value) {
            this.properties.put(key, value);
            return this;
        }

        public Builder setProperty(Parameter parameter, String value) {
            this.setProperty(parameter.toString(), value);
            return this;
        }

        public Builder setProperty(Strategy strategy, String value) {
            this.setProperty(strategy.toString(), value);
            return this;
        }

        public Builder setStateAndConstraintManager(StateManager stateManager, ConstraintManager constraintManager) {
            this.stateManager = stateManager;
            this.constraintManager = constraintManager;
            return this;
        }

        public Builder setObjectiveFunction(SolutionCostCalculator objectiveFunction) {
            this.objectiveFunction = objectiveFunction;
            return this;
        }

        public Builder addCoreStateAndConstraintStuff(boolean addConstraints) {
            this.addConstraints = addConstraints;
            return this;
        }

        public Builder setActivityInsertionCalculator(ActivityInsertionCostsCalculator activityInsertionCalculator) {
            this.activityInsertionCalculator = activityInsertionCalculator;
            return this;
        }

        public Builder setRegretScorer(ScoringFunction scoringFunction) {
            this.regretScorer = scoringFunction;
            return this;
        }

        public VehicleRoutingAlgorithm buildAlgorithm() {
            return new Jsprit(this).create(this.vrp);
        }
    }

    public static enum Parameter {
        FIXED_COST_PARAM("fixed_cost_param"),
        VEHICLE_SWITCH("vehicle_switch"),
        REGRET_TIME_WINDOW_SCORER("regret.tw_scorer"),
        REGRET_DISTANCE_SCORER("regret.distance_scorer"),
        INITIAL_THRESHOLD("initial_threshold"),
        ITERATIONS("iterations"),
        THREADS("threads"),
        RANDOM_REGRET_MIN_SHARE("random_regret.min_share"),
        RANDOM_REGRET_MAX_SHARE("random_regret.max_share"),
        RANDOM_BEST_MIN_SHARE("random_best.min_share"),
        RANDOM_BEST_MAX_SHARE("random_best.max_share"),
        RADIAL_MIN_SHARE("radial.min_share"),
        RADIAL_MAX_SHARE("radial.max_share"),
        CLUSTER_MIN_SHARE("cluster.min_share"),
        CLUSTER_MAX_SHARE("cluster.max_share"),
        WORST_MIN_SHARE("worst.min_share"),
        WORST_MAX_SHARE("worst.max_share"),
        THRESHOLD_ALPHA("threshold.alpha"),
        THRESHOLD_INI("threshold.ini"),
        THRESHOLD_INI_ABS("threshold.ini_abs"),
        INSERTION_NOISE_LEVEL("insertion.noise_level"),
        INSERTION_NOISE_PROB("insertion.noise_prob"),
        RUIN_WORST_NOISE_LEVEL("worst.noise_level"),
        RUIN_WORST_NOISE_PROB("worst.noise_prob"),
        FAST_REGRET("regret.fast"),
        MAX_TRANSPORT_COSTS("max_transport_costs"),
        CONSTRUCTION("construction"),
        BREAK_SCHEDULING("break_scheduling"),
        STRING_K_MIN("string_kmin"),
        STRING_K_MAX("string_kmax"),
        STRING_L_MIN("string_lmin"),
        STRING_L_MAX("string_lmax"),
        MIN_UNASSIGNED("min_unassigned"),
        PROPORTION_UNASSIGNED("proportion_unassigned");

        String paraName;

        private Parameter(String name) {
            this.paraName = name;
        }

        public String toString() {
            return this.paraName;
        }
    }

    public static enum Strategy {
        RADIAL_BEST("radial_best"),
        RADIAL_REGRET("radial_regret"),
        RANDOM_BEST("random_best"),
        RANDOM_REGRET("random_regret"),
        WORST_BEST("worst_best"),
        WORST_REGRET("worst_regret"),
        CLUSTER_BEST("cluster_best"),
        CLUSTER_REGRET("cluster_regret"),
        STRING_BEST("string_best"),
        STRING_REGRET("string_regret");

        String strategyName;

        private Strategy(String strategyName) {
            this.strategyName = strategyName;
        }

        public String toString() {
            return this.strategyName;
        }
    }

    public static enum Construction {
        BEST_INSERTION("best_insertion"),
        REGRET_INSERTION("regret_insertion");

        String name;

        private Construction(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

