/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.algorithm.recreate.SolutionCompletenessRatio;
import com.graphhopper.jsprit.core.algorithm.state.InternalStates;
import com.graphhopper.jsprit.core.problem.Capacity;
import com.graphhopper.jsprit.core.problem.constraint.SoftRouteConstraint;
import com.graphhopper.jsprit.core.problem.misc.JobInsertionContext;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.state.RouteAndActivityStateGetter;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DecreasingRelativeFixedCosts
extends SolutionCompletenessRatio
implements SoftRouteConstraint {
    private static final Logger logger = LoggerFactory.getLogger(DecreasingRelativeFixedCosts.class);
    private double weightDeltaFixCost = 0.5;
    private RouteAndActivityStateGetter stateGetter;

    public DecreasingRelativeFixedCosts(RouteAndActivityStateGetter stateGetter, int noJobs) {
        super(noJobs);
        this.stateGetter = stateGetter;
        logger.debug("initialise {}", (Object)this);
    }

    public void setWeightOfFixCost(double weight) {
        this.weightDeltaFixCost = weight;
        logger.debug("set weightOfFixCostSaving to {}", (Object)weight);
    }

    public String toString() {
        return "[name=DecreasingRelativeFixedCosts][weightOfFixedCostSavings=" + this.weightDeltaFixCost + "]";
    }

    private Capacity getCurrentMaxLoadInRoute(VehicleRoute route) {
        Capacity maxLoad = this.stateGetter.getRouteState(route, InternalStates.MAXLOAD, Capacity.class);
        if (maxLoad == null) {
            maxLoad = Capacity.Builder.newInstance().build();
        }
        return maxLoad;
    }

    @Override
    public double getCosts(JobInsertionContext insertionContext) {
        VehicleRoute route = insertionContext.getRoute();
        Capacity currentLoad = this.getCurrentMaxLoadInRoute(route);
        Capacity load = Capacity.addup(currentLoad, insertionContext.getJob().getSize());
        double currentRelFix = 0.0;
        if (route.getVehicle() != null && !(route.getVehicle() instanceof VehicleImpl.NoVehicle)) {
            currentRelFix = route.getVehicle().getType().getVehicleCostParams().fix * Capacity.divide(currentLoad, route.getVehicle().getType().getCapacityDimensions());
        }
        double newRelFix = insertionContext.getNewVehicle().getType().getVehicleCostParams().fix * Capacity.divide(load, insertionContext.getNewVehicle().getType().getCapacityDimensions());
        double decreasingRelativeFixedCosts = (1.0 - this.solutionCompletenessRatio) * (newRelFix - currentRelFix);
        return this.weightDeltaFixCost * this.solutionCompletenessRatio * decreasingRelativeFixedCosts;
    }
}

