/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.algorithm.recreate.InsertionData;
import com.graphhopper.jsprit.core.algorithm.recreate.ScoringFunction;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Activity;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TimeWindow;

public class DefaultScorer
implements ScoringFunction {
    private VehicleRoutingProblem vrp;
    private double timeWindowParam = -0.5;
    private double depotDistanceParam = 0.1;
    private double minTimeWindowScore = -100000.0;

    public DefaultScorer(VehicleRoutingProblem vrp) {
        this.vrp = vrp;
    }

    public void setTimeWindowParam(double twParam) {
        this.timeWindowParam = twParam;
    }

    public void setDepotDistanceParam(double depotDistanceParam) {
        this.depotDistanceParam = depotDistanceParam;
    }

    @Override
    public double score(InsertionData best, Job job) {
        return this.scoreJob(best, job);
    }

    private double scoreJob(InsertionData best, Job job) {
        Location startLocation = best.getSelectedVehicle().getStartLocation();
        Location endLocation = best.getSelectedVehicle().getEndLocation();
        double maxDepotDistance = 0.0;
        double minTimeToOperate = Double.MAX_VALUE;
        for (Activity act : job.getActivities()) {
            maxDepotDistance = Math.max(maxDepotDistance, this.getDistance(startLocation, act.getLocation()));
            maxDepotDistance = Math.max(maxDepotDistance, this.getDistance(endLocation, act.getLocation()));
            TimeWindow tw = this.getLargestTimeWindow(act);
            minTimeToOperate = Math.min(minTimeToOperate, tw.getEnd() - tw.getStart());
        }
        return Math.max(this.timeWindowParam * minTimeToOperate, this.minTimeWindowScore) + this.depotDistanceParam * maxDepotDistance;
    }

    private TimeWindow getLargestTimeWindow(Activity act) {
        TimeWindow timeWindow = null;
        for (TimeWindow tw : act.getTimeWindows()) {
            if (timeWindow == null) {
                timeWindow = tw;
                continue;
            }
            if (!tw.larger(timeWindow)) continue;
            timeWindow = tw;
        }
        return TimeWindow.newInstance(0.0, Double.MAX_VALUE);
    }

    private double getDistance(Location loc1, Location loc2) {
        if (loc1 == null || loc2 == null) {
            return 0.0;
        }
        return this.vrp.getTransportCosts().getTransportCost(loc1, loc2, 0.0, null, null);
    }

    public String toString() {
        return "[name=defaultScorer][twParam=" + this.timeWindowParam + "][depotDistanceParam=" + this.depotDistanceParam + "]";
    }
}

