/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.algorithm.listener.VehicleRoutingAlgorithmListeners;
import com.graphhopper.jsprit.core.algorithm.recreate.ActivityInsertionCostsCalculator;
import com.graphhopper.jsprit.core.algorithm.recreate.BreakInsertionCalculatorFactory;
import com.graphhopper.jsprit.core.algorithm.recreate.CalculatesServiceInsertionWithTimeScheduling;
import com.graphhopper.jsprit.core.algorithm.recreate.ConfigureLocalActivityInsertionCalculator;
import com.graphhopper.jsprit.core.algorithm.recreate.JobCalculatorSwitcher;
import com.graphhopper.jsprit.core.algorithm.recreate.JobInsertionCostsCalculator;
import com.graphhopper.jsprit.core.algorithm.recreate.JobInsertionCostsCalculatorFactory;
import com.graphhopper.jsprit.core.algorithm.recreate.LocalActivityInsertionCostsCalculator;
import com.graphhopper.jsprit.core.algorithm.recreate.RouteLevelActivityInsertionCostsEstimator;
import com.graphhopper.jsprit.core.algorithm.recreate.ServiceInsertionCalculatorFactory;
import com.graphhopper.jsprit.core.algorithm.recreate.ServiceInsertionOnRouteLevelCalculator;
import com.graphhopper.jsprit.core.algorithm.recreate.ShipmentInsertionCalculatorFactory;
import com.graphhopper.jsprit.core.algorithm.recreate.VehicleTypeDependentJobInsertionCalculator;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.InsertionListener;
import com.graphhopper.jsprit.core.problem.AbstractActivity;
import com.graphhopper.jsprit.core.problem.JobActivityFactory;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.constraint.ConstraintManager;
import com.graphhopper.jsprit.core.problem.job.Break;
import com.graphhopper.jsprit.core.problem.job.Delivery;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.job.Pickup;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.job.Shipment;
import com.graphhopper.jsprit.core.problem.misc.JobInsertionContext;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.problem.solution.route.state.RouteAndActivityStateGetter;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleFleetManager;
import java.util.ArrayList;
import java.util.List;

public class JobInsertionCostsCalculatorBuilder {
    private List<InsertionListener> insertionListeners;
    private List<VehicleRoutingAlgorithmListeners.PrioritizedVRAListener> algorithmListeners;
    private VehicleRoutingProblem vrp;
    private RouteAndActivityStateGetter states;
    private boolean local = true;
    private int forwardLooking = 0;
    private int memory = 1;
    private boolean considerFixedCost = false;
    private double weightOfFixedCost = 0.0;
    private VehicleFleetManager fleetManager;
    private boolean timeScheduling = false;
    private double timeSlice;
    private int neighbors;
    private ConstraintManager constraintManager;
    private ActivityInsertionCostsCalculator activityInsertionCostCalculator = null;
    private boolean allowVehicleSwitch = true;
    private boolean addDefaultCostCalc = true;
    private JobInsertionCostsCalculatorFactory shipmentCalculatorFactory = new ShipmentInsertionCalculatorFactory();
    private JobInsertionCostsCalculatorFactory serviceCalculatorFactory = new ServiceInsertionCalculatorFactory();
    private JobInsertionCostsCalculatorFactory breakCalculatorFactory = new BreakInsertionCalculatorFactory();

    public JobInsertionCostsCalculatorBuilder(List<InsertionListener> insertionListeners, List<VehicleRoutingAlgorithmListeners.PrioritizedVRAListener> algorithmListeners) {
        this.insertionListeners = insertionListeners;
        this.algorithmListeners = algorithmListeners;
    }

    public JobInsertionCostsCalculatorBuilder setShipmentCalculatorFactory(JobInsertionCostsCalculatorFactory shipmentCalculatorFactory) {
        if (shipmentCalculatorFactory == null) {
            return this;
        }
        this.shipmentCalculatorFactory = shipmentCalculatorFactory;
        return this;
    }

    public JobInsertionCostsCalculatorBuilder setServiceCalculatorFactory(JobInsertionCostsCalculatorFactory serviceCalculatorFactory) {
        if (serviceCalculatorFactory == null) {
            return this;
        }
        this.serviceCalculatorFactory = serviceCalculatorFactory;
        return this;
    }

    public JobInsertionCostsCalculatorBuilder setBreakCalculatorFactory(JobInsertionCostsCalculatorFactory breakCalculatorFactory) {
        if (breakCalculatorFactory == null) {
            return this;
        }
        this.breakCalculatorFactory = breakCalculatorFactory;
        return this;
    }

    public JobInsertionCostsCalculatorBuilder setStateManager(RouteAndActivityStateGetter stateManager) {
        this.states = stateManager;
        return this;
    }

    public JobInsertionCostsCalculatorBuilder setVehicleRoutingProblem(VehicleRoutingProblem vehicleRoutingProblem) {
        this.vrp = vehicleRoutingProblem;
        return this;
    }

    public JobInsertionCostsCalculatorBuilder setVehicleFleetManager(VehicleFleetManager fleetManager) {
        this.fleetManager = fleetManager;
        return this;
    }

    public JobInsertionCostsCalculatorBuilder setLocalLevel(boolean addDefaultCostCalc) {
        this.local = true;
        this.addDefaultCostCalc = addDefaultCostCalc;
        return this;
    }

    public JobInsertionCostsCalculatorBuilder setActivityInsertionCostsCalculator(ActivityInsertionCostsCalculator activityInsertionCostsCalculator) {
        this.activityInsertionCostCalculator = activityInsertionCostsCalculator;
        return this;
    }

    public JobInsertionCostsCalculatorBuilder setRouteLevel(int forwardLooking, int memory, boolean addDefaultMarginalCostCalc) {
        this.local = false;
        this.forwardLooking = forwardLooking;
        this.memory = memory;
        return this;
    }

    public JobInsertionCostsCalculatorBuilder considerFixedCosts(double weightOfFixedCosts) {
        this.considerFixedCost = true;
        this.weightOfFixedCost = weightOfFixedCosts;
        return this;
    }

    public JobInsertionCostsCalculatorBuilder experimentalTimeScheduler(double timeSlice, int neighbors) {
        this.timeScheduling = true;
        this.timeSlice = timeSlice;
        this.neighbors = neighbors;
        return this;
    }

    public JobInsertionCostsCalculator build() {
        if (this.vrp == null) {
            throw new IllegalStateException("vehicle-routing-problem is null, but it must be set (this.setVehicleRoutingProblem(vrp))");
        }
        if (this.states == null) {
            throw new IllegalStateException("states is null, but is must be set (this.setStateManager(states))");
        }
        if (this.fleetManager == null) {
            throw new IllegalStateException("fleetManager is null, but it must be set (this.setVehicleFleetManager(fleetManager))");
        }
        JobInsertionCostsCalculator baseCalculator = null;
        CalculatorPlusListeners standardLocal = null;
        if (this.local) {
            standardLocal = this.createStandardLocal(this.vrp, this.states);
        } else {
            this.checkServicesOnly();
            standardLocal = this.createStandardRoute(this.vrp, this.states, this.forwardLooking, this.memory);
        }
        baseCalculator = standardLocal.getCalculator();
        this.addAlgorithmListeners(standardLocal.getAlgorithmListener());
        this.addInsertionListeners(standardLocal.getInsertionListener());
        if (this.considerFixedCost) {
            // empty if block
        }
        if (this.timeScheduling) {
            CalculatesServiceInsertionWithTimeScheduling wts = new CalculatesServiceInsertionWithTimeScheduling(baseCalculator, this.timeSlice, this.neighbors);
            CalculatorPlusListeners calcPlusListeners = new CalculatorPlusListeners(wts);
            calcPlusListeners.getInsertionListener().add(new CalculatesServiceInsertionWithTimeScheduling.KnowledgeInjection(wts));
            this.addInsertionListeners(calcPlusListeners.getInsertionListener());
            baseCalculator = calcPlusListeners.getCalculator();
        }
        return this.createFinalInsertion(this.fleetManager, baseCalculator, this.states);
    }

    private void checkServicesOnly() {
        for (Job j : this.vrp.getJobs().values()) {
            if (!(j instanceof Shipment)) continue;
            throw new UnsupportedOperationException("currently the 'insert-on-route-level' option is only available for services (i.e. service, pickup, delivery), \nif you want to deal with shipments switch to option 'local-level' by either setting bestInsertionBuilder.setLocalLevel() or \nby omitting the xml-tag '<level forwardLooking=2 memory=1>route</level>' when defining your insertionStrategy in algo-config.xml file");
        }
    }

    private void addInsertionListeners(List<InsertionListener> list) {
        for (InsertionListener iL : list) {
            this.insertionListeners.add(iL);
        }
    }

    private void addAlgorithmListeners(List<VehicleRoutingAlgorithmListeners.PrioritizedVRAListener> list) {
        for (VehicleRoutingAlgorithmListeners.PrioritizedVRAListener aL : list) {
            this.algorithmListeners.add(aL);
        }
    }

    private CalculatorPlusListeners createStandardLocal(final VehicleRoutingProblem vrp, RouteAndActivityStateGetter statesManager) {
        ActivityInsertionCostsCalculator actInsertionCalc;
        if (this.constraintManager == null) {
            throw new IllegalStateException("constraint-manager is null");
        }
        ConfigureLocalActivityInsertionCalculator configLocal = null;
        if (this.activityInsertionCostCalculator == null && this.addDefaultCostCalc) {
            actInsertionCalc = new LocalActivityInsertionCostsCalculator(vrp.getTransportCosts(), vrp.getActivityCosts(), statesManager);
            configLocal = new ConfigureLocalActivityInsertionCalculator(vrp, (LocalActivityInsertionCostsCalculator)actInsertionCalc);
        } else {
            actInsertionCalc = this.activityInsertionCostCalculator == null && !this.addDefaultCostCalc ? new ActivityInsertionCostsCalculator(){

                @Override
                public double getCosts(JobInsertionContext iContext, TourActivity prevAct, TourActivity nextAct, TourActivity newAct, double depTimeAtPrevAct) {
                    return 0.0;
                }
            } : this.activityInsertionCostCalculator;
        }
        JobActivityFactory activityFactory = new JobActivityFactory(){

            @Override
            public List<AbstractActivity> createActivities(Job job) {
                return vrp.copyAndGetActivities(job);
            }
        };
        JobInsertionCostsCalculator shipmentInsertion = this.shipmentCalculatorFactory.create(vrp, actInsertionCalc, activityFactory, this.constraintManager);
        JobInsertionCostsCalculator serviceInsertion = this.serviceCalculatorFactory.create(vrp, actInsertionCalc, activityFactory, this.constraintManager);
        JobInsertionCostsCalculator breakInsertion = this.breakCalculatorFactory.create(vrp, actInsertionCalc, activityFactory, this.constraintManager);
        JobCalculatorSwitcher switcher = new JobCalculatorSwitcher();
        switcher.put(Shipment.class, shipmentInsertion);
        switcher.put(Service.class, serviceInsertion);
        switcher.put(Pickup.class, serviceInsertion);
        switcher.put(Delivery.class, serviceInsertion);
        switcher.put(Break.class, breakInsertion);
        CalculatorPlusListeners calculatorPlusListeners = new CalculatorPlusListeners(switcher);
        if (configLocal != null) {
            calculatorPlusListeners.insertionListener.add(configLocal);
        }
        return calculatorPlusListeners;
    }

    private CalculatorPlusListeners createStandardRoute(final VehicleRoutingProblem vrp, RouteAndActivityStateGetter activityStates2, int forwardLooking, int solutionMemory) {
        ActivityInsertionCostsCalculator routeLevelCostEstimator;
        if (this.activityInsertionCostCalculator == null && this.addDefaultCostCalc) {
            RouteLevelActivityInsertionCostsEstimator routeLevelActivityInsertionCostsEstimator = new RouteLevelActivityInsertionCostsEstimator(vrp.getTransportCosts(), vrp.getActivityCosts(), activityStates2);
            routeLevelActivityInsertionCostsEstimator.setForwardLooking(forwardLooking);
            routeLevelCostEstimator = routeLevelActivityInsertionCostsEstimator;
        } else {
            routeLevelCostEstimator = this.activityInsertionCostCalculator == null && !this.addDefaultCostCalc ? new ActivityInsertionCostsCalculator(){
                final ActivityInsertionCostsCalculator.ActivityInsertionCosts noInsertionCosts = new ActivityInsertionCostsCalculator.ActivityInsertionCosts(0.0, 0.0);

                @Override
                public double getCosts(JobInsertionContext iContext, TourActivity prevAct, TourActivity nextAct, TourActivity newAct, double depTimeAtPrevAct) {
                    return 0.0;
                }
            } : this.activityInsertionCostCalculator;
        }
        ServiceInsertionOnRouteLevelCalculator jobInsertionCalculator = new ServiceInsertionOnRouteLevelCalculator(vrp.getTransportCosts(), vrp.getActivityCosts(), routeLevelCostEstimator, this.constraintManager, this.constraintManager);
        jobInsertionCalculator.setNuOfActsForwardLooking(forwardLooking);
        jobInsertionCalculator.setMemorySize(solutionMemory);
        jobInsertionCalculator.setStates(activityStates2);
        jobInsertionCalculator.setJobActivityFactory(new JobActivityFactory(){

            @Override
            public List<AbstractActivity> createActivities(Job job) {
                return vrp.copyAndGetActivities(job);
            }
        });
        return new CalculatorPlusListeners(jobInsertionCalculator);
    }

    private JobInsertionCostsCalculator createFinalInsertion(VehicleFleetManager fleetManager, JobInsertionCostsCalculator baseCalc, RouteAndActivityStateGetter activityStates2) {
        VehicleTypeDependentJobInsertionCalculator vehicleTypeDependentJobInsertionCalculator = new VehicleTypeDependentJobInsertionCalculator(this.vrp, fleetManager, baseCalc);
        vehicleTypeDependentJobInsertionCalculator.setVehicleSwitchAllowed(this.allowVehicleSwitch);
        return vehicleTypeDependentJobInsertionCalculator;
    }

    public JobInsertionCostsCalculatorBuilder setConstraintManager(ConstraintManager constraintManager) {
        this.constraintManager = constraintManager;
        return this;
    }

    public JobInsertionCostsCalculatorBuilder setAllowVehicleSwitch(boolean allowVehicleSwitch) {
        this.allowVehicleSwitch = allowVehicleSwitch;
        return this;
    }

    private static class CalculatorPlusListeners {
        private JobInsertionCostsCalculator calculator;
        private List<VehicleRoutingAlgorithmListeners.PrioritizedVRAListener> algorithmListener = new ArrayList<VehicleRoutingAlgorithmListeners.PrioritizedVRAListener>();
        private List<InsertionListener> insertionListener = new ArrayList<InsertionListener>();

        public JobInsertionCostsCalculator getCalculator() {
            return this.calculator;
        }

        public CalculatorPlusListeners(JobInsertionCostsCalculator calculator) {
            this.calculator = calculator;
        }

        public List<VehicleRoutingAlgorithmListeners.PrioritizedVRAListener> getAlgorithmListener() {
            return this.algorithmListener;
        }

        public List<InsertionListener> getInsertionListener() {
            return this.insertionListener;
        }
    }
}

