/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.algorithm.recreate.AbstractInsertionCalculator;
import com.graphhopper.jsprit.core.algorithm.recreate.ActivityInsertionCostsCalculator;
import com.graphhopper.jsprit.core.algorithm.recreate.AdditionalAccessEgressCalculator;
import com.graphhopper.jsprit.core.algorithm.recreate.InsertActivity;
import com.graphhopper.jsprit.core.algorithm.recreate.InsertionData;
import com.graphhopper.jsprit.core.algorithm.recreate.SwitchVehicle;
import com.graphhopper.jsprit.core.problem.JobActivityFactory;
import com.graphhopper.jsprit.core.problem.constraint.ConstraintManager;
import com.graphhopper.jsprit.core.problem.constraint.HardActivityConstraint;
import com.graphhopper.jsprit.core.problem.constraint.HardConstraint;
import com.graphhopper.jsprit.core.problem.constraint.SoftActivityConstraint;
import com.graphhopper.jsprit.core.problem.constraint.SoftRouteConstraint;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingActivityCosts;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingTransportCosts;
import com.graphhopper.jsprit.core.problem.driver.Driver;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.job.Shipment;
import com.graphhopper.jsprit.core.problem.misc.ActivityContext;
import com.graphhopper.jsprit.core.problem.misc.JobInsertionContext;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.End;
import com.graphhopper.jsprit.core.problem.solution.route.activity.Start;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TimeWindow;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ShipmentInsertionCalculator
extends AbstractInsertionCalculator {
    private static final Logger logger = LoggerFactory.getLogger(ShipmentInsertionCalculator.class);
    private final ConstraintManager constraintManager;
    private final SoftRouteConstraint softRouteConstraint;
    private final SoftActivityConstraint softActivityConstraint;
    private final ActivityInsertionCostsCalculator activityInsertionCostsCalculator;
    private final VehicleRoutingTransportCosts transportCosts;
    private final VehicleRoutingActivityCosts activityCosts;
    private final JobActivityFactory activityFactory;
    private final AdditionalAccessEgressCalculator additionalAccessEgressCalculator;

    public ShipmentInsertionCalculator(VehicleRoutingTransportCosts routingCosts, VehicleRoutingActivityCosts activityCosts, ActivityInsertionCostsCalculator activityInsertionCostsCalculator, ConstraintManager constraintManager, JobActivityFactory jobActivityFactory) {
        this.activityInsertionCostsCalculator = activityInsertionCostsCalculator;
        this.constraintManager = constraintManager;
        this.softActivityConstraint = constraintManager;
        this.softRouteConstraint = constraintManager;
        this.transportCosts = routingCosts;
        this.activityCosts = activityCosts;
        this.additionalAccessEgressCalculator = new AdditionalAccessEgressCalculator(routingCosts);
        this.activityFactory = jobActivityFactory;
        logger.debug("initialise {}", (Object)this);
    }

    public String toString() {
        return "[name=calculatesShipmentInsertion]";
    }

    @Override
    public InsertionData getInsertionData(VehicleRoute currentRoute, Job jobToInsert, Vehicle newVehicle, double newVehicleDepartureTime, Driver newDriver, double bestKnownCosts) {
        JobInsertionContext insertionContext = new JobInsertionContext(currentRoute, jobToInsert, newVehicle, newDriver, newVehicleDepartureTime);
        Shipment shipment = (Shipment)jobToInsert;
        TourActivity pickupShipment = this.activityFactory.createActivities(shipment).get(0);
        TourActivity deliverShipment = this.activityFactory.createActivities(shipment).get(1);
        insertionContext.getAssociatedActivities().add(pickupShipment);
        insertionContext.getAssociatedActivities().add(deliverShipment);
        InsertionData noInsertion = this.checkRouteContraints(insertionContext, this.constraintManager);
        if (noInsertion != null) {
            return noInsertion;
        }
        double additionalICostsAtRouteLevel = this.softRouteConstraint.getCosts(insertionContext);
        double bestCost = bestKnownCosts;
        additionalICostsAtRouteLevel += this.additionalAccessEgressCalculator.getCosts(insertionContext);
        int pickupInsertionIndex = InsertionData.NO_INDEX;
        int deliveryInsertionIndex = InsertionData.NO_INDEX;
        TimeWindow bestPickupTimeWindow = null;
        TimeWindow bestDeliveryTimeWindow = null;
        Start start = new Start(newVehicle.getStartLocation(), newVehicle.getEarliestDeparture(), newVehicle.getLatestArrival());
        start.setEndTime(newVehicleDepartureTime);
        End end = new End(newVehicle.getEndLocation(), 0.0, newVehicle.getLatestArrival());
        ActivityContext pickupContext = new ActivityContext();
        TourActivity prevAct = start;
        double prevActEndTime = newVehicleDepartureTime;
        int i = 0;
        boolean tourEnd = false;
        List<TourActivity> activities = currentRoute.getTourActivities().getActivities();
        ArrayList<HardConstraint> failedActivityConstraints = new ArrayList<HardConstraint>();
        while (!tourEnd) {
            TourActivity nextAct;
            if (i < activities.size()) {
                nextAct = activities.get(i);
            } else {
                nextAct = end;
                tourEnd = true;
            }
            boolean pickupInsertionNotFulfilledBreak = true;
            block1: for (TimeWindow pickupTimeWindow : shipment.getPickupTimeWindows()) {
                pickupShipment.setTheoreticalEarliestOperationStartTime(pickupTimeWindow.getStart());
                pickupShipment.setTheoreticalLatestOperationStartTime(pickupTimeWindow.getEnd());
                ActivityContext activityContext = new ActivityContext();
                activityContext.setInsertionIndex(i);
                insertionContext.setActivityContext(activityContext);
                HardActivityConstraint.ConstraintsStatus pickupShipmentConstraintStatus = this.fulfilled(insertionContext, prevAct, pickupShipment, nextAct, prevActEndTime, failedActivityConstraints, this.constraintManager);
                if (pickupShipmentConstraintStatus.equals((Object)HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED)) {
                    pickupInsertionNotFulfilledBreak = false;
                    continue;
                }
                if (pickupShipmentConstraintStatus.equals((Object)HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED_BREAK)) continue;
                if (pickupShipmentConstraintStatus.equals((Object)HardActivityConstraint.ConstraintsStatus.FULFILLED)) {
                    pickupInsertionNotFulfilledBreak = false;
                }
                double additionalPickupICosts = this.softActivityConstraint.getCosts(insertionContext, prevAct, pickupShipment, nextAct, prevActEndTime);
                double pickupAIC = this.calculate(insertionContext, prevAct, pickupShipment, nextAct, prevActEndTime);
                TourActivity prevAct_deliveryLoop = pickupShipment;
                double shipmentPickupArrTime = prevActEndTime + this.transportCosts.getTransportTime(prevAct.getLocation(), pickupShipment.getLocation(), prevActEndTime, newDriver, newVehicle);
                double shipmentPickupEndTime = Math.max(shipmentPickupArrTime, pickupShipment.getTheoreticalEarliestOperationStartTime()) + this.activityCosts.getActivityDuration(pickupShipment, shipmentPickupArrTime, newDriver, newVehicle);
                pickupContext.setArrivalTime(shipmentPickupArrTime);
                pickupContext.setEndTime(shipmentPickupEndTime);
                pickupContext.setInsertionIndex(i);
                insertionContext.setRelatedActivityContext(pickupContext);
                double prevActEndTime_deliveryLoop = shipmentPickupEndTime;
                if (bestCost <= pickupAIC + additionalPickupICosts + additionalICostsAtRouteLevel) continue;
                int j = i;
                boolean tourEnd_deliveryLoop = false;
                while (!tourEnd_deliveryLoop) {
                    TourActivity nextAct_deliveryLoop;
                    if (j < activities.size()) {
                        nextAct_deliveryLoop = activities.get(j);
                    } else {
                        nextAct_deliveryLoop = end;
                        tourEnd_deliveryLoop = true;
                    }
                    boolean deliveryInsertionNotFulfilledBreak = true;
                    for (TimeWindow deliveryTimeWindow : shipment.getDeliveryTimeWindows()) {
                        deliverShipment.setTheoreticalEarliestOperationStartTime(deliveryTimeWindow.getStart());
                        deliverShipment.setTheoreticalLatestOperationStartTime(deliveryTimeWindow.getEnd());
                        ActivityContext activityContext_ = new ActivityContext();
                        activityContext_.setInsertionIndex(j);
                        insertionContext.setActivityContext(activityContext_);
                        HardActivityConstraint.ConstraintsStatus deliverShipmentConstraintStatus = this.fulfilled(insertionContext, prevAct_deliveryLoop, deliverShipment, nextAct_deliveryLoop, prevActEndTime_deliveryLoop, failedActivityConstraints, this.constraintManager);
                        if (deliverShipmentConstraintStatus.equals((Object)HardActivityConstraint.ConstraintsStatus.FULFILLED)) {
                            double additionalDeliveryICosts = this.softActivityConstraint.getCosts(insertionContext, prevAct_deliveryLoop, deliverShipment, nextAct_deliveryLoop, prevActEndTime_deliveryLoop);
                            double deliveryAIC = this.calculate(insertionContext, prevAct_deliveryLoop, deliverShipment, nextAct_deliveryLoop, prevActEndTime_deliveryLoop);
                            double totalActivityInsertionCosts = pickupAIC + deliveryAIC + additionalICostsAtRouteLevel + additionalPickupICosts + additionalDeliveryICosts;
                            if (totalActivityInsertionCosts < bestCost) {
                                bestCost = totalActivityInsertionCosts;
                                pickupInsertionIndex = i;
                                deliveryInsertionIndex = j;
                                bestPickupTimeWindow = pickupTimeWindow;
                                bestDeliveryTimeWindow = deliveryTimeWindow;
                            }
                            deliveryInsertionNotFulfilledBreak = false;
                            continue;
                        }
                        if (!deliverShipmentConstraintStatus.equals((Object)HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED)) continue;
                        deliveryInsertionNotFulfilledBreak = false;
                    }
                    if (deliveryInsertionNotFulfilledBreak) continue block1;
                    double nextActArrTime = prevActEndTime_deliveryLoop + this.transportCosts.getTransportTime(prevAct_deliveryLoop.getLocation(), nextAct_deliveryLoop.getLocation(), prevActEndTime_deliveryLoop, newDriver, newVehicle);
                    prevActEndTime_deliveryLoop = Math.max(nextActArrTime, nextAct_deliveryLoop.getTheoreticalEarliestOperationStartTime()) + this.activityCosts.getActivityDuration(nextAct_deliveryLoop, nextActArrTime, newDriver, newVehicle);
                    prevAct_deliveryLoop = nextAct_deliveryLoop;
                    ++j;
                }
            }
            if (pickupInsertionNotFulfilledBreak) break;
            double nextActArrTime = prevActEndTime + this.transportCosts.getTransportTime(prevAct.getLocation(), nextAct.getLocation(), prevActEndTime, newDriver, newVehicle);
            prevActEndTime = Math.max(nextActArrTime, nextAct.getTheoreticalEarliestOperationStartTime()) + this.activityCosts.getActivityDuration(nextAct, nextActArrTime, newDriver, newVehicle);
            prevAct = nextAct;
            ++i;
        }
        if (pickupInsertionIndex == InsertionData.NO_INDEX) {
            InsertionData.NoInsertionFound emptyInsertionData = new InsertionData.NoInsertionFound();
            for (HardConstraint failed : failedActivityConstraints) {
                emptyInsertionData.addFailedConstrainName(failed.getClass().getSimpleName());
            }
            return emptyInsertionData;
        }
        InsertionData insertionData = new InsertionData(bestCost, pickupInsertionIndex, deliveryInsertionIndex, newVehicle, newDriver);
        pickupShipment.setTheoreticalEarliestOperationStartTime(bestPickupTimeWindow.getStart());
        pickupShipment.setTheoreticalLatestOperationStartTime(bestPickupTimeWindow.getEnd());
        deliverShipment.setTheoreticalEarliestOperationStartTime(bestDeliveryTimeWindow.getStart());
        deliverShipment.setTheoreticalLatestOperationStartTime(bestDeliveryTimeWindow.getEnd());
        insertionData.setVehicleDepartureTime(newVehicleDepartureTime);
        insertionData.getEvents().add(new InsertActivity(currentRoute, newVehicle, deliverShipment, deliveryInsertionIndex));
        insertionData.getEvents().add(new InsertActivity(currentRoute, newVehicle, pickupShipment, pickupInsertionIndex));
        insertionData.getEvents().add(new SwitchVehicle(currentRoute, newVehicle, newVehicleDepartureTime));
        return insertionData;
    }

    private double calculate(JobInsertionContext iFacts, TourActivity prevAct, TourActivity newAct, TourActivity nextAct, double departureTimeAtPrevAct) {
        return this.activityInsertionCostsCalculator.getCosts(iFacts, prevAct, nextAct, newAct, departureTimeAtPrevAct);
    }
}

