/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.ruin;

import com.graphhopper.jsprit.core.algorithm.listener.IterationStartsListener;
import com.graphhopper.jsprit.core.algorithm.ruin.AbstractRuinStrategy;
import com.graphhopper.jsprit.core.algorithm.ruin.DBSCANClusterer;
import com.graphhopper.jsprit.core.algorithm.ruin.JobNeighborhoods;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.util.RandomUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.ml.clustering.Clusterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuinClusters
extends AbstractRuinStrategy
implements IterationStartsListener {
    private final Logger logger = LoggerFactory.getLogger(RuinClusters.class);
    private final VehicleRoutingProblem vrp;
    private final JobNeighborhoods jobNeighborhoods;
    private int noClusters = 2;
    private int minPts = 1;
    private double epsFactor = 0.8;

    @Override
    public void informIterationStarts(int i, VehicleRoutingProblem problem, Collection<VehicleRoutingProblemSolution> solutions) {
        this.minPts = 1 + this.random.nextInt(2);
        this.epsFactor = 0.5 + this.random.nextDouble();
    }

    public RuinClusters(VehicleRoutingProblem vrp, int initialNumberJobsToRemove, JobNeighborhoods jobNeighborhoods) {
        super(vrp);
        this.vrp = vrp;
        this.setRuinShareFactory(() -> initialNumberJobsToRemove);
        this.jobNeighborhoods = jobNeighborhoods;
        this.logger.debug("initialise {}", (Object)this);
    }

    public void setNoClusters(int noClusters) {
        this.noClusters = noClusters;
    }

    @Override
    public Collection<Job> ruinRoutes(Collection<VehicleRoute> vehicleRoutes) {
        ArrayList<Job> unassignedJobs = new ArrayList<Job>();
        int nOfJobs2BeRemoved = this.getRuinShareFactory().createNumberToBeRemoved();
        this.ruin(vehicleRoutes, nOfJobs2BeRemoved, unassignedJobs);
        return unassignedJobs;
    }

    private void ruin(Collection<VehicleRoute> vehicleRoutes, int nOfJobs2BeRemoved, List<Job> unassignedJobs) {
        if (this.vrp.getJobs().values().size() == 0) {
            return;
        }
        Map<Job, VehicleRoute> mappedRoutes = this.map(vehicleRoutes);
        int toRemove = nOfJobs2BeRemoved;
        ArrayList<Job> lastRemoved = new ArrayList<Job>();
        HashSet<VehicleRoute> ruined = new HashSet<VehicleRoute>();
        HashSet removed = new HashSet();
        HashSet<VehicleRoute> cycleCandidates = new HashSet<VehicleRoute>();
        while (toRemove > 0) {
            Job target;
            VehicleRoute targetRoute = null;
            if (lastRemoved.isEmpty()) {
                target = RandomUtils.nextJob(this.vrp.getJobs().values(), this.random);
                targetRoute = mappedRoutes.get(target);
            } else {
                target = RandomUtils.nextJob(lastRemoved, this.random);
                Iterator<Job> neighborIterator = this.jobNeighborhoods.getNearestNeighborsIterator(nOfJobs2BeRemoved, target);
                while (neighborIterator.hasNext()) {
                    Job j = neighborIterator.next();
                    if (removed.contains(j) || ruined.contains(mappedRoutes.get(j))) continue;
                    targetRoute = mappedRoutes.get(j);
                    break;
                }
                lastRemoved.clear();
            }
            if (targetRoute == null || cycleCandidates.contains(targetRoute)) break;
            if (ruined.contains(targetRoute)) {
                cycleCandidates.add(targetRoute);
                break;
            }
            DBSCANClusterer dbscan = new DBSCANClusterer(this.vrp.getTransportCosts());
            dbscan.setRandom(this.random);
            dbscan.setMinPts(this.minPts);
            dbscan.setEpsFactor(this.epsFactor);
            List<Job> cluster = dbscan.getRandomCluster(targetRoute);
            for (Job j : cluster) {
                if (toRemove == 0) break;
                if (this.removeJob(j, vehicleRoutes)) {
                    lastRemoved.add(j);
                    unassignedJobs.add(j);
                }
                --toRemove;
            }
            ruined.add(targetRoute);
        }
    }

    private Map<Job, VehicleRoute> map(Collection<VehicleRoute> vehicleRoutes) {
        HashMap<Job, VehicleRoute> map = new HashMap<Job, VehicleRoute>(this.vrp.getJobs().size());
        for (VehicleRoute r : vehicleRoutes) {
            for (Job j : r.getTourActivities().getJobs()) {
                map.put(j, r);
            }
        }
        return map;
    }

    public String toString() {
        return "[name=clusterRuin]";
    }

    public static class JobActivityWrapper
    implements Clusterable {
        private TourActivity.JobActivity jobActivity;

        public JobActivityWrapper(TourActivity.JobActivity jobActivity) {
            this.jobActivity = jobActivity;
        }

        public double[] getPoint() {
            return new double[]{this.jobActivity.getLocation().getCoordinate().getX(), this.jobActivity.getLocation().getCoordinate().getY()};
        }

        public TourActivity.JobActivity getActivity() {
            return this.jobActivity;
        }
    }
}

