/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.ruin;

import com.graphhopper.jsprit.core.algorithm.ruin.AbstractRuinStrategy;
import com.graphhopper.jsprit.core.algorithm.ruin.JobNeighborhoods;
import com.graphhopper.jsprit.core.algorithm.ruin.JobNeighborhoodsImplWithCapRestriction;
import com.graphhopper.jsprit.core.algorithm.ruin.distance.JobDistance;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.util.RandomUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuinRadial
extends AbstractRuinStrategy {
    private Logger logger = LoggerFactory.getLogger(RuinRadial.class);
    private VehicleRoutingProblem vrp;
    private JobNeighborhoods jobNeighborhoods;
    private final int noJobsToMemorize;

    public RuinRadial(VehicleRoutingProblem vrp, double fraction2beRemoved, JobDistance jobDistance) {
        super(vrp);
        this.vrp = vrp;
        this.noJobsToMemorize = (int)Math.ceil((double)vrp.getJobs().values().size() * fraction2beRemoved);
        this.ruinShareFactory = () -> this.noJobsToMemorize;
        JobNeighborhoodsImplWithCapRestriction jobNeighborhoodsImpl = new JobNeighborhoodsImplWithCapRestriction(vrp, jobDistance, this.noJobsToMemorize);
        jobNeighborhoodsImpl.initialise();
        this.jobNeighborhoods = jobNeighborhoodsImpl;
        this.logger.debug("initialise {}", (Object)this);
    }

    public RuinRadial(VehicleRoutingProblem vrp, int noJobs2beRemoved, JobDistance jobDistance) {
        super(vrp);
        this.vrp = vrp;
        this.noJobsToMemorize = noJobs2beRemoved;
        this.ruinShareFactory = () -> this.noJobsToMemorize;
        JobNeighborhoodsImplWithCapRestriction jobNeighborhoodsImpl = new JobNeighborhoodsImplWithCapRestriction(vrp, jobDistance, this.noJobsToMemorize);
        jobNeighborhoodsImpl.initialise();
        this.jobNeighborhoods = jobNeighborhoodsImpl;
        this.logger.debug("initialise {}", (Object)this);
    }

    public RuinRadial(VehicleRoutingProblem vrp, int noJobs2beRemoved, JobNeighborhoods neighborhoods) {
        super(vrp);
        this.vrp = vrp;
        this.noJobsToMemorize = noJobs2beRemoved;
        this.ruinShareFactory = () -> this.noJobsToMemorize;
        this.jobNeighborhoods = neighborhoods;
        this.logger.debug("initialise {}", (Object)this);
    }

    public String toString() {
        return "[name=radialRuin][noJobsToBeRemoved=" + this.noJobsToMemorize + "]";
    }

    @Override
    public Collection<Job> ruinRoutes(Collection<VehicleRoute> vehicleRoutes) {
        if (vehicleRoutes.isEmpty()) {
            return Collections.emptyList();
        }
        int nOfJobs2BeRemoved = Math.min(this.ruinShareFactory.createNumberToBeRemoved(), this.noJobsToMemorize);
        Collection<Job> jobs = this.vrp.getJobsWithLocation();
        if (nOfJobs2BeRemoved == 0 || jobs.isEmpty()) {
            return Collections.emptyList();
        }
        Job randomJob = RandomUtils.nextJob(jobs, this.random);
        return this.ruinRoutes(vehicleRoutes, randomJob, nOfJobs2BeRemoved);
    }

    private Collection<Job> ruinRoutes(Collection<VehicleRoute> vehicleRoutes, Job targetJob, int nOfJobs2BeRemoved) {
        ArrayList<Job> unassignedJobs = new ArrayList<Job>();
        int nNeighbors = nOfJobs2BeRemoved - 1;
        this.removeJob(targetJob, vehicleRoutes);
        unassignedJobs.add(targetJob);
        Iterator<Job> neighborhoodIterator = this.jobNeighborhoods.getNearestNeighborsIterator(nNeighbors, targetJob);
        while (neighborhoodIterator.hasNext()) {
            Job job = neighborhoodIterator.next();
            if (!this.removeJob(job, vehicleRoutes)) continue;
            unassignedJobs.add(job);
        }
        return unassignedJobs;
    }
}

