/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem;

import com.graphhopper.jsprit.core.problem.AbstractActivity;
import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.JobActivityFactory;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingActivityCosts;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingTransportCosts;
import com.graphhopper.jsprit.core.problem.cost.WaitingTimeCosts;
import com.graphhopper.jsprit.core.problem.job.Activity;
import com.graphhopper.jsprit.core.problem.job.Break;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.job.Shipment;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.BreakActivity;
import com.graphhopper.jsprit.core.problem.solution.route.activity.DefaultShipmentActivityFactory;
import com.graphhopper.jsprit.core.problem.solution.route.activity.DefaultTourActivityFactory;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeKey;
import com.graphhopper.jsprit.core.util.Coordinate;
import com.graphhopper.jsprit.core.util.CrowFlyCosts;
import com.graphhopper.jsprit.core.util.Locations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VehicleRoutingProblem {
    private static final Logger logger = LoggerFactory.getLogger(VehicleRoutingProblem.class);
    private final VehicleRoutingTransportCosts transportCosts;
    private final VehicleRoutingActivityCosts activityCosts;
    private final Map<String, Job> jobs;
    private List<Job> jobsWithLocation;
    private final Map<String, Job> allJobs;
    private final Collection<Vehicle> vehicles;
    private final Collection<VehicleType> vehicleTypes;
    private final Collection<VehicleRoute> initialVehicleRoutes;
    private final Collection<Location> allLocations;
    private final FleetSize fleetSize;
    private Map<Job, List<AbstractActivity>> activityMap;
    private int nuActivities;
    private final JobActivityFactory jobActivityFactory = this::copyAndGetActivities;

    private VehicleRoutingProblem(Builder builder) {
        this.jobs = builder.jobs;
        this.jobsWithLocation = builder.jobsWithLocation;
        this.fleetSize = builder.fleetSize;
        this.vehicles = builder.uniqueVehicles;
        this.vehicleTypes = builder.vehicleTypes.values();
        this.initialVehicleRoutes = builder.initialRoutes;
        this.transportCosts = builder.transportCosts;
        this.activityCosts = builder.activityCosts;
        this.activityMap = builder.activityMap;
        this.nuActivities = builder.activityIndexCounter;
        this.allLocations = builder.allLocations;
        this.allJobs = new HashMap<String, Job>(this.jobs);
        this.allJobs.putAll(builder.jobsInInitialRoutes);
        logger.info("setup problem: {}", (Object)this);
    }

    public String toString() {
        return "[fleetSize=" + (Object)((Object)this.fleetSize) + "][#jobs=" + this.jobs.size() + "][#vehicles=" + this.vehicles.size() + "][#vehicleTypes=" + this.vehicleTypes.size() + "][transportCost=" + this.transportCosts + "][activityCosts=" + this.activityCosts + "]";
    }

    public FleetSize getFleetSize() {
        return this.fleetSize;
    }

    public Map<String, Job> getJobs() {
        return Collections.unmodifiableMap(this.jobs);
    }

    public Collection<Job> getJobsWithLocation() {
        return Collections.unmodifiableList(this.jobsWithLocation);
    }

    public Map<String, Job> getJobsInclusiveInitialJobsInRoutes() {
        return Collections.unmodifiableMap(this.allJobs);
    }

    public Collection<VehicleRoute> getInitialVehicleRoutes() {
        ArrayList<VehicleRoute> copiedInitialRoutes = new ArrayList<VehicleRoute>();
        for (VehicleRoute route : this.initialVehicleRoutes) {
            copiedInitialRoutes.add(VehicleRoute.copyOf(route));
        }
        return copiedInitialRoutes;
    }

    public Collection<VehicleType> getTypes() {
        return Collections.unmodifiableCollection(this.vehicleTypes);
    }

    public Collection<Vehicle> getVehicles() {
        return Collections.unmodifiableCollection(this.vehicles);
    }

    public VehicleRoutingTransportCosts getTransportCosts() {
        return this.transportCosts;
    }

    public VehicleRoutingActivityCosts getActivityCosts() {
        return this.activityCosts;
    }

    public Collection<Location> getAllLocations() {
        return this.allLocations;
    }

    public List<AbstractActivity> getActivities(Job job) {
        return Collections.unmodifiableList(this.activityMap.get(job));
    }

    public int getNuActivities() {
        return this.nuActivities;
    }

    public JobActivityFactory getJobActivityFactory() {
        return this.jobActivityFactory;
    }

    public List<AbstractActivity> copyAndGetActivities(Job job) {
        ArrayList<AbstractActivity> acts = new ArrayList<AbstractActivity>();
        if (this.activityMap.containsKey(job)) {
            for (AbstractActivity act : this.activityMap.get(job)) {
                acts.add((AbstractActivity)act.duplicate());
            }
        }
        return acts;
    }

    public static enum FleetSize {
        FINITE,
        INFINITE;

    }

    public static class Builder {
        private VehicleRoutingTransportCosts transportCosts;
        private VehicleRoutingActivityCosts activityCosts = new WaitingTimeCosts();
        private Map<String, Job> jobs = new LinkedHashMap<String, Job>();
        private List<Job> jobsWithLocation = new ArrayList<Job>();
        private Map<String, Job> tentativeJobs = new LinkedHashMap<String, Job>();
        private Map<String, Job> jobsInInitialRoutes = new LinkedHashMap<String, Job>();
        private Map<String, Coordinate> tentative_coordinates = new HashMap<String, Coordinate>();
        private FleetSize fleetSize = FleetSize.INFINITE;
        private Map<String, VehicleType> vehicleTypes = new HashMap<String, VehicleType>();
        private Collection<VehicleRoute> initialRoutes = new ArrayList<VehicleRoute>();
        private Set<Vehicle> uniqueVehicles = new LinkedHashSet<Vehicle>();
        private Set<String> addedVehicleIds = new LinkedHashSet<String>();
        private JobActivityFactory jobActivityFactory = new JobActivityFactory(){

            @Override
            public List<AbstractActivity> createActivities(Job job) {
                ArrayList<AbstractActivity> acts = new ArrayList<AbstractActivity>();
                if (job instanceof Break) {
                    acts.add(BreakActivity.newInstance((Break)job));
                } else if (job instanceof Service) {
                    acts.add(serviceActivityFactory.createActivity((Service)job));
                } else if (job instanceof Shipment) {
                    acts.add(shipmentActivityFactory.createPickup((Shipment)job));
                    acts.add(shipmentActivityFactory.createDelivery((Shipment)job));
                }
                return acts;
            }
        };
        private int vehicleIndexCounter = 1;
        private int activityIndexCounter = 1;
        private int vehicleTypeIdIndexCounter = 1;
        private Map<VehicleTypeKey, Integer> typeKeyIndices = new HashMap<VehicleTypeKey, Integer>();
        private Map<Job, List<AbstractActivity>> activityMap = new HashMap<Job, List<AbstractActivity>>();
        private final DefaultShipmentActivityFactory shipmentActivityFactory = new DefaultShipmentActivityFactory();
        private final DefaultTourActivityFactory serviceActivityFactory = new DefaultTourActivityFactory();
        private Set<Location> allLocations = new HashSet<Location>();
        private final List<AbstractActivity> nonJobActivities = new ArrayList<AbstractActivity>();

        public static Builder newInstance() {
            return new Builder();
        }

        private void incActivityIndexCounter() {
            ++this.activityIndexCounter;
        }

        private void incVehicleTypeIdIndexCounter() {
            ++this.vehicleTypeIdIndexCounter;
        }

        public Map<String, Coordinate> getLocationMap() {
            return Collections.unmodifiableMap(this.tentative_coordinates);
        }

        public Locations getLocations() {
            return id -> this.tentative_coordinates.get(id);
        }

        public Builder setRoutingCost(VehicleRoutingTransportCosts costs) {
            this.transportCosts = costs;
            return this;
        }

        public Builder setJobActivityFactory(JobActivityFactory jobActivityFactory) {
            this.jobActivityFactory = jobActivityFactory;
            return this;
        }

        public Builder setFleetSize(FleetSize fleetSize) {
            this.fleetSize = fleetSize;
            return this;
        }

        public Builder addJob(Job job) {
            if (!(job instanceof AbstractJob)) {
                throw new IllegalArgumentException("job must be of type AbstractJob");
            }
            return this.addJob((AbstractJob)job);
        }

        public Builder addJob(AbstractJob job) {
            if (this.tentativeJobs.containsKey(job.getId())) {
                throw new IllegalArgumentException("The vehicle routing problem already contains a service or shipment with id " + job.getId() + ". Please make sure you use unique ids for all services and shipments.");
            }
            if (!(job instanceof Service) && !(job instanceof Shipment)) {
                throw new IllegalArgumentException("Job must be either a service or a shipment.");
            }
            this.tentativeJobs.put(job.getId(), job);
            this.addLocationToTentativeLocations(job);
            return this;
        }

        private void addLocationToTentativeLocations(Job job) {
            for (Activity act : job.getActivities()) {
                this.addLocationToTentativeLocations(act.getLocation());
            }
        }

        private void addLocationToTentativeLocations(Location location) {
            if (location == null) {
                return;
            }
            this.tentative_coordinates.put(location.getId(), location.getCoordinate());
            this.allLocations.add(location);
        }

        private void addJobToFinalJobMapAndCreateActivities(Job job) {
            this.addJobToFinalMap(job);
            List<AbstractActivity> jobActs = this.jobActivityFactory.createActivities(job);
            for (AbstractActivity act : jobActs) {
                act.setIndex(this.activityIndexCounter);
                this.incActivityIndexCounter();
            }
            this.activityMap.put(job, jobActs);
        }

        private boolean addBreaksToActivityMap() {
            boolean hasBreaks = false;
            HashSet<String> uniqueBreakIds = new HashSet<String>();
            for (Vehicle v : this.uniqueVehicles) {
                if (v.getBreak() == null) continue;
                if (!uniqueBreakIds.add(v.getBreak().getId())) {
                    throw new IllegalArgumentException("The vehicle routing roblem already contains a vehicle break with id " + v.getBreak().getId() + ". Please choose unique ids for each vehicle break.");
                }
                hasBreaks = true;
                List<AbstractActivity> breakActivities = this.jobActivityFactory.createActivities(v.getBreak());
                if (breakActivities.isEmpty()) {
                    throw new IllegalArgumentException("At least one activity for break needs to be created by activityFactory.");
                }
                for (AbstractActivity act : breakActivities) {
                    act.setIndex(this.activityIndexCounter);
                    this.incActivityIndexCounter();
                }
                this.activityMap.put(v.getBreak(), breakActivities);
            }
            return hasBreaks;
        }

        public Builder addInitialVehicleRoute(VehicleRoute route) {
            if (!this.addedVehicleIds.contains(route.getVehicle().getId())) {
                this.addVehicle((AbstractVehicle)route.getVehicle());
                this.addedVehicleIds.add(route.getVehicle().getId());
            }
            for (TourActivity act : route.getActivities()) {
                AbstractActivity abstractAct = (AbstractActivity)act;
                abstractAct.setIndex(this.activityIndexCounter);
                this.incActivityIndexCounter();
                if (!(act instanceof TourActivity.JobActivity)) continue;
                Job job = ((TourActivity.JobActivity)act).getJob();
                this.jobsInInitialRoutes.put(job.getId(), job);
                this.addLocationToTentativeLocations(job);
                this.registerJobAndActivity(abstractAct, job);
            }
            this.initialRoutes.add(route);
            return this;
        }

        private void registerJobAndActivity(AbstractActivity abstractAct, Job job) {
            if (this.activityMap.containsKey(job)) {
                this.activityMap.get(job).add(abstractAct);
            } else {
                ArrayList<AbstractActivity> actList = new ArrayList<AbstractActivity>();
                actList.add(abstractAct);
                this.activityMap.put(job, actList);
            }
        }

        public Builder addInitialVehicleRoutes(Collection<VehicleRoute> routes) {
            for (VehicleRoute r : routes) {
                this.addInitialVehicleRoute(r);
            }
            return this;
        }

        private void addJobToFinalMap(Job job) {
            if (this.jobs.containsKey(job.getId())) {
                logger.warn("The job " + job + " has already been added to the job list. This overrides the existing job.");
            }
            this.addLocationToTentativeLocations(job);
            this.jobs.put(job.getId(), job);
            boolean hasLocation = true;
            for (Activity activity : job.getActivities()) {
                if (activity.getLocation() != null) continue;
                hasLocation = false;
            }
            if (hasLocation) {
                this.jobsWithLocation.add(job);
            }
        }

        public Builder addVehicle(Vehicle vehicle) {
            if (!(vehicle instanceof AbstractVehicle)) {
                throw new IllegalArgumentException("A vehicle must be an AbstractVehicle.");
            }
            return this.addVehicle((AbstractVehicle)vehicle);
        }

        public Builder addVehicle(AbstractVehicle vehicle) {
            if (this.addedVehicleIds.contains(vehicle.getId())) {
                throw new IllegalArgumentException("The vehicle routing problem already contains a vehicle with id " + vehicle.getId() + ". Please choose unique ids for each vehicle.");
            }
            this.addedVehicleIds.add(vehicle.getId());
            if (!this.uniqueVehicles.contains(vehicle)) {
                vehicle.setIndex(this.vehicleIndexCounter);
                this.incVehicleIndexCounter();
            }
            if (this.typeKeyIndices.containsKey(vehicle.getVehicleTypeIdentifier())) {
                vehicle.getVehicleTypeIdentifier().setIndex(this.typeKeyIndices.get(vehicle.getVehicleTypeIdentifier()));
            } else {
                vehicle.getVehicleTypeIdentifier().setIndex(this.vehicleTypeIdIndexCounter);
                this.typeKeyIndices.put(vehicle.getVehicleTypeIdentifier(), this.vehicleTypeIdIndexCounter);
                this.incVehicleTypeIdIndexCounter();
            }
            this.uniqueVehicles.add(vehicle);
            if (!this.vehicleTypes.containsKey(vehicle.getType().getTypeId())) {
                this.vehicleTypes.put(vehicle.getType().getTypeId(), vehicle.getType());
            } else {
                VehicleType existingType = this.vehicleTypes.get(vehicle.getType().getTypeId());
                if (!vehicle.getType().equals(existingType)) {
                    throw new IllegalArgumentException("A type with type id " + vehicle.getType().getTypeId() + " already exists. However, types are different. Please use unique vehicle types only.");
                }
            }
            String startLocationId = vehicle.getStartLocation().getId();
            this.addLocationToTentativeLocations(vehicle.getStartLocation());
            if (!vehicle.getEndLocation().getId().equals(startLocationId)) {
                this.addLocationToTentativeLocations(vehicle.getEndLocation());
            }
            return this;
        }

        private void incVehicleIndexCounter() {
            ++this.vehicleIndexCounter;
        }

        public Builder setActivityCosts(VehicleRoutingActivityCosts activityCosts) {
            this.activityCosts = activityCosts;
            return this;
        }

        public Builder addNonJobActivities(Collection<? extends AbstractActivity> nonJobActivities) {
            for (AbstractActivity abstractActivity : nonJobActivities) {
                abstractActivity.setIndex(this.activityIndexCounter);
                this.incActivityIndexCounter();
                this.nonJobActivities.add(abstractActivity);
            }
            return this;
        }

        public VehicleRoutingProblem build() {
            if (this.transportCosts == null) {
                this.transportCosts = new CrowFlyCosts(this.getLocations());
            }
            for (Job job : this.tentativeJobs.values()) {
                if (this.jobsInInitialRoutes.containsKey(job.getId())) continue;
                this.addJobToFinalJobMapAndCreateActivities(job);
            }
            int jobIndexCounter = 1;
            for (Job job : this.jobs.values()) {
                ((AbstractJob)job).setIndex(jobIndexCounter++);
            }
            for (Job job : this.jobsInInitialRoutes.values()) {
                ((AbstractJob)job).setIndex(jobIndexCounter++);
            }
            boolean bl = this.addBreaksToActivityMap();
            if (bl && this.fleetSize.equals((Object)FleetSize.INFINITE)) {
                throw new UnsupportedOperationException("Breaks are not yet supported when dealing with infinite fleet. Either set it to finite or omit breaks.");
            }
            return new VehicleRoutingProblem(this);
        }

        @Deprecated
        public Builder addLocation(String locationId, Coordinate coordinate) {
            this.tentative_coordinates.put(locationId, coordinate);
            return this;
        }

        public Builder addAllJobs(Collection<? extends Job> jobs) {
            for (Job job : jobs) {
                this.addJob(job);
            }
            return this;
        }

        public Builder addAllVehicles(Collection<? extends Vehicle> vehicles) {
            for (Vehicle vehicle : vehicles) {
                this.addVehicle(vehicle);
            }
            return this;
        }

        public Collection<Vehicle> getAddedVehicles() {
            return Collections.unmodifiableCollection(this.uniqueVehicles);
        }

        public Collection<VehicleType> getAddedVehicleTypes() {
            return Collections.unmodifiableCollection(this.vehicleTypes.values());
        }

        public Collection<Job> getAddedJobs() {
            return Collections.unmodifiableCollection(this.tentativeJobs.values());
        }
    }
}

