/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem.constraint;

import com.graphhopper.jsprit.core.algorithm.state.InternalStates;
import com.graphhopper.jsprit.core.problem.Capacity;
import com.graphhopper.jsprit.core.problem.constraint.HardActivityConstraint;
import com.graphhopper.jsprit.core.problem.misc.JobInsertionContext;
import com.graphhopper.jsprit.core.problem.solution.route.activity.DeliverShipment;
import com.graphhopper.jsprit.core.problem.solution.route.activity.PickupShipment;
import com.graphhopper.jsprit.core.problem.solution.route.activity.Start;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.problem.solution.route.state.RouteAndActivityStateGetter;

public class PickupAndDeliverShipmentLoadActivityLevelConstraint
implements HardActivityConstraint {
    private RouteAndActivityStateGetter stateManager;
    private Capacity defaultValue;

    public PickupAndDeliverShipmentLoadActivityLevelConstraint(RouteAndActivityStateGetter stateManager) {
        this.stateManager = stateManager;
        this.defaultValue = Capacity.Builder.newInstance().build();
    }

    @Override
    public HardActivityConstraint.ConstraintsStatus fulfilled(JobInsertionContext iFacts, TourActivity prevAct, TourActivity newAct, TourActivity nextAct, double prevActDepTime) {
        Capacity loadAtPrevAct;
        if (!(newAct instanceof PickupShipment) && !(newAct instanceof DeliverShipment)) {
            return HardActivityConstraint.ConstraintsStatus.FULFILLED;
        }
        if (prevAct instanceof Start) {
            loadAtPrevAct = this.stateManager.getRouteState(iFacts.getRoute(), InternalStates.LOAD_AT_BEGINNING, Capacity.class);
            if (loadAtPrevAct == null) {
                loadAtPrevAct = this.defaultValue;
            }
        } else {
            loadAtPrevAct = this.stateManager.getActivityState(prevAct, InternalStates.LOAD, Capacity.class);
            if (loadAtPrevAct == null) {
                loadAtPrevAct = this.defaultValue;
            }
        }
        if (newAct instanceof PickupShipment && !Capacity.addup(loadAtPrevAct, newAct.getSize()).isLessOrEqual(iFacts.getNewVehicle().getType().getCapacityDimensions())) {
            return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED;
        }
        if (newAct instanceof DeliverShipment && !Capacity.addup(loadAtPrevAct, Capacity.invert(newAct.getSize())).isLessOrEqual(iFacts.getNewVehicle().getType().getCapacityDimensions())) {
            return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED_BREAK;
        }
        return HardActivityConstraint.ConstraintsStatus.FULFILLED;
    }
}

