/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.reporting;

import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Break;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.job.Shipment;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.util.VehicleIndexComparator;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;

public class SolutionPrinter {
    private static final PrintWriter SYSTEM_OUT_AS_PRINT_WRITER = new PrintWriter(System.out);

    public static void print(VehicleRoutingProblemSolution solution) {
        SolutionPrinter.print(SYSTEM_OUT_AS_PRINT_WRITER, solution);
        SYSTEM_OUT_AS_PRINT_WRITER.flush();
    }

    public static void print(PrintWriter out, VehicleRoutingProblemSolution solution) {
        out.println("[costs=" + solution.getCost() + "]");
        out.println("[#vehicles=" + solution.getRoutes().size() + "]");
    }

    public static void print(VehicleRoutingProblem problem, VehicleRoutingProblemSolution solution, Print print) {
        SolutionPrinter.print(SYSTEM_OUT_AS_PRINT_WRITER, problem, solution, print);
        SYSTEM_OUT_AS_PRINT_WRITER.flush();
    }

    public static void print(PrintWriter out, VehicleRoutingProblem problem, VehicleRoutingProblemSolution solution, Print print) {
        String leftAlign = "| %-13s | %-8s | %n";
        out.format("+--------------------------+%n", new Object[0]);
        out.printf("| problem                  |%n", new Object[0]);
        out.format("+---------------+----------+%n", new Object[0]);
        out.printf("| indicator     | value    |%n", new Object[0]);
        out.format("+---------------+----------+%n", new Object[0]);
        out.format(leftAlign, "noJobs", problem.getJobs().values().size());
        Jobs jobs = SolutionPrinter.getNuOfJobs(problem);
        out.format(leftAlign, "noServices", jobs.nServices);
        out.format(leftAlign, "noShipments", jobs.nShipments);
        out.format(leftAlign, "noBreaks", jobs.nBreaks);
        out.format(leftAlign, "fleetsize", problem.getFleetSize().toString());
        out.format("+--------------------------+%n", new Object[0]);
        String leftAlignSolution = "| %-13s | %-40s | %n";
        out.format("+----------------------------------------------------------+%n", new Object[0]);
        out.printf("| solution                                                 |%n", new Object[0]);
        out.format("+---------------+------------------------------------------+%n", new Object[0]);
        out.printf("| indicator     | value                                    |%n", new Object[0]);
        out.format("+---------------+------------------------------------------+%n", new Object[0]);
        out.format(leftAlignSolution, "costs", solution.getCost());
        out.format(leftAlignSolution, "noVehicles", solution.getRoutes().size());
        out.format(leftAlignSolution, "unassgndJobs", solution.getUnassignedJobs().size());
        out.format("+----------------------------------------------------------+%n", new Object[0]);
        if (print.equals((Object)Print.VERBOSE)) {
            SolutionPrinter.printVerbose(out, problem, solution);
        }
    }

    private static void printVerbose(VehicleRoutingProblem problem, VehicleRoutingProblemSolution solution) {
        SolutionPrinter.printVerbose(SYSTEM_OUT_AS_PRINT_WRITER, problem, solution);
        SYSTEM_OUT_AS_PRINT_WRITER.flush();
    }

    private static void printVerbose(PrintWriter out, VehicleRoutingProblem problem, VehicleRoutingProblemSolution solution) {
        String leftAlgin = "| %-7s | %-20s | %-21s | %-15s | %-15s | %-15s | %-15s |%n";
        out.format("+--------------------------------------------------------------------------------------------------------------------------------+%n", new Object[0]);
        out.printf("| detailed solution                                                                                                              |%n", new Object[0]);
        out.format("+---------+----------------------+-----------------------+-----------------+-----------------+-----------------+-----------------+%n", new Object[0]);
        out.printf("| route   | vehicle              | activity              | job             | arrTime         | endTime         | costs           |%n", new Object[0]);
        int routeNu = 1;
        ArrayList<VehicleRoute> list = new ArrayList<VehicleRoute>(solution.getRoutes());
        Collections.sort(list, new VehicleIndexComparator());
        for (VehicleRoute route : list) {
            out.format("+---------+----------------------+-----------------------+-----------------+-----------------+-----------------+-----------------+%n", new Object[0]);
            double costs = 0.0;
            out.format(leftAlgin, routeNu, SolutionPrinter.getVehicleString(route), route.getStart().getName(), "-", "undef", Math.round(route.getStart().getEndTime()), Math.round(costs));
            TourActivity prevAct = route.getStart();
            for (TourActivity act : route.getActivities()) {
                String jobId = act instanceof TourActivity.JobActivity ? ((TourActivity.JobActivity)act).getJob().getId() : "-";
                double c = problem.getTransportCosts().getTransportCost(prevAct.getLocation(), act.getLocation(), prevAct.getEndTime(), route.getDriver(), route.getVehicle());
                out.format(leftAlgin, routeNu, SolutionPrinter.getVehicleString(route), act.getName(), jobId, Math.round(act.getArrTime()), Math.round(act.getEndTime()), Math.round(costs += (c += problem.getActivityCosts().getActivityCost(act, act.getArrTime(), route.getDriver(), route.getVehicle()))));
                prevAct = act;
            }
            double c = problem.getTransportCosts().getTransportCost(prevAct.getLocation(), route.getEnd().getLocation(), prevAct.getEndTime(), route.getDriver(), route.getVehicle());
            out.format(leftAlgin, routeNu, SolutionPrinter.getVehicleString(route), route.getEnd().getName(), "-", Math.round(route.getEnd().getArrTime()), "undef", Math.round(costs += (c += problem.getActivityCosts().getActivityCost(route.getEnd(), route.getEnd().getArrTime(), route.getDriver(), route.getVehicle()))));
            ++routeNu;
        }
        out.format("+--------------------------------------------------------------------------------------------------------------------------------+%n", new Object[0]);
        if (!solution.getUnassignedJobs().isEmpty()) {
            out.format("+----------------+%n", new Object[0]);
            out.format("| unassignedJobs |%n", new Object[0]);
            out.format("+----------------+%n", new Object[0]);
            String unassignedJobAlgin = "| %-14s |%n";
            for (Job j : solution.getUnassignedJobs()) {
                out.format(unassignedJobAlgin, j.getId());
            }
            out.format("+----------------+%n", new Object[0]);
        }
    }

    private static String getVehicleString(VehicleRoute route) {
        return route.getVehicle().getId();
    }

    private static Jobs getNuOfJobs(VehicleRoutingProblem problem) {
        int nShipments = 0;
        int nServices = 0;
        int nBreaks = 0;
        for (Job j : problem.getJobs().values()) {
            if (j instanceof Shipment) {
                ++nShipments;
            }
            if (j instanceof Service) {
                ++nServices;
            }
            if (!(j instanceof Break)) continue;
            ++nBreaks;
        }
        return new Jobs(nServices, nShipments, nBreaks);
    }

    private static class Jobs {
        int nServices;
        int nShipments;
        int nBreaks;

        public Jobs(int nServices, int nShipments, int nBreaks) {
            this.nServices = nServices;
            this.nShipments = nShipments;
            this.nBreaks = nBreaks;
        }
    }

    public static enum Print {
        CONCISE,
        VERBOSE;

    }
}

