/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.util;

import com.graphhopper.jsprit.core.problem.cost.ForwardTransportTime;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingActivityCosts;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.ActivityVisitor;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;

public class ActivityTimeTracker
implements ActivityVisitor {
    private final ForwardTransportTime transportTime;
    private final VehicleRoutingActivityCosts activityCosts;
    private TourActivity prevAct = null;
    private double startAtPrevAct;
    private VehicleRoute route;
    private boolean beginFirst = false;
    private double actArrTime;
    private double actEndTime;
    private ActivityPolicy activityPolicy = ActivityPolicy.AS_SOON_AS_TIME_WINDOW_OPENS;

    public ActivityTimeTracker(ForwardTransportTime transportTime, VehicleRoutingActivityCosts activityCosts) {
        this.transportTime = transportTime;
        this.activityCosts = activityCosts;
    }

    public ActivityTimeTracker(ForwardTransportTime transportTime, ActivityPolicy activityPolicy, VehicleRoutingActivityCosts activityCosts) {
        this.transportTime = transportTime;
        this.activityPolicy = activityPolicy;
        this.activityCosts = activityCosts;
    }

    public double getActArrTime() {
        return this.actArrTime;
    }

    public double getActEndTime() {
        return this.actEndTime;
    }

    @Override
    public void begin(VehicleRoute route) {
        this.prevAct = route.getStart();
        this.actEndTime = this.startAtPrevAct = this.prevAct.getEndTime();
        this.route = route;
        this.beginFirst = true;
    }

    @Override
    public void visit(TourActivity activity) {
        double operationEndTime;
        double arrivalTimeAtCurrAct;
        if (!this.beginFirst) {
            throw new IllegalStateException("never called begin. this however is essential here");
        }
        double transportTime = this.transportTime.getTransportTime(this.prevAct.getLocation(), activity.getLocation(), this.startAtPrevAct, this.route.getDriver(), this.route.getVehicle());
        this.actArrTime = arrivalTimeAtCurrAct = this.startAtPrevAct + transportTime;
        double operationStartTime = this.activityPolicy.equals((Object)ActivityPolicy.AS_SOON_AS_TIME_WINDOW_OPENS) ? Math.max(activity.getTheoreticalEarliestOperationStartTime(), arrivalTimeAtCurrAct) : (this.activityPolicy.equals((Object)ActivityPolicy.AS_SOON_AS_ARRIVED) ? this.actArrTime : this.actArrTime);
        this.actEndTime = operationEndTime = operationStartTime + this.activityCosts.getActivityDuration(activity, this.actArrTime, this.route.getDriver(), this.route.getVehicle());
        this.prevAct = activity;
        this.startAtPrevAct = operationEndTime;
    }

    @Override
    public void finish() {
        double arrivalTimeAtCurrAct;
        double transportTime = this.transportTime.getTransportTime(this.prevAct.getLocation(), this.route.getEnd().getLocation(), this.startAtPrevAct, this.route.getDriver(), this.route.getVehicle());
        this.actArrTime = arrivalTimeAtCurrAct = this.startAtPrevAct + transportTime;
        this.actEndTime = arrivalTimeAtCurrAct;
        this.beginFirst = false;
    }

    public static enum ActivityPolicy {
        AS_SOON_AS_TIME_WINDOW_OPENS,
        AS_SOON_AS_ARRIVED;

    }
}

