/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.util;

import com.graphhopper.jsprit.core.util.Coordinate;
import com.graphhopper.jsprit.core.util.DistanceUnit;

public class GreatCircleDistanceCalculator {
    private static final double R = 6372.8;

    public static double calculateDistance(Coordinate coord1, Coordinate coord2, DistanceUnit distanceUnit) {
        double lon1 = coord1.getX();
        double lon2 = coord2.getX();
        double lat1 = coord1.getY();
        double lat2 = coord2.getY();
        double delta_Lat = Math.toRadians(lat2 - lat1);
        double delta_Lon = Math.toRadians(lon2 - lon1);
        lat1 = Math.toRadians(lat1);
        lat2 = Math.toRadians(lat2);
        double a = Math.sin(delta_Lat / 2.0) * Math.sin(delta_Lat / 2.0) + Math.sin(delta_Lon / 2.0) * Math.sin(delta_Lon / 2.0) * Math.cos(lat1) * Math.cos(lat2);
        double c = 2.0 * Math.asin(Math.sqrt(a));
        double distance = 6372.8 * c;
        if (distanceUnit.equals((Object)DistanceUnit.Meter)) {
            distance *= 1000.0;
        }
        return distance;
    }
}

