/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.util;

public class Time {
    public static String parseSecondsToTime(double seconds) {
        int hours = (int)Math.floor(seconds / 3600.0);
        int min = (int)Math.floor((seconds - (double)hours * 3600.0) / 60.0);
        int secs = (int)(seconds - ((double)hours * 3600.0 + (double)min * 60.0));
        String dayTime = "AM";
        if (hours > 12) {
            dayTime = "PM";
            hours -= 12;
        }
        String hourString = "0" + hours;
        if (hours > 9) {
            hourString = "" + hours;
        }
        String minString = "" + min;
        if (min < 10) {
            minString = "0" + min;
        }
        String secString = "" + secs;
        if (secs < 10) {
            secString = "0" + secs;
        }
        return hourString + ":" + minString + ":" + secString + " " + dayTime;
    }

    public static double parseTimeToSeconds(String timeString) {
        String[] tokens;
        if (timeString.substring(0, 1).matches("\\D")) {
            throw new IllegalArgumentException("timeString must start with digit [0-9]");
        }
        double dayTime = 0.0;
        if (timeString.toLowerCase().contains("pm")) {
            dayTime = 43200.0;
        }
        if ((tokens = timeString.split(":")).length == 1) {
            return Time.getHourInSeconds(tokens[0]) + dayTime;
        }
        if (tokens.length == 2) {
            return Time.getHourInSeconds(tokens[0]) + Time.getMinInSeconds(tokens[1]) + dayTime;
        }
        if (tokens.length == 3) {
            return Time.getHourInSeconds(tokens[0]) + Time.getMinInSeconds(tokens[1]) + Time.getSecondsInSeconds(tokens[2]) + dayTime;
        }
        throw new IllegalArgumentException("wrong timeString");
    }

    private static double getSecondsInSeconds(String secString) {
        return Time.getDigit(secString);
    }

    private static double getMinInSeconds(String minString) {
        return Time.getDigit(minString) * 60.0;
    }

    private static double getHourInSeconds(String hourString) {
        return Time.getDigit(hourString) * 3600.0;
    }

    private static double getDigit(String digitString) {
        if (digitString.length() == 1) {
            return Double.parseDouble(digitString);
        }
        if (digitString.substring(1, 2).matches("\\D")) {
            return Double.parseDouble(digitString.substring(0, 1));
        }
        if (digitString.startsWith("0")) {
            return Double.parseDouble(digitString.substring(1, 2));
        }
        return Double.parseDouble(digitString.substring(0, 2));
    }
}

